
from typing import Tuple, Optional, Union
import pickle
class Tensor:
    def abs(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def abs_(self) -> 'Tensor': ...

    def acos(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def acos_(self) -> 'Tensor': ...

    @overload
    def add(self, other: 'Tensor', alpha: float=1, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def add(self, other: float, alpha: float=1, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def add_(self, other: 'Tensor', alpha: float=1) -> 'Tensor': ...

    @overload
    def add_(self, other: float, alpha: float=1) -> 'Tensor': ...

    def addbmm(self, batch1: 'Tensor', batch2: 'Tensor', beta: float=1, alpha: float=1, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def addbmm_(self, batch1: 'Tensor', batch2: 'Tensor', beta: float=1, alpha: float=1) -> 'Tensor': ...

    def addcdiv(self, tensor1: 'Tensor', tensor2: 'Tensor', value: float=1, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def addcdiv_(self, tensor1: 'Tensor', tensor2: 'Tensor', value: float=1) -> 'Tensor': ...

    def addcmul(self, tensor1: 'Tensor', tensor2: 'Tensor', value: float=1, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def addcmul_(self, tensor1: 'Tensor', tensor2: 'Tensor', value: float=1) -> 'Tensor': ...

    def addmm(self, mat1: 'Tensor', mat2: 'Tensor', beta: float=1, alpha: float=1, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def addmm_(self, mat1: 'Tensor', mat2: 'Tensor', beta: float=1, alpha: float=1) -> 'Tensor': ...

    def addmv(self, mat: 'Tensor', vec: 'Tensor', beta: float=1, alpha: float=1, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def addmv_(self, mat: 'Tensor', vec: 'Tensor', beta: float=1, alpha: float=1) -> 'Tensor': ...

    def addr(self, vec1: 'Tensor', vec2: 'Tensor', beta: float=1, alpha: float=1, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def addr_(self, vec1: 'Tensor', vec2: 'Tensor', beta: float=1, alpha: float=1) -> 'Tensor': ...

    @overload
    def all(self, dim: int, keepdim: bool=False, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def all(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def allclose(self, other: 'Tensor', rtol: float=1e-05, atol: float=1e-08, equal_nan: bool=False) -> bool: ...

    @overload
    def any(self, dim: int, keepdim: bool=False, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def any(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def argmax(self, dim=None, keepdim=False): ...

    def argmin(self, dim=None, keepdim=False): ...

    def argsort(self, dim=None, descending=False): ...

    def asin(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def asin_(self) -> 'Tensor': ...

    def atan(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def atan2(self, other: 'Tensor', *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def atan2_(self, other: 'Tensor') -> 'Tensor': ...

    def atan_(self) -> 'Tensor': ...

    def backward(self, gradient=None, retain_graph=None, create_graph=False): ...

    def baddbmm(self, batch1: 'Tensor', batch2: 'Tensor', beta: float=1, alpha: float=1, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def baddbmm_(self, batch1: 'Tensor', batch2: 'Tensor', beta: float=1, alpha: float=1) -> 'Tensor': ...

    @overload
    def bernoulli(self, generator: Generator=nullptr, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def bernoulli(self, p: float, generator: Generator=nullptr, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def bernoulli_(self, p: 'Tensor', generator: Generator=nullptr) -> 'Tensor': ...

    @overload
    def bernoulli_(self, p: float=0.5, generator: Generator=nullptr) -> 'Tensor': ...

    def bincount(self, weights: Optional['Tensor']={}, minlength: int=0) -> 'Tensor': ...

    def bmm(self, mat2: 'Tensor', *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def btrifact(self, info=None, pivot=True): ...

    def btrifact_with_info(self, pivot: bool=True, *, out: Optional['Tensor']=None) -> Tuple['Tensor', 'Tensor', 'Tensor']: ...

    def btrisolve(self, LU_data: 'Tensor', LU_pivots: 'Tensor', *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def cauchy_(self, median: float=0, sigma: float=1, generator: Generator=nullptr) -> 'Tensor': ...

    def ceil(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def ceil_(self) -> 'Tensor': ...

    def cholesky(self, upper: bool=False, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def chunk(self, chunks: int, dim: int=0) -> Tuple['Tensor', ...]: ...

    def clamp(self, min: Optional[float]=c10::nullopt, max: Optional[float]=c10::nullopt, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def clamp_(self, min: Optional[float]=c10::nullopt, max: Optional[float]=c10::nullopt) -> 'Tensor': ...

    def clone(self) -> 'Tensor': ...

    def contiguous(self) -> 'Tensor': ...

    def cos(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def cos_(self) -> 'Tensor': ...

    def cosh(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def cosh_(self) -> 'Tensor': ...

    def cross(self, other: 'Tensor', dim: int=-1, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def cumprod(self, dim: int, dtype: dtype, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def cumprod(self, dim: int, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def cumsum(self, dim: int, dtype: dtype, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def cumsum(self, dim: int, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def data_ptr(self) -> int: ...

    def dense_dim(self) -> int: ...

    def det(self) -> 'Tensor': ...

    def detach(self) -> 'Tensor': ...

    def detach_(self) -> 'Tensor': ...

    def diag(self, diagonal: int=0, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def diag_embed(self, offset: int=0, dim1: int=-2, dim2: int=-1) -> 'Tensor': ...

    def diagflat(self, offset: int=0) -> 'Tensor': ...

    def diagonal(self, offset: int=0, dim1: int=0, dim2: int=1) -> 'Tensor': ...

    def digamma(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def digamma_(self) -> 'Tensor': ...

    def dist(self, other: 'Tensor', p: float=2) -> 'Tensor': ...

    @overload
    def div(self, other: 'Tensor', *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def div(self, other: float, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def div_(self, other: 'Tensor') -> 'Tensor': ...

    @overload
    def div_(self, other: float) -> 'Tensor': ...

    def dot(self, tensor: 'Tensor', *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def eig(self, eigenvectors: bool=False, *, out: Optional['Tensor']=None) -> Tuple['Tensor', 'Tensor']: ...

    @overload
    def eq(self, other: float, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def eq(self, other: 'Tensor', *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def eq_(self, other: float) -> 'Tensor': ...

    @overload
    def eq_(self, other: 'Tensor') -> 'Tensor': ...

    def equal(self, other: 'Tensor') -> bool: ...

    def erf(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def erf_(self) -> 'Tensor': ...

    def erfc(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def erfc_(self) -> 'Tensor': ...

    def erfinv(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def erfinv_(self) -> 'Tensor': ...

    def exp(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def exp_(self) -> 'Tensor': ...

    def expand(self, size: Tuple[int, ...], implicit: bool=False) -> 'Tensor': ...

    def expand_as(self, other: 'Tensor') -> 'Tensor': ...

    def expm1(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def expm1_(self) -> 'Tensor': ...

    def exponential_(self, lambd: float=1, generator: Generator=nullptr) -> 'Tensor': ...

    def fft(self, signal_ndim: int, normalized: bool=False) -> 'Tensor': ...

    @overload
    def fill_(self, value: float) -> 'Tensor': ...

    @overload
    def fill_(self, value: 'Tensor') -> 'Tensor': ...

    def flatten(self, start_dim: int=0, end_dim: int=-1) -> 'Tensor': ...

    def flip(self, dims: Tuple[int, ...]) -> 'Tensor': ...

    def floor(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def floor_(self) -> 'Tensor': ...

    @overload
    def fmod(self, other: float, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def fmod(self, other: 'Tensor', *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def fmod_(self, other: float) -> 'Tensor': ...

    @overload
    def fmod_(self, other: 'Tensor') -> 'Tensor': ...

    def frac(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def frac_(self) -> 'Tensor': ...

    def gather(self, dim: int, index: 'Tensor', *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def ge(self, other: float, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def ge(self, other: 'Tensor', *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def ge_(self, other: float) -> 'Tensor': ...

    @overload
    def ge_(self, other: 'Tensor') -> 'Tensor': ...

    def gels(self, A: 'Tensor', *, out: Optional['Tensor']=None) -> Tuple['Tensor', 'Tensor']: ...

    def geometric_(self, p: float, generator: Generator=nullptr) -> 'Tensor': ...

    def geqrf(self, *, out: Optional['Tensor']=None) -> Tuple['Tensor', 'Tensor']: ...

    def ger(self, vec2: 'Tensor', *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def gesv(self, A: 'Tensor', *, out: Optional['Tensor']=None) -> Tuple['Tensor', 'Tensor']: ...

    @overload
    def gt(self, other: float, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def gt(self, other: 'Tensor', *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def gt_(self, other: float) -> 'Tensor': ...

    @overload
    def gt_(self, other: 'Tensor') -> 'Tensor': ...

    def hardshrink(self, lambd: float=0.5) -> 'Tensor': ...

    def histc(self, bins: int=100, min: float=0, max: float=0, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def ifft(self, signal_ndim: int, normalized: bool=False) -> 'Tensor': ...

    def index_add(self, dim, index, tensor): ...

    def index_add_(self, dim: int, index: 'Tensor', source: 'Tensor') -> 'Tensor': ...

    def index_copy(self, dim, index, tensor): ...

    def index_copy_(self, dim: int, index: 'Tensor', source: 'Tensor') -> 'Tensor': ...

    def index_fill(self, dim, index, value): ...

    @overload
    def index_fill_(self, dim: int, index: 'Tensor', value: float) -> 'Tensor': ...

    @overload
    def index_fill_(self, dim: int, index: 'Tensor', value: 'Tensor') -> 'Tensor': ...

    def index_put_(self, indices: Tuple['Tensor', ...], values: 'Tensor', accumulate: bool=False) -> 'Tensor': ...

    def index_select(self, dim: int, index: 'Tensor', *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def indices(self) -> 'Tensor': ...

    def inverse(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def irfft(self, signal_ndim: int, normalized: bool=False, onesided: bool=True, signal_sizes: Tuple[int, ...]={}) -> 'Tensor': ...

    def is_pinned(self): ...

    def is_set_to(self, tensor: 'Tensor') -> bool: ...

    def is_shared(self): ...

    def item(self) -> float: ...

    def kthvalue(self, k: int, dim: int=-1, keepdim: bool=False, *, out: Optional['Tensor']=None) -> Tuple['Tensor', 'Tensor']: ...

    @overload
    def le(self, other: float, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def le(self, other: 'Tensor', *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def le_(self, other: float) -> 'Tensor': ...

    @overload
    def le_(self, other: 'Tensor') -> 'Tensor': ...

    def lerp(self, end: 'Tensor', weight: float, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def lerp_(self, end: 'Tensor', weight: float) -> 'Tensor': ...

    def log(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def log10(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def log10_(self) -> 'Tensor': ...

    def log1p(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def log1p_(self) -> 'Tensor': ...

    def log2(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def log2_(self) -> 'Tensor': ...

    def log_(self) -> 'Tensor': ...

    def log_normal_(self, mean: float=1, std: float=2, generator: Generator=nullptr) -> 'Tensor': ...

    def logdet(self) -> 'Tensor': ...

    def logsumexp(self, dim: int, keepdim: bool=False, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def lt(self, other: float, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def lt(self, other: 'Tensor', *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def lt_(self, other: float) -> 'Tensor': ...

    @overload
    def lt_(self, other: 'Tensor') -> 'Tensor': ...

    def masked_fill(self, mask, value): ...

    @overload
    def masked_fill_(self, mask: 'Tensor', value: float) -> 'Tensor': ...

    @overload
    def masked_fill_(self, mask: 'Tensor', value: 'Tensor') -> 'Tensor': ...

    def masked_scatter(self, mask, tensor): ...

    def masked_scatter_(self, mask: 'Tensor', source: 'Tensor') -> 'Tensor': ...

    def masked_select(self, mask: 'Tensor', *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def matmul(self, other: 'Tensor', *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def matrix_power(self, n: int) -> 'Tensor': ...

    @overload
    def max(self, dim: int, keepdim: bool=False, *, out: Optional['Tensor']=None) -> Tuple['Tensor', 'Tensor']: ...

    @overload
    def max(self, other: 'Tensor', *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def max(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def mean(self, dtype: dtype, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def mean(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def mean(self, dim: Tuple[int, ...], keepdim: bool, dtype: dtype, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def mean(self, dim: Tuple[int, ...], keepdim: bool=False, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def mean(self, dim: Tuple[int, ...], dtype: dtype, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def median(self, dim: int, keepdim: bool=False, *, out: Optional['Tensor']=None) -> Tuple['Tensor', 'Tensor']: ...

    @overload
    def median(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def min(self, dim: int, keepdim: bool=False, *, out: Optional['Tensor']=None) -> Tuple['Tensor', 'Tensor']: ...

    @overload
    def min(self, other: 'Tensor', *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def min(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def mm(self, mat2: 'Tensor', *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def mode(self, dim: int=-1, keepdim: bool=False, *, out: Optional['Tensor']=None) -> Tuple['Tensor', 'Tensor']: ...

    @overload
    def mul(self, other: 'Tensor', *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def mul(self, other: float, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def mul_(self, other: 'Tensor') -> 'Tensor': ...

    @overload
    def mul_(self, other: float) -> 'Tensor': ...

    def multinomial(self, num_samples: int, replacement: bool=False, generator: Generator=nullptr, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def mv(self, vec: 'Tensor', *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def mvlgamma(self, p: int) -> 'Tensor': ...

    def mvlgamma_(self, p: int) -> 'Tensor': ...

    def narrow(self, dim: int, start: int, length: int) -> 'Tensor': ...

    def narrow_copy(self, dim: int, start: int, length: int) -> 'Tensor': ...

    @overload
    def ne(self, other: float, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def ne(self, other: 'Tensor', *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def ne_(self, other: float) -> 'Tensor': ...

    @overload
    def ne_(self, other: 'Tensor') -> 'Tensor': ...

    def neg(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def neg_(self) -> 'Tensor': ...

    def nonzero(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def norm(self, p='fro', dim=None, keepdim=False): ...

    def normal_(self, mean: float=0, std: float=1, generator: Generator=nullptr) -> 'Tensor': ...

    def numel(self) -> int: ...

    def orgqr(self, input2: 'Tensor', *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def ormqr(self, input2: 'Tensor', input3: 'Tensor', left: bool=True, transpose: bool=False, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def permute(self, dims: Tuple[int, ...]) -> 'Tensor': ...

    def pinverse(self, rcond: float=1e-15) -> 'Tensor': ...

    def potrf(self, upper=True): ...

    def potri(self, upper: bool=True, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def potrs(self, input2: 'Tensor', upper: bool=True, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def pow(self, exponent: float, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def pow(self, exponent: 'Tensor', *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def pow(self, exponent: 'Tensor', *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def pow_(self, exponent: float) -> 'Tensor': ...

    @overload
    def pow_(self, exponent: 'Tensor') -> 'Tensor': ...

    @overload
    def prod(self, dtype: dtype, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def prod(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def prod(self, dim: int, keepdim: bool, dtype: dtype, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def prod(self, dim: int, keepdim: bool=False, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def prod(self, dim: int, dtype: dtype, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def pstrf(self, upper: bool=True, tol: float=-1, *, out: Optional['Tensor']=None) -> Tuple['Tensor', 'Tensor']: ...

    def put_(self, index: 'Tensor', source: 'Tensor', accumulate: bool=False) -> 'Tensor': ...

    def qr(self, *, out: Optional['Tensor']=None) -> Tuple['Tensor', 'Tensor']: ...

    @overload
    def random_(self, from_: int, to: int, generator: Generator=nullptr) -> 'Tensor': ...

    @overload
    def random_(self, to: int, generator: Generator=nullptr) -> 'Tensor': ...

    @overload
    def random_(self, generator: Generator=nullptr) -> 'Tensor': ...

    def reciprocal(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def reciprocal_(self) -> 'Tensor': ...

    def register_hook(self, hook): ...

    @overload
    def remainder(self, other: float, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def remainder(self, other: 'Tensor', *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def remainder_(self, other: float) -> 'Tensor': ...

    @overload
    def remainder_(self, other: 'Tensor') -> 'Tensor': ...

    def renorm(self, p: float, dim: int, maxnorm: float, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def renorm_(self, p: float, dim: int, maxnorm: float) -> 'Tensor': ...

    def repeat(self, repeats: Tuple[int, ...]) -> 'Tensor': ...

    def reshape(self, shape: Tuple[int, ...]) -> 'Tensor': ...

    def reshape_as(self, other: 'Tensor') -> 'Tensor': ...

    def resize_(self, size: Tuple[int, ...]) -> 'Tensor': ...

    def resize_as_(self, the_template: 'Tensor') -> 'Tensor': ...

    def retain_grad(self): ...

    def rfft(self, signal_ndim: int, normalized: bool=False, onesided: bool=True) -> 'Tensor': ...

    def roll(self, shifts: Tuple[int, ...], dims: Tuple[int, ...]={}) -> 'Tensor': ...

    def rot90(self, k: int=1, dims: Tuple[int, ...]={0,1}) -> 'Tensor': ...

    def round(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def round_(self) -> 'Tensor': ...

    def rsqrt(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def rsqrt_(self) -> 'Tensor': ...

    def scatter(self, dim, index, source): ...

    @overload
    def scatter_(self, dim: int, index: 'Tensor', src: 'Tensor') -> 'Tensor': ...

    @overload
    def scatter_(self, dim: int, index: 'Tensor', value: float) -> 'Tensor': ...

    def scatter_add(self, dim, index, source): ...

    def scatter_add_(self, dim: int, index: 'Tensor', src: 'Tensor') -> 'Tensor': ...

    def select(self, dim: int, index: int) -> 'Tensor': ...

    @overload
    def set_(self, source: Storage) -> 'Tensor': ...

    @overload
    def set_(self, source: Storage, storage_offset: int, size: Tuple[int, ...], stride: Tuple[int, ...]={}) -> 'Tensor': ...

    @overload
    def set_(self, source: 'Tensor') -> 'Tensor': ...

    @overload
    def set_(self) -> 'Tensor': ...

    def share_memory_(self): ...

    def sigmoid(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def sigmoid_(self) -> 'Tensor': ...

    def sign(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def sign_(self) -> 'Tensor': ...

    def sin(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def sin_(self) -> 'Tensor': ...

    def sinh(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def sinh_(self) -> 'Tensor': ...

    def size(self, dim: int) -> int: ...

    def slogdet(self) -> Tuple['Tensor', 'Tensor']: ...

    def sort(self, dim: int=-1, descending: bool=False, *, out: Optional['Tensor']=None) -> Tuple['Tensor', 'Tensor']: ...

    def sparse_dim(self) -> int: ...

    def sparse_mask(self, mask: 'Tensor') -> 'Tensor': ...

    def split(self, split_size, dim=0): ...

    def sqrt(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def sqrt_(self) -> 'Tensor': ...

    @overload
    def squeeze(self) -> 'Tensor': ...

    @overload
    def squeeze(self, dim: int) -> 'Tensor': ...

    @overload
    def squeeze_(self) -> 'Tensor': ...

    @overload
    def squeeze_(self, dim: int) -> 'Tensor': ...

    @overload
    def std(self, unbiased: bool=True, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def std(self, dim: int, unbiased: bool=True, keepdim: bool=False, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def stft(self, n_fft, hop_length=None, win_length=None, window=None, center=True, pad_mode='reflect', normalized=False, onesided=True): ...

    def stride(self, dim: int) -> int: ...

    @overload
    def sub(self, other: 'Tensor', alpha: float=1, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def sub(self, other: float, alpha: float=1, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def sub_(self, other: 'Tensor', alpha: float=1) -> 'Tensor': ...

    @overload
    def sub_(self, other: float, alpha: float=1) -> 'Tensor': ...

    @overload
    def sum(self, dtype: dtype, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def sum(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def sum(self, dim: Tuple[int, ...], keepdim: bool, dtype: dtype, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def sum(self, dim: Tuple[int, ...], keepdim: bool=False, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def sum(self, dim: Tuple[int, ...], dtype: dtype, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def svd(self, some: bool=True, compute_uv: bool=True, *, out: Optional['Tensor']=None) -> Tuple['Tensor', 'Tensor', 'Tensor']: ...

    def symeig(self, eigenvectors: bool=False, upper: bool=True, *, out: Optional['Tensor']=None) -> Tuple['Tensor', 'Tensor']: ...

    def t(self) -> 'Tensor': ...

    def t_(self) -> 'Tensor': ...

    def take(self, index: 'Tensor', *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def tan_(self) -> 'Tensor': ...

    def tanh(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def tanh_(self) -> 'Tensor': ...

    @overload
    def to(self, non_blocking: bool=False, copy: bool=False, *, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> 'Tensor': ...

    @overload
    def to(self, device: Union[device, str, None], dtype: dtype, non_blocking: bool=False, copy: bool=False) -> 'Tensor': ...

    @overload
    def to(self, dtype: dtype, non_blocking: bool=False, copy: bool=False) -> 'Tensor': ...

    @overload
    def to(self, other: 'Tensor', non_blocking: bool=False, copy: bool=False) -> 'Tensor': ...

    @overload
    def to_sparse(self, sparse_dim: int) -> 'Tensor': ...

    @overload
    def to_sparse(self) -> 'Tensor': ...

    def topk(self, k: int, dim: int=-1, largest: bool=True, sorted: bool=True, *, out: Optional['Tensor']=None) -> Tuple['Tensor', 'Tensor']: ...

    def trace(self) -> 'Tensor': ...

    def transpose(self, dim0: int, dim1: int) -> 'Tensor': ...

    def transpose_(self, dim0: int, dim1: int) -> 'Tensor': ...

    def tril(self, diagonal: int=0, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def tril_(self, diagonal: int=0) -> 'Tensor': ...

    def triu(self, diagonal: int=0, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def triu_(self, diagonal: int=0) -> 'Tensor': ...

    def trtrs(self, A: 'Tensor', upper: bool=True, transpose: bool=False, unitriangular: bool=False, *, out: Optional['Tensor']=None) -> Tuple['Tensor', 'Tensor']: ...

    def trunc(self, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def trunc_(self) -> 'Tensor': ...

    def type_as(self, other: 'Tensor') -> 'Tensor': ...

    def unbind(self, dim: int=0) -> Tuple['Tensor', ...]: ...

    def unfold(self, dimension: int, size: int, step: int) -> 'Tensor': ...

    def uniform_(self, from_: float=0, to: float=1, generator: Generator=nullptr) -> 'Tensor': ...

    def unique(self, sorted=False, return_inverse=False, dim=None): ...

    def unsqueeze(self, dim: int) -> 'Tensor': ...

    def unsqueeze_(self, dim: int) -> 'Tensor': ...

    def values(self) -> 'Tensor': ...

    @overload
    def var(self, unbiased: bool=True, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    @overload
    def var(self, dim: int, unbiased: bool=True, keepdim: bool=False, *, out: Optional['Tensor']=None) -> 'Tensor': ...

    def view(self, size: Tuple[int, ...]) -> 'Tensor': ...

    def view_as(self, other: 'Tensor') -> 'Tensor': ...

    def where(self, condition: 'Tensor', other: 'Tensor') -> 'Tensor': ...

    def zero_(self) -> 'Tensor': ...


def abs(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def acos(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def adaptive_avg_pool1d(self: Tensor, output_size: Tuple[int, ...]) -> Tensor: ...

@overload
def add(self: Tensor, other: Tensor, alpha: float=1, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def add(self: Tensor, other: float, alpha: float=1, *, out: Optional[Tensor]=None) -> Tensor: ...

def addbmm(self: Tensor, batch1: Tensor, batch2: Tensor, beta: float=1, alpha: float=1, *, out: Optional[Tensor]=None) -> Tensor: ...

def addcdiv(self: Tensor, tensor1: Tensor, tensor2: Tensor, value: float=1, *, out: Optional[Tensor]=None) -> Tensor: ...

def addcmul(self: Tensor, tensor1: Tensor, tensor2: Tensor, value: float=1, *, out: Optional[Tensor]=None) -> Tensor: ...

def addmm(self: Tensor, mat1: Tensor, mat2: Tensor, beta: float=1, alpha: float=1, *, out: Optional[Tensor]=None) -> Tensor: ...

def addmv(self: Tensor, mat: Tensor, vec: Tensor, beta: float=1, alpha: float=1, *, out: Optional[Tensor]=None) -> Tensor: ...

def addr(self: Tensor, vec1: Tensor, vec2: Tensor, beta: float=1, alpha: float=1, *, out: Optional[Tensor]=None) -> Tensor: ...

def allclose(self: Tensor, other: Tensor, rtol: float=1e-05, atol: float=1e-08, equal_nan: bool=False) -> bool: ...

@overload
def arange(start: float, end: float, *, out: Optional[Tensor]=None, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def arange(start: float, end: float, step: float, *, out: Optional[Tensor]=None, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def arange(end: float, *, out: Optional[Tensor]=None, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

def argmax(input, dim=None, keepdim=False): ...

def argmin(input, dim=None, keepdim=False): ...

def argsort(input, dim=None, descending=False): ...

def asin(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def atan(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def atan2(self: Tensor, other: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def avg_pool1d(self: Tensor, kernel_size: Tuple[int, ...], stride: Tuple[int, ...]={}, padding: Tuple[int, ...]=0, ceil_mode: bool=False, count_include_pad: bool=True) -> Tensor: ...

def baddbmm(self: Tensor, batch1: Tensor, batch2: Tensor, beta: float=1, alpha: float=1, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def bartlett_window(window_length: int, *, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def bartlett_window(window_length: int, periodic: bool, *, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def bernoulli(self: Tensor, generator: Generator=nullptr, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def bernoulli(self: Tensor, p: float, generator: Generator=nullptr, *, out: Optional[Tensor]=None) -> Tensor: ...

def bincount(self: Tensor, weights: Optional[Tensor]={}, minlength: int=0) -> Tensor: ...

@overload
def blackman_window(window_length: int, *, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def blackman_window(window_length: int, periodic: bool, *, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

def bmm(self: Tensor, mat2: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def broadcast_tensors(*tensors:Tensor) -> List[Tensor]: ...

def btrifact(A:Tensor, info:Union[Tensor, NoneType]=None, pivot:bool=True) -> Tuple[Tensor, Tensor]: ...

def btrifact_with_info(self: Tensor, pivot: bool=True, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor, Tensor]: ...

def btrisolve(self: Tensor, LU_data: Tensor, LU_pivots: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def btriunpack(LU_data:Tensor, LU_pivots:Tensor, unpack_data:bool=True, unpack_pivots:bool=True) -> Tuple[Union[Tensor, NoneType], Union[Tensor, NoneType], Union[Tensor, NoneType]]: ...

def cat(tensors: Tuple[Tensor, ...], dim: int=0, *, out: Optional[Tensor]=None) -> Tensor: ...

def ceil(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def celu_(self: Tensor, alpha: float=1.0) -> Tensor: ...

def chain_matmul(*matrices): ...

def cholesky(self: Tensor, upper: bool=False, *, out: Optional[Tensor]=None) -> Tensor: ...

def chunk(self: Tensor, chunks: int, dim: int=0) -> Tuple[Tensor, ...]: ...

def clamp(self: Tensor, min: Optional[float]=c10::nullopt, max: Optional[float]=c10::nullopt, *, out: Optional[Tensor]=None) -> Tensor: ...

def compiled_with_cxx11_abi(): ...

def conv1d(input: Tensor, weight: Tensor, bias: Optional[Tensor]={}, stride: Tuple[int, ...]=1, padding: Tuple[int, ...]=0, dilation: Tuple[int, ...]=1, groups: int=1) -> Tensor: ...

def conv2d(input: Tensor, weight: Tensor, bias: Optional[Tensor]={}, stride: Tuple[int, ...]=1, padding: Tuple[int, ...]=0, dilation: Tuple[int, ...]=1, groups: int=1) -> Tensor: ...

def conv3d(input: Tensor, weight: Tensor, bias: Optional[Tensor]={}, stride: Tuple[int, ...]=1, padding: Tuple[int, ...]=0, dilation: Tuple[int, ...]=1, groups: int=1) -> Tensor: ...

def conv_tbc(self: Tensor, weight: Tensor, bias: Tensor, pad: int=0) -> Tensor: ...

def conv_transpose1d(input: Tensor, weight: Tensor, bias: Optional[Tensor]={}, stride: Tuple[int, ...]=1, padding: Tuple[int, ...]=0, output_padding: Tuple[int, ...]=0, groups: int=1, dilation: Tuple[int, ...]=1) -> Tensor: ...

def conv_transpose2d(input: Tensor, weight: Tensor, bias: Optional[Tensor]={}, stride: Tuple[int, ...]=1, padding: Tuple[int, ...]=0, output_padding: Tuple[int, ...]=0, groups: int=1, dilation: Tuple[int, ...]=1) -> Tensor: ...

def conv_transpose3d(input: Tensor, weight: Tensor, bias: Optional[Tensor]={}, stride: Tuple[int, ...]=1, padding: Tuple[int, ...]=0, output_padding: Tuple[int, ...]=0, groups: int=1, dilation: Tuple[int, ...]=1) -> Tensor: ...

def cos(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def cosh(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def cosine_similarity(x1: Tensor, x2: Tensor, dim: int=1, eps: float=1e-08) -> Tensor: ...

def cross(self: Tensor, other: Tensor, dim: int=-1, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def cumprod(self: Tensor, dim: int, dtype: dtype, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def cumprod(self: Tensor, dim: int, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def cumsum(self: Tensor, dim: int, dtype: dtype, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def cumsum(self: Tensor, dim: int, *, out: Optional[Tensor]=None) -> Tensor: ...

def det(self: Tensor) -> Tensor: ...

def diag(self: Tensor, diagonal: int=0, *, out: Optional[Tensor]=None) -> Tensor: ...

def diag_embed(self: Tensor, offset: int=0, dim1: int=-2, dim2: int=-1) -> Tensor: ...

def diagflat(self: Tensor, offset: int=0) -> Tensor: ...

def diagonal(self: Tensor, offset: int=0, dim1: int=0, dim2: int=1) -> Tensor: ...

def digamma(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def dist(self: Tensor, other: Tensor, p: float=2) -> Tensor: ...

@overload
def div(self: Tensor, other: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def div(self: Tensor, other: float, *, out: Optional[Tensor]=None) -> Tensor: ...

def dot(self: Tensor, tensor: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def eig(self: Tensor, eigenvectors: bool=False, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor]: ...

def einsum(equation:str, *operands:Tensor) -> Tensor: ...

@overload
def empty(size: Tuple[int, ...], *, out: Optional[Tensor]=None, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def empty(*size: int, out: Optional[Tensor]=None, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def empty_like(self: Tensor) -> Tensor: ...

@overload
def empty_like(self: Tensor, *, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def eq(self: Tensor, other: float, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def eq(self: Tensor, other: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def equal(self: Tensor, other: Tensor) -> bool: ...

def erf(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def erfc(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def erfinv(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def exp(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def expm1(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def eye(n: int, *, out: Optional[Tensor]=None, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def eye(n: int, m: int, *, out: Optional[Tensor]=None, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

def fft(self: Tensor, signal_ndim: int, normalized: bool=False) -> Tensor: ...

def flatten(self: Tensor, start_dim: int=0, end_dim: int=-1) -> Tensor: ...

def flip(self: Tensor, dims: Tuple[int, ...]) -> Tensor: ...

def floor(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def fmod(self: Tensor, other: float, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def fmod(self: Tensor, other: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def frac(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def full(size: Tuple[int, ...], fill_value: float, *, out: Optional[Tensor]=None, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def full_like(self: Tensor, fill_value: float) -> Tensor: ...

@overload
def full_like(self: Tensor, fill_value: float, *, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

def gather(self: Tensor, dim: int, index: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def ge(self: Tensor, other: float, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def ge(self: Tensor, other: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def gels(self: Tensor, A: Tensor, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor]: ...

def geqrf(self: Tensor, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor]: ...

def ger(self: Tensor, vec2: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def gesv(self: Tensor, A: Tensor, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor]: ...

def get_rng_state(): ...

@overload
def gt(self: Tensor, other: float, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def gt(self: Tensor, other: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def hamming_window(window_length: int, *, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def hamming_window(window_length: int, periodic: bool, *, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def hamming_window(window_length: int, periodic: bool, alpha: float, *, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def hamming_window(window_length: int, periodic: bool, alpha: float, beta: float, *, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def hann_window(window_length: int, *, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def hann_window(window_length: int, periodic: bool, *, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

def histc(self: Tensor, bins: int=100, min: float=0, max: float=0, *, out: Optional[Tensor]=None) -> Tensor: ...

def ifft(self: Tensor, signal_ndim: int, normalized: bool=False) -> Tensor: ...

def index_select(self: Tensor, dim: int, index: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def initial_seed(): ...

def inverse(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def irfft(self: Tensor, signal_ndim: int, normalized: bool=False, onesided: bool=True, signal_sizes: Tuple[int, ...]={}) -> Tensor: ...

def is_storage(obj): ...

def is_tensor(obj): ...

def isfinite(tensor): ...

def isinf(tensor): ...

def isnan(tensor): ...

def kthvalue(self: Tensor, k: int, dim: int=-1, keepdim: bool=False, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor]: ...

@overload
def le(self: Tensor, other: float, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def le(self: Tensor, other: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def lerp(self: Tensor, end: Tensor, weight: float, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def linspace(start: float, end: float, *, out: Optional[Tensor]=None, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def linspace(start: float, end: float, steps: int, *, out: Optional[Tensor]=None, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

def load(f, map_location=None, pickle_module=pickle): ...

def log(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def log10(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def log1p(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def log2(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def logdet(self: Tensor) -> Tensor: ...

@overload
def logspace(start: float, end: float, *, out: Optional[Tensor]=None, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def logspace(start: float, end: float, steps: int, *, out: Optional[Tensor]=None, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

def logsumexp(self: Tensor, dim: int, keepdim: bool=False, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def lt(self: Tensor, other: float, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def lt(self: Tensor, other: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def manual_seed(seed): ...

def masked_select(self: Tensor, mask: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def matmul(self: Tensor, other: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def matrix_power(self: Tensor, n: int) -> Tensor: ...

@overload
def matrix_rank(self: Tensor, tol: float, symmetric: bool=False) -> Tensor: ...

@overload
def matrix_rank(self: Tensor, symmetric: bool=False) -> Tensor: ...

@overload
def max(self: Tensor, dim: int, keepdim: bool=False, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor]: ...

@overload
def max(self: Tensor, other: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def max(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def mean(self: Tensor, dtype: dtype, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def mean(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def mean(self: Tensor, dim: Tuple[int, ...], keepdim: bool, dtype: dtype, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def mean(self: Tensor, dim: Tuple[int, ...], keepdim: bool=False, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def mean(self: Tensor, dim: Tuple[int, ...], dtype: dtype, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def median(self: Tensor, dim: int, keepdim: bool=False, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor]: ...

@overload
def median(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def meshgrid(*tensors, **kwargs): ...

@overload
def min(self: Tensor, dim: int, keepdim: bool=False, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor]: ...

@overload
def min(self: Tensor, other: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def min(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def mm(self: Tensor, mat2: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def mode(self: Tensor, dim: int=-1, keepdim: bool=False, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor]: ...

@overload
def mul(self: Tensor, other: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def mul(self: Tensor, other: float, *, out: Optional[Tensor]=None) -> Tensor: ...

def multinomial(self: Tensor, num_samples: int, replacement: bool=False, generator: Generator=nullptr, *, out: Optional[Tensor]=None) -> Tensor: ...

def mv(self: Tensor, vec: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def mvlgamma(self: Tensor, p: int) -> Tensor: ...

def narrow(self: Tensor, dim: int, start: int, length: int) -> Tensor: ...

@overload
def ne(self: Tensor, other: float, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def ne(self: Tensor, other: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def neg(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def nonzero(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def norm(input, p='fro', dim=None, keepdim=False, out=None): ...

@overload
def normal(mean: Tensor, std: float=1, generator: Generator=nullptr, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def normal(mean: float, std: Tensor, generator: Generator=nullptr, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def normal(mean: Tensor, std: Tensor, generator: Generator=nullptr, *, out: Optional[Tensor]=None) -> Tensor: ...

def numel(self: Tensor) -> int: ...

@overload
def ones(size: Tuple[int, ...], *, out: Optional[Tensor]=None, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def ones(*size: int, out: Optional[Tensor]=None, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def ones_like(self: Tensor) -> Tensor: ...

@overload
def ones_like(self: Tensor, *, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

def orgqr(self: Tensor, input2: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def ormqr(self: Tensor, input2: Tensor, input3: Tensor, left: bool=True, transpose: bool=False, *, out: Optional[Tensor]=None) -> Tensor: ...

def pdist(self: Tensor, p: float=2) -> Tensor: ...

def pinverse(self: Tensor, rcond: float=1e-15) -> Tensor: ...

def pixel_shuffle(self: Tensor, upscale_factor: int) -> Tensor: ...

def potrf(a, upper=True, out=None): ...

def potri(self: Tensor, upper: bool=True, *, out: Optional[Tensor]=None) -> Tensor: ...

def potrs(self: Tensor, input2: Tensor, upper: bool=True, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def pow(self: Tensor, exponent: float, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def pow(self: Tensor, exponent: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def pow(self: float, exponent: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def prod(self: Tensor, dtype: dtype, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def prod(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def prod(self: Tensor, dim: int, keepdim: bool, dtype: dtype, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def prod(self: Tensor, dim: int, keepdim: bool=False, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def prod(self: Tensor, dim: int, dtype: dtype, *, out: Optional[Tensor]=None) -> Tensor: ...

def pstrf(self: Tensor, upper: bool=True, tol: float=-1, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor]: ...

def qr(self: Tensor, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor]: ...

@overload
def rand(size: Tuple[int, ...], *, out: Optional[Tensor]=None, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def rand(*size: int, out: Optional[Tensor]=None, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def rand(size: Tuple[int, ...], generator: Generator, *, out: Optional[Tensor]=None, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def rand_like(self: Tensor) -> Tensor: ...

@overload
def rand_like(self: Tensor, *, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def randint(high: int, size: Tuple[int, ...], *, out: Optional[Tensor]=None, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def randint(high: int, size: Tuple[int, ...], generator: Generator, *, out: Optional[Tensor]=None, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def randint(low: int, high: int, size: Tuple[int, ...], *, out: Optional[Tensor]=None, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def randint(low: int, high: int, size: Tuple[int, ...], generator: Generator, *, out: Optional[Tensor]=None, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def randint_like(self: Tensor, high: int) -> Tensor: ...

@overload
def randint_like(self: Tensor, low: int, high: int) -> Tensor: ...

@overload
def randint_like(self: Tensor, high: int, *, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def randint_like(self: Tensor, low: int, high: int, *, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def randn(size: Tuple[int, ...], *, out: Optional[Tensor]=None, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def randn(*size: int, out: Optional[Tensor]=None, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def randn(size: Tuple[int, ...], generator: Generator, *, out: Optional[Tensor]=None, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def randn_like(self: Tensor) -> Tensor: ...

@overload
def randn_like(self: Tensor, *, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def randperm(n: int, *, out: Optional[Tensor]=None, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def randperm(n: int, generator: Generator, *, out: Optional[Tensor]=None, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def range(start: float, end: float, *, out: Optional[Tensor]=None, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def range(start: float, end: float, step: float, *, out: Optional[Tensor]=None, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

def reciprocal(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def relu_(self: Tensor) -> Tensor: ...

@overload
def remainder(self: Tensor, other: float, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def remainder(self: Tensor, other: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def renorm(self: Tensor, p: float, dim: int, maxnorm: float, *, out: Optional[Tensor]=None) -> Tensor: ...

def reshape(self: Tensor, shape: Tuple[int, ...]) -> Tensor: ...

def rfft(self: Tensor, signal_ndim: int, normalized: bool=False, onesided: bool=True) -> Tensor: ...

def roll(self: Tensor, shifts: Tuple[int, ...], dims: Tuple[int, ...]={}) -> Tensor: ...

def rot90(self: Tensor, k: int=1, dims: Tuple[int, ...]={0,1}) -> Tensor: ...

def round(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def rrelu_(self: Tensor, lower: float=0.125, upper: float=0.3333333333333333, training: bool=False, generator: Generator=nullptr) -> Tensor: ...

def rsqrt(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def save(obj, f, pickle_module=pickle, pickle_protocol=2): ...

def selu_(self: Tensor) -> Tensor: ...

def set_default_dtype(d): ...

def set_default_tensor_type(t): ...

def set_printoptions(precision=None, threshold=None, edgeitems=None, linewidth=None, profile=None): ...

def set_rng_state(new_state): ...

def sigmoid(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def sign(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def sin(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def sinh(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def slogdet(self: Tensor) -> Tuple[Tensor, Tensor]: ...

def sort(self: Tensor, dim: int=-1, descending: bool=False, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor]: ...

@overload
def sparse_coo_tensor(size: Tuple[int, ...], *, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def sparse_coo_tensor(*size: int, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def sparse_coo_tensor(indices: Tensor, values: Tensor, *, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def sparse_coo_tensor(indices: Tensor, values: Tensor, size: Tuple[int, ...], *, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

def split(tensor:Tensor, split_size_or_sections:Union[List[int], int], dim:int=0) -> List[Tensor]: ...

def sqrt(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def squeeze(self: Tensor) -> Tensor: ...

@overload
def squeeze(self: Tensor, dim: int) -> Tensor: ...

def stack(tensors: Tuple[Tensor, ...], dim: int=0, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def std(self: Tensor, unbiased: bool=True, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def std(self: Tensor, dim: int, unbiased: bool=True, keepdim: bool=False, *, out: Optional[Tensor]=None) -> Tensor: ...

def stft(input, n_fft, hop_length=None, win_length=None, window=None, center=True, pad_mode='reflect', normalized=False, onesided=True): ...

@overload
def sum(self: Tensor, dtype: dtype, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def sum(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def sum(self: Tensor, dim: Tuple[int, ...], keepdim: bool, dtype: dtype, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def sum(self: Tensor, dim: Tuple[int, ...], keepdim: bool=False, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def sum(self: Tensor, dim: Tuple[int, ...], dtype: dtype, *, out: Optional[Tensor]=None) -> Tensor: ...

def svd(self: Tensor, some: bool=True, compute_uv: bool=True, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor, Tensor]: ...

def symeig(self: Tensor, eigenvectors: bool=False, upper: bool=True, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor]: ...

def t(self: Tensor) -> Tensor: ...

def take(self: Tensor, index: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def tan(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def tanh(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def tensordot(a, b, dims=2): ...

def threshold_(self: Tensor, threshold: float, value: float) -> Tensor: ...

def topk(self: Tensor, k: int, dim: int=-1, largest: bool=True, sorted: bool=True, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor]: ...

def trace(self: Tensor) -> Tensor: ...

def transpose(self: Tensor, dim0: int, dim1: int) -> Tensor: ...

def tril(self: Tensor, diagonal: int=0, *, out: Optional[Tensor]=None) -> Tensor: ...

def triu(self: Tensor, diagonal: int=0, *, out: Optional[Tensor]=None) -> Tensor: ...

def trtrs(self: Tensor, A: Tensor, upper: bool=True, transpose: bool=False, unitriangular: bool=False, *, out: Optional[Tensor]=None) -> Tuple[Tensor, Tensor]: ...

def trunc(self: Tensor, *, out: Optional[Tensor]=None) -> Tensor: ...

def unbind(self: Tensor, dim: int=0) -> Tuple[Tensor, ...]: ...

def unique(input, sorted=False, return_inverse=False, dim=None): ...

def unsqueeze(self: Tensor, dim: int) -> Tensor: ...

@overload
def var(self: Tensor, unbiased: bool=True, *, out: Optional[Tensor]=None) -> Tensor: ...

@overload
def var(self: Tensor, dim: int, unbiased: bool=True, keepdim: bool=False, *, out: Optional[Tensor]=None) -> Tensor: ...

def where(condition: Tensor, self: Tensor, other: Tensor) -> Tensor: ...

@overload
def zeros(size: Tuple[int, ...], *, out: Optional[Tensor]=None, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def zeros(*size: int, out: Optional[Tensor]=None, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

@overload
def zeros_like(self: Tensor) -> Tensor: ...

@overload
def zeros_like(self: Tensor, *, dtype: dtype=None, layout: layout=torch.strided, device: device=None, requires_grad:bool=False) -> Tensor: ...

