/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.collectionincompatibletype;

import com.google.common.collect.Iterables;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.collectionincompatibletype.AbstractCollectionIncompatibleTypeMatcher;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;

class MethodArgMatcher
extends AbstractCollectionIncompatibleTypeMatcher {
    private final Matcher<ExpressionTree> methodMatcher;
    private final String typeName;
    private final int typeArgIndex;
    private final int methodArgIndex;

    public MethodArgMatcher(String typeName, String signature, int typeArgIndex, int methodArgIndex) {
        this.methodMatcher = MethodMatchers.instanceMethod().onDescendantOf(typeName).withSignature(signature);
        this.typeName = typeName;
        this.typeArgIndex = typeArgIndex;
        this.methodArgIndex = methodArgIndex;
    }

    @Override
    Matcher<ExpressionTree> methodMatcher() {
        return this.methodMatcher;
    }

    @Override
    ExpressionTree extractSourceTree(MethodInvocationTree tree, VisitorState state) {
        return (ExpressionTree)Iterables.get(tree.getArguments(), (int)this.methodArgIndex);
    }

    @Override
    Type extractSourceType(MethodInvocationTree tree, VisitorState state) {
        return ASTHelpers.getType((Tree)this.extractSourceTree(tree, state));
    }

    @Override
    Type extractTargetType(MethodInvocationTree tree, VisitorState state) {
        return MethodArgMatcher.extractTypeArgAsMemberOfSupertype(ASTHelpers.getReceiverType((ExpressionTree)tree), state.getSymbolFromString(this.typeName), this.typeArgIndex, state.getTypes());
    }
}

