/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XYZApp
extends Applet
implements Runnable,
MouseListener,
MouseMotionListener {
    XYZChemModel md;
    boolean painted = true;
    float xfac;
    int prevx;
    int prevy;
    float scalefudge = 1.0f;
    Matrix3D amat = new Matrix3D();
    Matrix3D tmat = new Matrix3D();
    String mdname = null;
    String message = null;
    Image backBuffer;
    Graphics backGC;
    Dimension backSize;

    private synchronized void newBackBuffer() {
        this.backBuffer = this.createImage(this.getSize().width, this.getSize().height);
        if (this.backGC != null) {
            this.backGC.dispose();
        }
        this.backGC = this.backBuffer.getGraphics();
        this.backSize = this.getSize();
    }

    @Override
    public void init() {
        this.mdname = this.getParameter("model");
        try {
            this.scalefudge = Float.valueOf(this.getParameter("scale")).floatValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.amat.yrot(20.0);
        this.amat.xrot(20.0);
        if (this.mdname == null) {
            this.mdname = "model.obj";
        }
        this.resize(this.getSize().width <= 20 ? 400 : this.getSize().width, this.getSize().height <= 20 ? 400 : this.getSize().height);
        this.newBackBuffer();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void destroy() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
    }

    @Override
    public void run() {
        InputStream is = null;
        try {
            float f2;
            float f1;
            Thread.currentThread().setPriority(1);
            is = this.getClass().getResourceAsStream(this.mdname);
            XYZChemModel m = new XYZChemModel(is);
            Atom.setApplet(this);
            this.md = m;
            m.findBB();
            float xw = m.xmax - m.xmin;
            float yw = m.ymax - m.ymin;
            float zw = m.zmax - m.zmin;
            if (yw > xw) {
                xw = yw;
            }
            if (zw > xw) {
                xw = zw;
            }
            this.xfac = 0.7f * ((f1 = (float)this.getSize().width / xw) < (f2 = (float)this.getSize().height / xw) ? f1 : f2) * this.scalefudge;
        }
        catch (Exception e) {
            Logger.getLogger(XYZApp.class.getName()).log(Level.SEVERE, null, e);
            this.md = null;
            this.message = e.toString();
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.repaint();
    }

    @Override
    public void start() {
        if (this.md == null && this.message == null) {
            new Thread(this).start();
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.prevx = e.getX();
        this.prevy = e.getY();
        e.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.tmat.unit();
        float xtheta = (float)(this.prevy - y) * (360.0f / (float)this.getSize().width);
        float ytheta = (float)(x - this.prevx) * (360.0f / (float)this.getSize().height);
        this.tmat.xrot(xtheta);
        this.tmat.yrot(ytheta);
        this.amat.mult(this.tmat);
        if (this.painted) {
            this.painted = false;
            this.repaint();
        }
        this.prevx = x;
        this.prevy = y;
        e.consume();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void update(Graphics g) {
        if (this.backBuffer == null) {
            g.clearRect(0, 0, this.getSize().width, this.getSize().height);
        }
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (this.md != null) {
            this.md.mat.unit();
            this.md.mat.translate(-(this.md.xmin + this.md.xmax) / 2.0f, -(this.md.ymin + this.md.ymax) / 2.0f, -(this.md.zmin + this.md.zmax) / 2.0f);
            this.md.mat.mult(this.amat);
            this.md.mat.scale(this.xfac, -this.xfac, 16.0f * this.xfac / (float)this.getSize().width);
            this.md.mat.translate(this.getSize().width / 2, this.getSize().height / 2, 8.0f);
            this.md.transformed = false;
            if (this.backBuffer != null) {
                if (!this.backSize.equals(this.getSize())) {
                    this.newBackBuffer();
                }
                this.backGC.setColor(this.getBackground());
                this.backGC.fillRect(0, 0, this.getSize().width, this.getSize().height);
                this.md.paint(this.backGC);
                g.drawImage(this.backBuffer, 0, 0, this);
            } else {
                this.md.paint(g);
            }
            this.setPainted();
        } else if (this.message != null) {
            g.drawString("Error in model:", 3, 20);
            g.drawString(this.message, 10, 40);
        }
    }

    private synchronized void setPainted() {
        this.painted = true;
        this.notifyAll();
    }

    @Override
    public String getAppletInfo() {
        return "Title: XYZApp \nAuthor: James Gosling \nAn applet to put a Chemical model into a page.";
    }

    @Override
    public String[][] getParameterInfo() {
        String[][] info = new String[][]{{"model", "path string", "The path to the model to be displayed in .xyz format (see http://chem.leeds.ac.uk/Project/MIME.html).  Default is model.obj."}, {"scale", "float", "Scale factor.  Default is 1 (i.e. no scale)."}};
        return info;
    }
}

