/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager.linux;

import com.oracle.tools.packager.AbstractBundler;
import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.oracle.tools.packager.linux.LinuxAppBundler;
import com.oracle.tools.packager.linux.LinuxDebBundler;
import com.oracle.tools.packager.linux.LinuxResources;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

public class LinuxRpmBundler
extends AbstractBundler {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(LinuxRpmBundler.class.getName());
    public static final BundlerParamInfo<LinuxAppBundler> APP_BUNDLER = new StandardBundlerParam<LinuxAppBundler>(I18N.getString("param.app-bundler.name"), I18N.getString("param.app-bundler.description"), "linux.app.bundler", LinuxAppBundler.class, params -> new LinuxAppBundler(), null);
    public static final BundlerParamInfo<File> RPM_IMAGE_DIR = new StandardBundlerParam<File>(I18N.getString("param.image-dir.name"), I18N.getString("param.image-dir.description"), "linux.rpm.imageDir", File.class, params -> {
        File imagesRoot = (File)IMAGES_ROOT.fetchFrom((Map<String, ? super Object>)params);
        if (!imagesRoot.exists()) {
            imagesRoot.mkdirs();
        }
        return new File(imagesRoot, "linux-rpm.image");
    }, (s, p) -> new File((String)s));
    public static final BundlerParamInfo<File> CONFIG_ROOT = new StandardBundlerParam<File>(I18N.getString("param.config-root.name"), I18N.getString("param.config-root.description"), "configRoot", File.class, params -> new File((File)StandardBundlerParam.BUILD_ROOT.fetchFrom((Map<String, Object>)params), "linux"), (s, p) -> new File((String)s));
    private static final Pattern RPM_BUNDLE_NAME_PATTERN = Pattern.compile("[a-z\\d\\+\\-\\.\\_]+", 2);
    public static final BundlerParamInfo<String> BUNDLE_NAME = new StandardBundlerParam<String>(I18N.getString("param.bundle-name.name"), I18N.getString("param.bundle-name.description"), "linux.bundleName", String.class, params -> {
        String nm = (String)StandardBundlerParam.APP_NAME.fetchFrom((Map<String, Object>)params);
        if (nm == null) {
            return null;
        }
        nm = nm.toLowerCase().replaceAll("[ ]", "-");
        return nm;
    }, (s, p) -> {
        if (!RPM_BUNDLE_NAME_PATTERN.matcher((CharSequence)s).matches()) {
            throw new IllegalArgumentException(new ConfigException(MessageFormat.format(I18N.getString("error.invalid-value-for-package-name"), s), I18N.getString("error.invalid-value-for-package-name.advice")));
        }
        return s;
    });
    public static final BundlerParamInfo<String> XDG_FILE_PREFIX = new StandardBundlerParam<String>(I18N.getString("param.xdg-prefix.name"), I18N.getString("param.xdg-prefix.description"), "linux.xdg-prefix", String.class, params -> {
        try {
            String vendor = params.containsKey(StandardBundlerParam.VENDOR.getID()) ? (String)StandardBundlerParam.VENDOR.fetchFrom((Map<String, Object>)params) : "javapackager";
            String appName = (String)StandardBundlerParam.APP_FS_NAME.fetchFrom((Map<String, Object>)params);
            return (vendor + "-" + appName).replaceAll("\\s", "");
        }
        catch (Exception e) {
            if (Log.isDebug()) {
                e.printStackTrace();
            }
            return "unknown-MimeInfo.xml";
        }
    }, (s, p) -> s);
    private static final String DEFAULT_ICON = "javalogo_white_32.png";
    private static final String DEFAULT_SPEC_TEMPLATE = "template.spec";
    private static final String DEFAULT_DESKTOP_FILE_TEMPLATE = "template.desktop";
    private static final String DEFAULT_INIT_SCRIPT_TEMPLATE = "template.rpm.init.script";
    public static final String TOOL_RPMBUILD = "rpmbuild";
    public static final double TOOL_RPMBUILD_MIN_VERSION = 4.0;

    public LinuxRpmBundler() {
        this.baseResourceLoader = LinuxResources.class;
    }

    /*
     * Exception decompiling
     */
    public static boolean testTool(String toolName, double minVersion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean validate(Map<String, ? super Object> p) throws UnsupportedPlatformException, ConfigException {
        try {
            boolean serviceHint;
            if (p == null) {
                throw new ConfigException(I18N.getString("error.parameters-null"), I18N.getString("error.parameters-null.advice"));
            }
            APP_BUNDLER.fetchFrom(p).doValidate(p);
            if (p.containsKey(StandardBundlerParam.LICENSE_FILE.getID())) {
                List appResourcesList = (List)StandardBundlerParam.APP_RESOURCES_LIST.fetchFrom(p);
                for (String license : (List)StandardBundlerParam.LICENSE_FILE.fetchFrom(p)) {
                    boolean found = false;
                    for (RelativeFileSet appResources : appResourcesList) {
                        found = found || appResources.contains(license);
                    }
                    if (found) continue;
                    throw new ConfigException(I18N.getString("error.license-missing"), MessageFormat.format(I18N.getString("error.license-missing.advice"), license));
                }
            }
            if (!LinuxRpmBundler.testTool(TOOL_RPMBUILD, 4.0)) {
                throw new ConfigException(I18N.getString(MessageFormat.format("error.cannot-find-rpmbuild", 4.0)), I18N.getString(MessageFormat.format("error.cannot-find-rpmbuild.advice", 4.0)));
            }
            boolean systemWide = StandardBundlerParam.SYSTEM_WIDE.fetchFrom(p) == null || (Boolean)StandardBundlerParam.SYSTEM_WIDE.fetchFrom(p) != false;
            boolean bl = serviceHint = p.containsKey(StandardBundlerParam.SERVICE_HINT.getID()) && (Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(p) != false;
            if (serviceHint && !systemWide) {
                throw new ConfigException(I18N.getString("error.no-support-for-peruser-daemons"), I18N.getString("error.no-support-for-peruser-daemons.advice"));
            }
            List associations = (List)StandardBundlerParam.FILE_ASSOCIATIONS.fetchFrom(p);
            if (associations != null) {
                for (int i = 0; i < associations.size(); ++i) {
                    Map assoc = (Map)associations.get(i);
                    List mimes = (List)StandardBundlerParam.FA_CONTENT_TYPE.fetchFrom(assoc);
                    if (mimes == null || mimes.isEmpty()) {
                        throw new ConfigException(MessageFormat.format(I18N.getString("error.no-content-types-for-file-association"), i), I18N.getString("error.no-content-types-for-file-association.advice"));
                    }
                    if (mimes.size() <= 1) continue;
                    throw new ConfigException(MessageFormat.format(I18N.getString("error.too-many-content-types-for-file-association"), i), I18N.getString("error.too-many-content-types-for-file-association.advice"));
                }
            }
            BUNDLE_NAME.getStringConverter().apply(BUNDLE_NAME.fetchFrom(p), p);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof ConfigException) {
                throw (ConfigException)re.getCause();
            }
            throw new ConfigException(re);
        }
    }

    private boolean prepareProto(Map<String, ? super Object> params) {
        File imageDir = RPM_IMAGE_DIR.fetchFrom(params);
        File appDir = APP_BUNDLER.fetchFrom(params).doBundle(params, imageDir, true);
        return appDir != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public File bundle(Map<String, ? super Object> p, File outdir) {
        File imageDir;
        block32: {
            if (!outdir.isDirectory() && !outdir.mkdirs()) {
                throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-create-output-dir"), outdir.getAbsolutePath()));
            }
            if (!outdir.canWrite()) {
                throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-write-to-output-dir"), outdir.getAbsolutePath()));
            }
            imageDir = RPM_IMAGE_DIR.fetchFrom(p);
            imageDir.mkdirs();
            boolean menuShortcut = (Boolean)StandardBundlerParam.MENU_HINT.fetchFrom(p);
            boolean desktopShortcut = (Boolean)StandardBundlerParam.SHORTCUT_HINT.fetchFrom(p);
            if (!menuShortcut && !desktopShortcut) {
                Log.verbose(I18N.getString("message.one-shortcut-required"));
                p.put(StandardBundlerParam.MENU_HINT.getID(), (Object)true);
            }
            if (!this.prepareProto(p) || !this.prepareProjectConfig(p)) break block32;
            File file = this.buildRPM(p, outdir);
            try {
                if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p)).booleanValue()) {
                    this.saveConfigFiles(p);
                }
                if (imageDir != null && !Log.isDebug()) {
                    IOUtils.deleteRecursive(imageDir);
                } else if (imageDir != null) {
                    Log.info(MessageFormat.format(I18N.getString("message.debug-working-directory"), imageDir.getAbsolutePath()));
                }
            }
            catch (FileNotFoundException ex) {
                return null;
            }
            return file;
        }
        File file = null;
        try {
            if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p)).booleanValue()) {
                this.saveConfigFiles(p);
            }
            if (imageDir != null && !Log.isDebug()) {
                IOUtils.deleteRecursive(imageDir);
            } else if (imageDir != null) {
                Log.info(MessageFormat.format(I18N.getString("message.debug-working-directory"), imageDir.getAbsolutePath()));
            }
        }
        catch (FileNotFoundException ex) {
            return null;
        }
        return file;
        catch (IOException ex) {
            File file2;
            try {
                ex.printStackTrace();
                file2 = null;
            }
            catch (Throwable throwable) {
                try {
                    if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p)).booleanValue()) {
                        this.saveConfigFiles(p);
                    }
                    if (imageDir != null && !Log.isDebug()) {
                        IOUtils.deleteRecursive(imageDir);
                    } else if (imageDir != null) {
                        Log.info(MessageFormat.format(I18N.getString("message.debug-working-directory"), imageDir.getAbsolutePath()));
                    }
                }
                catch (FileNotFoundException ex2) {
                    return null;
                }
                throw throwable;
            }
            try {
                if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(p)).booleanValue()) {
                    this.saveConfigFiles(p);
                }
                if (imageDir != null && !Log.isDebug()) {
                    IOUtils.deleteRecursive(imageDir);
                } else if (imageDir != null) {
                    Log.info(MessageFormat.format(I18N.getString("message.debug-working-directory"), imageDir.getAbsolutePath()));
                }
            }
            catch (FileNotFoundException ex3) {
                return null;
            }
            return file2;
        }
    }

    private void setPermissions(File file, String permissions) {
        Set<PosixFilePermission> filePermissions = PosixFilePermissions.fromString(permissions);
        try {
            if (file.exists()) {
                Files.setPosixFilePermissions(file.toPath(), filePermissions);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(LinuxDebBundler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void saveConfigFiles(Map<String, ? super Object> params) {
        try {
            File configRoot = CONFIG_ROOT.fetchFrom(params);
            File rootDir = LinuxAppBundler.getRootDir(RPM_IMAGE_DIR.fetchFrom(params), params);
            if (this.getConfig_SpecFile(params).exists()) {
                IOUtils.copyFile(this.getConfig_SpecFile(params), new File(configRoot, this.getConfig_SpecFile(params).getName()));
            }
            if (this.getConfig_DesktopShortcutFile(rootDir, params).exists()) {
                IOUtils.copyFile(this.getConfig_DesktopShortcutFile(rootDir, params), new File(configRoot, this.getConfig_DesktopShortcutFile(rootDir, params).getName()));
            }
            if (this.getConfig_IconFile(rootDir, params).exists()) {
                IOUtils.copyFile(this.getConfig_IconFile(rootDir, params), new File(configRoot, this.getConfig_IconFile(rootDir, params).getName()));
            }
            if (((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(params)).booleanValue() && this.getConfig_InitScriptFile(params).exists()) {
                IOUtils.copyFile(this.getConfig_InitScriptFile(params), new File(configRoot, this.getConfig_InitScriptFile(params).getName()));
            }
            Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), configRoot.getAbsolutePath()));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private String getLicenseFileString(Map<String, ? super Object> params) {
        StringBuilder sb = new StringBuilder();
        for (String f : (List)StandardBundlerParam.LICENSE_FILE.fetchFrom(params)) {
            if (sb.length() != 0) {
                sb.append("\n");
            }
            sb.append("%doc /opt/");
            sb.append((String)StandardBundlerParam.APP_FS_NAME.fetchFrom(params));
            sb.append("/app/");
            sb.append(f);
        }
        return sb.toString();
    }

    private boolean prepareProjectConfig(Map<String, ? super Object> params) throws IOException {
        Map<String, String> data = this.createReplacementData(params);
        File rootDir = LinuxAppBundler.getRootDir(RPM_IMAGE_DIR.fetchFrom(params), params);
        File iconTarget = this.getConfig_IconFile(rootDir, params);
        File icon = LinuxAppBundler.ICON_PNG.fetchFrom(params);
        if (icon == null || !icon.exists()) {
            this.fetchResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + iconTarget.getName(), I18N.getString("resource.menu-icon"), DEFAULT_ICON, iconTarget, (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
        } else {
            this.fetchResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + iconTarget.getName(), I18N.getString("resource.menu-icon"), icon, iconTarget, (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
        }
        StringBuilder installScripts = new StringBuilder();
        StringBuilder removeScripts = new StringBuilder();
        for (Map secondaryLauncher : (List)StandardBundlerParam.SECONDARY_LAUNCHERS.fetchFrom(params)) {
            Map<String, String> secondaryLauncherData = this.createReplacementData(secondaryLauncher);
            secondaryLauncherData.put("APPLICATION_FS_NAME", data.get("APPLICATION_FS_NAME"));
            secondaryLauncherData.put("DESKTOP_MIMES", "");
            BufferedWriter w = new BufferedWriter(new FileWriter(this.getConfig_DesktopShortcutFile(rootDir, secondaryLauncher)));
            String content = this.preprocessTextResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + this.getConfig_DesktopShortcutFile(rootDir, secondaryLauncher).getName(), I18N.getString("resource.menu-shortcut-descriptor"), DEFAULT_DESKTOP_FILE_TEMPLATE, secondaryLauncherData, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
            w.write(content);
            ((Writer)w).close();
            iconTarget = this.getConfig_IconFile(rootDir, secondaryLauncher);
            icon = LinuxAppBundler.ICON_PNG.fetchFrom(secondaryLauncher);
            if (icon == null || !icon.exists()) {
                this.fetchResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + iconTarget.getName(), I18N.getString("resource.menu-icon"), DEFAULT_ICON, iconTarget, (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
            } else {
                this.fetchResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + iconTarget.getName(), I18N.getString("resource.menu-icon"), icon, iconTarget, (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
            }
            installScripts.append("xdg-desktop-menu install --novendor /opt/");
            installScripts.append(data.get("APPLICATION_FS_NAME"));
            installScripts.append("/");
            installScripts.append(secondaryLauncherData.get("APPLICATION_LAUNCHER_FILENAME"));
            installScripts.append(".desktop\n");
            removeScripts.append("xdg-desktop-menu uninstall --novendor /opt/");
            removeScripts.append(data.get("APPLICATION_FS_NAME"));
            removeScripts.append("/");
            removeScripts.append(secondaryLauncherData.get("APPLICATION_LAUNCHER_FILENAME"));
            removeScripts.append(".desktop\n");
        }
        data.put("SECONDARY_LAUNCHERS_INSTALL", installScripts.toString());
        data.put("SECONDARY_LAUNCHERS_REMOVE", removeScripts.toString());
        StringBuilder cdsScript = new StringBuilder();
        if (((Boolean)StandardBundlerParam.UNLOCK_COMMERCIAL_FEATURES.fetchFrom(params)).booleanValue() && ((Boolean)StandardBundlerParam.ENABLE_APP_CDS.fetchFrom(params)).booleanValue() && ("install".equals(StandardBundlerParam.APP_CDS_CACHE_MODE.fetchFrom(params)) || "auto+install".equals(StandardBundlerParam.APP_CDS_CACHE_MODE.fetchFrom(params)))) {
            cdsScript.append("/opt/");
            cdsScript.append(data.get("APPLICATION_FS_NAME"));
            cdsScript.append("/");
            cdsScript.append(data.get("APPLICATION_LAUNCHER_FILENAME"));
            cdsScript.append(" -Xappcds:generatecache\n");
        }
        data.put("APP_CDS_CACHE", cdsScript.toString());
        List associations = (List)StandardBundlerParam.FILE_ASSOCIATIONS.fetchFrom(params);
        data.put("FILE_ASSOCIATION_INSTALL", "");
        data.put("FILE_ASSOCIATION_REMOVE", "");
        data.put("DESKTOP_MIMES", "");
        if (associations != null) {
            String mimeInfoFile = XDG_FILE_PREFIX.fetchFrom(params) + "-MimeInfo.xml";
            StringBuilder mimeInfo = new StringBuilder("<?xml version=\"1.0\"?>\n<mime-info xmlns='http://www.freedesktop.org/standards/shared-mime-info'>\n");
            StringBuilder registrations = new StringBuilder();
            StringBuilder deregistrations = new StringBuilder();
            StringBuilder desktopMimes = new StringBuilder("MimeType=");
            boolean addedEntry = false;
            for (Map assoc : associations) {
                int size;
                List mimes;
                if (assoc == null) continue;
                String description = (String)StandardBundlerParam.FA_DESCRIPTION.fetchFrom(assoc);
                File faIcon = (File)StandardBundlerParam.FA_ICON.fetchFrom(assoc);
                List extensions = (List)StandardBundlerParam.FA_EXTENSIONS.fetchFrom(assoc);
                if (extensions == null) {
                    Log.info(I18N.getString("message.creating-association-with-null-extension"));
                }
                if ((mimes = (List)StandardBundlerParam.FA_CONTENT_TYPE.fetchFrom(assoc)) == null || mimes.isEmpty()) continue;
                String thisMime = (String)mimes.get(0);
                String dashMime = thisMime.replace('/', '-');
                mimeInfo.append("  <mime-type type='").append(thisMime).append("'>\n");
                if (description != null && !description.isEmpty()) {
                    mimeInfo.append("    <comment>").append(description).append("</comment>\n");
                }
                if (extensions != null) {
                    for (String ext : extensions) {
                        mimeInfo.append("    <glob pattern='*.").append(ext).append("'/>\n");
                    }
                }
                mimeInfo.append("  </mime-type>\n");
                if (!addedEntry) {
                    registrations.append("xdg-mime install /opt/").append(data.get("APPLICATION_FS_NAME")).append("/").append(mimeInfoFile).append("\n");
                    deregistrations.append("xdg-mime uninstall /opt/").append(data.get("APPLICATION_FS_NAME")).append("/").append(mimeInfoFile).append("\n");
                    addedEntry = true;
                } else {
                    desktopMimes.append(";");
                }
                desktopMimes.append(thisMime);
                if (faIcon == null || !faIcon.exists() || (size = this.getSquareSizeOfImage(faIcon)) <= 0) continue;
                File target = new File(rootDir, (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(params) + "_fa_" + faIcon.getName());
                IOUtils.copyFile(faIcon, target);
                registrations.append("xdg-icon-resource install --context mimetypes --size ").append(size).append(" /opt/").append(data.get("APPLICATION_FS_NAME")).append("/").append(target.getName()).append(" ").append(dashMime).append("\n");
                deregistrations.append("xdg-icon-resource uninstall --context mimetypes --size ").append(size).append(" /opt/").append(data.get("APPLICATION_FS_NAME")).append("/").append(target.getName()).append(" ").append(dashMime).append("\n");
            }
            mimeInfo.append("</mime-info>");
            if (addedEntry) {
                BufferedWriter w = new BufferedWriter(new FileWriter(new File(rootDir, mimeInfoFile)));
                w.write(mimeInfo.toString());
                ((Writer)w).close();
                data.put("FILE_ASSOCIATION_INSTALL", registrations.toString());
                data.put("FILE_ASSOCIATION_REMOVE", deregistrations.toString());
                data.put("DESKTOP_MIMES", desktopMimes.toString());
            }
        }
        BufferedWriter w = new BufferedWriter(new FileWriter(this.getConfig_DesktopShortcutFile(rootDir, params)));
        String content = this.preprocessTextResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + this.getConfig_DesktopShortcutFile(rootDir, params).getName(), I18N.getString("resource.menu-shortcut-descriptor"), DEFAULT_DESKTOP_FILE_TEMPLATE, data, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
        w.write(content);
        ((Writer)w).close();
        w = new BufferedWriter(new FileWriter(this.getConfig_SpecFile(params)));
        content = this.preprocessTextResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + this.getConfig_SpecFile(params).getName(), I18N.getString("resource.rpm-spec-file"), DEFAULT_SPEC_TEMPLATE, data, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
        w.write(content);
        ((Writer)w).close();
        if (((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(params)).booleanValue()) {
            w = new BufferedWriter(new FileWriter(this.getConfig_InitScriptFile(params)));
            content = this.preprocessTextResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + this.getConfig_InitScriptFile(params).getName(), I18N.getString("resource.rpm-init-script"), DEFAULT_INIT_SCRIPT_TEMPLATE, data, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(params));
            w.write(content);
            ((Writer)w).close();
            this.setPermissions(this.getConfig_InitScriptFile(params), "rwxr-xr-x");
        }
        return true;
    }

    private Map<String, String> createReplacementData(Map<String, ? super Object> params) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("APPLICATION_NAME", (String)StandardBundlerParam.APP_NAME.fetchFrom(params));
        data.put("APPLICATION_FS_NAME", (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(params));
        data.put("APPLICATION_PACKAGE", BUNDLE_NAME.fetchFrom(params));
        data.put("APPLICATION_VENDOR", (String)StandardBundlerParam.VENDOR.fetchFrom(params));
        data.put("APPLICATION_VERSION", (String)StandardBundlerParam.VERSION.fetchFrom(params));
        data.put("APPLICATION_LAUNCHER_FILENAME", (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(params));
        data.put("XDG_PREFIX", XDG_FILE_PREFIX.fetchFrom(params));
        data.put("DEPLOY_BUNDLE_CATEGORY", (String)StandardBundlerParam.CATEGORY.fetchFrom(params));
        data.put("APPLICATION_DESCRIPTION", (String)StandardBundlerParam.DESCRIPTION.fetchFrom(params));
        data.put("APPLICATION_SUMMARY", (String)StandardBundlerParam.TITLE.fetchFrom(params));
        data.put("APPLICATION_LICENSE_TYPE", StandardBundlerParam.LICENSE_TYPE.fetchFrom(params));
        data.put("APPLICATION_LICENSE_FILE", this.getLicenseFileString(params));
        data.put("SERVICE_HINT", String.valueOf(StandardBundlerParam.SERVICE_HINT.fetchFrom(params)));
        data.put("START_ON_INSTALL", String.valueOf(StandardBundlerParam.START_ON_INSTALL.fetchFrom(params)));
        data.put("STOP_ON_UNINSTALL", String.valueOf(StandardBundlerParam.STOP_ON_UNINSTALL.fetchFrom(params)));
        data.put("RUN_AT_STARTUP", String.valueOf(StandardBundlerParam.RUN_AT_STARTUP.fetchFrom(params)));
        return data;
    }

    private File getConfig_DesktopShortcutFile(File rootDir, Map<String, ? super Object> params) {
        return new File(rootDir, (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(params) + ".desktop");
    }

    private File getConfig_IconFile(File rootDir, Map<String, ? super Object> params) {
        return new File(rootDir, (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(params) + ".png");
    }

    private File getConfig_InitScriptFile(Map<String, ? super Object> params) {
        return new File(LinuxAppBundler.getRootDir(RPM_IMAGE_DIR.fetchFrom(params), params), BUNDLE_NAME.fetchFrom(params) + ".init");
    }

    private File getConfig_SpecFile(Map<String, ? super Object> params) {
        return new File(RPM_IMAGE_DIR.fetchFrom(params), (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(params) + ".spec");
    }

    private File buildRPM(Map<String, ? super Object> params, File outdir) throws IOException {
        Log.verbose(MessageFormat.format(I18N.getString("message.outputting-bundle-location"), outdir.getAbsolutePath()));
        File broot = new File((File)StandardBundlerParam.BUILD_ROOT.fetchFrom(params), "rmpbuildroot");
        outdir.mkdirs();
        ProcessBuilder pb = new ProcessBuilder(TOOL_RPMBUILD, "-bb", this.getConfig_SpecFile(params).getAbsolutePath(), "--define", "%_sourcedir " + RPM_IMAGE_DIR.fetchFrom(params).getAbsolutePath(), "--define", "%_rpmdir " + outdir.getAbsolutePath(), "--define", "%_topdir " + broot.getAbsolutePath());
        pb = pb.directory(RPM_IMAGE_DIR.fetchFrom(params));
        IOUtils.exec(pb, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(params));
        if (!Log.isDebug()) {
            IOUtils.deleteRecursive(broot);
        }
        Log.info(MessageFormat.format(I18N.getString("message.output-bundle-location"), outdir.getAbsolutePath()));
        File result = null;
        long lastModified = 0L;
        File[] list = outdir.listFiles();
        if (list != null) {
            for (File f : list) {
                if (!f.getName().endsWith(".rpm") || f.lastModified() <= lastModified) continue;
                result = f;
                lastModified = f.lastModified();
            }
        }
        return result;
    }

    @Override
    public String getName() {
        return I18N.getString("bundler.name");
    }

    @Override
    public String getDescription() {
        return I18N.getString("bundler.description");
    }

    @Override
    public String getID() {
        return "rpm";
    }

    @Override
    public String getBundleType() {
        return "INSTALLER";
    }

    @Override
    public Collection<BundlerParamInfo<?>> getBundleParameters() {
        LinkedHashSet results = new LinkedHashSet();
        results.addAll(LinuxAppBundler.getAppBundleParameters());
        results.addAll(LinuxRpmBundler.getRpmBundleParameters());
        return results;
    }

    public static Collection<BundlerParamInfo<?>> getRpmBundleParameters() {
        return Arrays.asList(BUNDLE_NAME, StandardBundlerParam.CATEGORY, StandardBundlerParam.DESCRIPTION, LinuxAppBundler.ICON_PNG, StandardBundlerParam.LICENSE_FILE, StandardBundlerParam.LICENSE_TYPE, StandardBundlerParam.TITLE, StandardBundlerParam.VENDOR);
    }

    @Override
    public File execute(Map<String, ? super Object> params, File outputParentDir) {
        return this.bundle(params, outputParentDir);
    }

    public int getSquareSizeOfImage(File f) {
        try {
            BufferedImage bi = ImageIO.read(f);
            if (bi.getWidth() == bi.getHeight()) {
                return bi.getWidth();
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }
}

