/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.es2;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

class BufferFactory {
    static final int SIZEOF_BYTE = 1;
    static final int SIZEOF_SHORT = 2;
    static final int SIZEOF_CHAR = 2;
    static final int SIZEOF_INT = 4;
    static final int SIZEOF_FLOAT = 4;
    static final int SIZEOF_LONG = 8;
    static final int SIZEOF_DOUBLE = 8;
    private static final boolean isLittleEndian;

    BufferFactory() {
    }

    static boolean isLittleEndian() {
        return isLittleEndian;
    }

    static ByteBuffer newDirectByteBuffer(int size) {
        return BufferFactory.nativeOrder(ByteBuffer.allocateDirect(size));
    }

    static ByteBuffer nativeOrder(ByteBuffer buf) {
        return buf.order(ByteOrder.nativeOrder());
    }

    static boolean isDirect(Object buf) {
        if (buf == null) {
            return true;
        }
        if (buf instanceof ByteBuffer) {
            return ((ByteBuffer)buf).isDirect();
        }
        if (buf instanceof FloatBuffer) {
            return ((FloatBuffer)buf).isDirect();
        }
        if (buf instanceof DoubleBuffer) {
            return ((DoubleBuffer)buf).isDirect();
        }
        if (buf instanceof CharBuffer) {
            return ((CharBuffer)buf).isDirect();
        }
        if (buf instanceof ShortBuffer) {
            return ((ShortBuffer)buf).isDirect();
        }
        if (buf instanceof IntBuffer) {
            return ((IntBuffer)buf).isDirect();
        }
        if (buf instanceof LongBuffer) {
            return ((LongBuffer)buf).isDirect();
        }
        throw new RuntimeException("Unexpected buffer type " + buf.getClass().getName());
    }

    static int getDirectBufferByteOffset(Object buf) {
        if (buf == null) {
            return 0;
        }
        if (buf instanceof Buffer) {
            int pos = ((Buffer)buf).position();
            if (buf instanceof ByteBuffer) {
                return pos;
            }
            if (buf instanceof FloatBuffer) {
                return pos * 4;
            }
            if (buf instanceof IntBuffer) {
                return pos * 4;
            }
            if (buf instanceof ShortBuffer) {
                return pos * 2;
            }
            if (buf instanceof DoubleBuffer) {
                return pos * 8;
            }
            if (buf instanceof LongBuffer) {
                return pos * 8;
            }
            if (buf instanceof CharBuffer) {
                return pos * 2;
            }
        }
        throw new RuntimeException("Disallowed array backing store type in buffer " + buf.getClass().getName());
    }

    static Object getArray(Object buf) {
        if (buf == null) {
            return null;
        }
        if (buf instanceof ByteBuffer) {
            return ((ByteBuffer)buf).array();
        }
        if (buf instanceof FloatBuffer) {
            return ((FloatBuffer)buf).array();
        }
        if (buf instanceof IntBuffer) {
            return ((IntBuffer)buf).array();
        }
        if (buf instanceof ShortBuffer) {
            return ((ShortBuffer)buf).array();
        }
        if (buf instanceof DoubleBuffer) {
            return ((DoubleBuffer)buf).array();
        }
        if (buf instanceof LongBuffer) {
            return ((LongBuffer)buf).array();
        }
        if (buf instanceof CharBuffer) {
            return ((CharBuffer)buf).array();
        }
        throw new RuntimeException("Disallowed array backing store type in buffer " + buf.getClass().getName());
    }

    static int getIndirectBufferByteOffset(Object buf) {
        if (buf == null) {
            return 0;
        }
        if (buf instanceof Buffer) {
            int pos = ((Buffer)buf).position();
            if (buf instanceof ByteBuffer) {
                return ((ByteBuffer)buf).arrayOffset() + pos;
            }
            if (buf instanceof FloatBuffer) {
                return 4 * (((FloatBuffer)buf).arrayOffset() + pos);
            }
            if (buf instanceof IntBuffer) {
                return 4 * (((IntBuffer)buf).arrayOffset() + pos);
            }
            if (buf instanceof ShortBuffer) {
                return 2 * (((ShortBuffer)buf).arrayOffset() + pos);
            }
            if (buf instanceof DoubleBuffer) {
                return 8 * (((DoubleBuffer)buf).arrayOffset() + pos);
            }
            if (buf instanceof LongBuffer) {
                return 8 * (((LongBuffer)buf).arrayOffset() + pos);
            }
            if (buf instanceof CharBuffer) {
                return 2 * (((CharBuffer)buf).arrayOffset() + pos);
            }
        }
        throw new RuntimeException("Unknown buffer type " + buf.getClass().getName());
    }

    static {
        ByteBuffer tst_b = BufferFactory.newDirectByteBuffer(4);
        IntBuffer tst_i = tst_b.asIntBuffer();
        ShortBuffer tst_s = tst_b.asShortBuffer();
        tst_i.put(0, 168496141);
        isLittleEndian = 3085 == tst_s.get(0);
    }
}

