/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.common.about;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.glsof.common.about.AbstractButtonsDialog;
import net.sourceforge.glsof.common.about.TextDialog;
import net.sourceforge.glsof.common.i18n.Messages;

public class AboutDialog
extends AbstractButtonsDialog {
    private static final String LICENSE_LABEL = Messages.NLS("License");
    private static final String LICENSE_FILE_PATH = "/COPYING";
    private String _imageFilePath;
    private String _description;
    private String _version;
    private String _websiteUrl;
    private String _documentationUrl;

    public AboutDialog(String filePath, String description, String version, String websiteUrl, String documentationUrl) {
        super(Messages.NLS("About"));
        this._imageFilePath = filePath;
        this._description = description;
        this._version = version;
        this._websiteUrl = websiteUrl;
        this._documentationUrl = documentationUrl;
    }

    @Override
    protected void createDialogArea(JPanel parent) {
        parent.setLayout(new BoxLayout(parent, 1));
        ImageIcon image = new ImageIcon(this.getClass().getResource(this._imageFilePath));
        JLabel imageLabel = new JLabel(image);
        imageLabel.setAlignmentX(0.5f);
        parent.add(imageLabel);
        this.createLabel(parent, this._description);
        this.createLabel(parent, Messages.NLS("Version") + " " + this._version);
        this.createLabel(parent, Messages.NLS("Copyright"));
        this.createLabel(parent, "Email: geekgnele@tin.it");
        this.createLabelLink(parent, Messages.NLS("Website"), this._websiteUrl);
        this.createLabelLink(parent, Messages.NLS("Online_Documentation"), this._documentationUrl);
    }

    private void createLabel(JPanel parent, String text) {
        JLabel label = new JLabel(text);
        parent.add(label);
        label.setAlignmentX(0.5f);
    }

    private void createLabelLink(JPanel parent, String text, String url) {
        JLabel label = new JLabel("<html><div align=center width=368px><u>" + text + "</u></div></html>");
        label.setForeground(new Color(170));
        label.addMouseListener(new LinkAction(url));
        label.setAlignmentX(0.5f);
        parent.add(label);
    }

    @Override
    protected void createButtonsForButtonBar(JPanel parent) {
        this.createButton(parent, 1024, LICENSE_LABEL);
        this.createButton(parent, 0, Messages.NLS("Close"));
    }

    @Override
    protected void buttonPressed(int buttonId) {
        if (buttonId == 1024) {
            TextDialog dialog = new TextDialog(LICENSE_FILE_PATH);
            dialog.create();
            dialog.show();
        } else {
            this.dispose();
        }
    }

    private class LinkAction
    extends MouseAdapter {
        private String _url;

        public LinkAction(String url) {
            this._url = url;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() <= 0 && !Desktop.isDesktopSupported()) {
                return;
            }
            try {
                Desktop.getDesktop().browse(new URI(this._url));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

