/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.io;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import org.apache.commons.betwixt.BindingConfiguration;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.XMLBeanInfo;
import org.apache.commons.betwixt.XMLIntrospector;
import org.apache.commons.betwixt.io.BeanRuleSet;
import org.apache.commons.betwixt.io.read.ReadConfiguration;
import org.apache.commons.betwixt.io.read.ReadContext;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ExtendedBaseRules;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class BeanReader
extends Digester {
    private XMLIntrospector introspector = new XMLIntrospector();
    private Log log = LogFactory.getLog(class$org$apache$commons$betwixt$io$BeanReader == null ? (class$org$apache$commons$betwixt$io$BeanReader = BeanReader.class$("org.apache.commons.betwixt.io.BeanReader")) : class$org$apache$commons$betwixt$io$BeanReader);
    private Set registeredClasses = new HashSet();
    private BindingConfiguration bindingConfiguration = new BindingConfiguration();
    private ReadConfiguration readConfiguration = new ReadConfiguration();
    static /* synthetic */ Class class$org$apache$commons$betwixt$io$BeanReader;

    public BeanReader() {
        this.setRules(new ExtendedBaseRules());
    }

    public BeanReader(SAXParser parser) {
        super(parser);
        this.setRules(new ExtendedBaseRules());
    }

    public BeanReader(XMLReader reader) {
        super(reader);
        this.setRules(new ExtendedBaseRules());
    }

    public void registerBeanClass(Class beanClass) throws IntrospectionException {
        if (!this.registeredClasses.contains(beanClass)) {
            this.register(beanClass, null);
        } else if (this.log.isWarnEnabled()) {
            this.log.warn("Cannot add class " + beanClass.getName() + " since it already exists");
        }
    }

    private void register(Class beanClass, String path) throws IntrospectionException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Registering class " + beanClass);
        }
        XMLBeanInfo xmlInfo = this.introspector.introspect(beanClass);
        this.registeredClasses.add(beanClass);
        ElementDescriptor elementDescriptor = xmlInfo.getElementDescriptor();
        if (path == null) {
            path = elementDescriptor.getQualifiedName();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Added path: " + path + ", mapped to: " + beanClass.getName());
        }
        this.addBeanCreateRule(path, elementDescriptor, beanClass);
    }

    public void registerBeanClass(String path, Class beanClass) throws IntrospectionException {
        if (!this.registeredClasses.contains(beanClass)) {
            this.register(beanClass, path);
        } else if (this.log.isWarnEnabled()) {
            this.log.warn("Cannot add class " + beanClass.getName() + " since it already exists");
        }
    }

    public void registerMultiMapping(InputSource mapping) throws IntrospectionException, IOException, SAXException {
        Class[] mappedClasses = this.introspector.register(mapping);
        int size = mappedClasses.length;
        for (int i = 0; i < size; ++i) {
            Class beanClass = mappedClasses[i];
            if (this.registeredClasses.contains(beanClass)) continue;
            this.register(beanClass, null);
        }
    }

    public void registerBeanClass(InputSource mapping, Class beanClass) throws IntrospectionException, IOException, SAXException {
        if (!this.registeredClasses.contains(beanClass)) {
            this.introspector.register(beanClass, mapping);
            this.register(beanClass, null);
        } else if (this.log.isWarnEnabled()) {
            this.log.warn("Cannot add class " + beanClass.getName() + " since it already exists");
        }
    }

    public void flushRegisteredBeanClasses() {
        this.registeredClasses.clear();
    }

    public void deregisterBeanClass(Class beanClass) {
        this.registeredClasses.remove(beanClass);
    }

    public XMLIntrospector getXMLIntrospector() {
        return this.introspector;
    }

    public void setXMLIntrospector(XMLIntrospector introspector) {
        this.introspector = introspector;
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
        this.setLogger(log);
    }

    public boolean getMatchIDs() {
        return this.getBindingConfiguration().getMapIDs();
    }

    public void setMatchIDs(boolean matchIDs) {
        this.getBindingConfiguration().setMapIDs(matchIDs);
    }

    public BindingConfiguration getBindingConfiguration() {
        return this.bindingConfiguration;
    }

    public void setBindingConfiguration(BindingConfiguration bindingConfiguration) {
        this.bindingConfiguration = bindingConfiguration;
    }

    public ReadConfiguration getReadConfiguration() {
        return this.readConfiguration;
    }

    public void setReadConfiguration(ReadConfiguration readConfiguration) {
        this.readConfiguration = readConfiguration;
    }

    protected void addBeanCreateRule(String path, ElementDescriptor elementDescriptor, Class beanClass) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Adding BeanRuleSet for " + beanClass);
        }
        BeanRuleSet ruleSet = new BeanRuleSet(this.introspector, path, elementDescriptor, beanClass, this.makeContext());
        this.addRuleSet(ruleSet);
    }

    private ReadContext makeContext() {
        return new ReadContext(this.log, this.bindingConfiguration, this.readConfiguration);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

