/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.expression;

import java.lang.reflect.Method;
import org.apache.commons.betwixt.expression.Context;
import org.apache.commons.betwixt.expression.Expression;

public class MethodExpression
implements Expression {
    protected static Object[] NULL_ARGUMENTS;
    protected static Class[] NULL_CLASSES;
    private Method method;

    public MethodExpression() {
    }

    public MethodExpression(Method method) {
        this.method = method;
    }

    public Object evaluate(Context context) {
        Object bean = context.getBean();
        if (bean != null) {
            Object[] arguments = this.getArguments();
            try {
                return this.method.invoke(bean, arguments);
            }
            catch (IllegalAccessException e) {
                Method alternate = null;
                try {
                    Class<?> type = bean.getClass();
                    alternate = this.findAlternateMethod(type, this.method);
                    if (alternate != null) {
                        try {
                            return alternate.invoke(bean, arguments);
                        }
                        catch (IllegalAccessException ex) {
                            alternate.setAccessible(true);
                            return alternate.invoke(bean, arguments);
                        }
                    }
                    this.method.setAccessible(true);
                    return this.method.invoke(bean, arguments);
                }
                catch (Exception e2) {
                    this.handleException(context, e2, alternate);
                }
            }
            catch (Exception e) {
                this.handleException(context, e, this.method);
            }
        }
        return null;
    }

    public void update(Context context, String newValue) {
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    protected Object[] getArguments() {
        return NULL_ARGUMENTS;
    }

    protected Method findAlternateMethod(Class type, Method method) {
        Class<?>[] interfaces = type.getInterfaces();
        if (interfaces != null) {
            String name = method.getName();
            int size = interfaces.length;
            for (int i = 0; i < size; ++i) {
                Class<?> otherType = interfaces[i];
                try {
                    Method alternate = otherType.getMethod(name, NULL_CLASSES);
                    if (alternate != null && alternate != method) {
                        return alternate;
                    }
                    continue;
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    protected void handleException(Context context, Exception e, Method m) {
        context.getLog().error("[MethodExpression] Cannot evaluate method " + m, e);
    }

    protected void handleException(Context context, Exception e) {
        context.getLog().error("[MethodExpression] Cannot evaluate method ", e);
    }

    public String toString() {
        return "MethodExpression [method=" + this.method + "]";
    }
}

