/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.queries.stats;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.glsof.queries.sort.NumericSortDownComparator;
import net.sourceforge.glsof.queries.sort.NumericSortUpComparator;
import net.sourceforge.glsof.queries.sort.SortComparator;
import net.sourceforge.glsof.queries.sort.TextSortDownComparator;
import net.sourceforge.glsof.queries.sort.TextSortUpComparator;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class QueriesChartSortListener
implements Listener {
    private static final Map<String, SortComparator> _comparators = new HashMap<String, SortComparator>();
    private Table _table;
    private String _sortName;
    private String[] _values;
    private int _columnIndex;

    public QueriesChartSortListener(Table table, String sortName, int columns, int columnIndex) {
        this._table = table;
        this._sortName = sortName;
        this._columnIndex = columnIndex;
        this._values = new String[columns - 1];
    }

    @Override
    public void handleEvent(Event e) {
        TableItem[] items = this._table.getItems();
        String direction = this._table.getSortDirection() == 128 ? "up" : "down";
        SortComparator comparator = _comparators.get(this._sortName + direction);
        block0: for (int i = 1; i < items.length; ++i) {
            String value1 = items[i].getText(this._columnIndex);
            for (int j = 0; j < i; ++j) {
                String value2 = items[j].getText(this._columnIndex);
                if (!comparator.compare(value1, value2)) continue;
                for (int k = 0; k < this._values.length; ++k) {
                    this._values[k] = items[i].getText(k);
                }
                items[i].dispose();
                TableItem item = new TableItem(this._table, 0, j);
                item.setText(this._values);
                items = this._table.getItems();
                continue block0;
            }
        }
        this._table.setSortColumn((TableColumn)e.widget);
        this._table.setTopIndex(0);
        if (direction.equals("up")) {
            this._table.setSortDirection(1024);
        } else {
            this._table.setSortDirection(128);
        }
    }

    static {
        _comparators.put("nup", new NumericSortUpComparator());
        _comparators.put("ndown", new NumericSortDownComparator());
        _comparators.put("tup", new TextSortUpComparator());
        _comparators.put("tdown", new TextSortDownComparator());
    }
}

