/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.queries.search;

import java.util.ArrayList;
import java.util.Map;
import net.sourceforge.glsof.common.search.TextMatcherInfo;
import net.sourceforge.glsof.queries.search.QuerySearchInterface;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;

abstract class AbstractQuerySearch
implements QuerySearchInterface {
    private final TextMatcherInfo _textMatcherInfo;
    private int _queryIndex;
    private int _processIndex = -1;

    AbstractQuerySearch(TextMatcherInfo textMatcherInfo) {
        this._textMatcherInfo = textMatcherInfo;
    }

    protected abstract boolean match(Map<String, Table> var1, String var2, int var3, int var4);

    @Override
    public boolean hasFoundMatch(ArrayList<Map<String, Table>> queriesTables, Tree queryTree, String text) {
        int queryIndex = this.getQueryIndex();
        int processIndex = this.getProcessIndex();
        for (int i = queryIndex; i < queriesTables.size(); ++i) {
            if (this.match(queriesTables.get(i), text, queryIndex, processIndex)) {
                return true;
            }
            queryIndex = this.updateQueryIndex(queryTree, queryIndex);
            processIndex = -1;
        }
        return false;
    }

    private int updateQueryIndex(Tree queryTree, int currentQueryIndex) {
        for (int i = currentQueryIndex + 1; i < queryTree.getItemCount(); ++i) {
            if (queryTree.getItem(i).getItemCount() <= 0) continue;
            return i;
        }
        return currentQueryIndex;
    }

    boolean isRequiredInit(String text, boolean caseSensitive) {
        return this._textMatcherInfo.init(text, caseSensitive);
    }

    boolean textMatch(String text, String tableText) {
        return this._textMatcherInfo.match(text, tableText);
    }

    @Override
    public void reset() {
        this._queryIndex = 0;
        this._processIndex = -1;
    }

    @Override
    public int getQueryIndex() {
        return this._queryIndex;
    }

    @Override
    public void setQueryIndex(int queryIndex) {
        this._queryIndex = queryIndex;
    }

    @Override
    public int getProcessIndex() {
        return this._processIndex;
    }

    void setProcessIndex(int processIndex) {
        this._processIndex = processIndex;
    }
}

