/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.queries.editor;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.glsof.common.i18n.Messages;
import net.sourceforge.glsof.queries.dialogs.TextInputDialog;
import net.sourceforge.glsof.queries.editor.PreferencesUIPage;
import net.sourceforge.glsof.queries.model.Preferences;
import net.sourceforge.glsof.queries.model.Row;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

abstract class AbstractPreferencesUIPage
implements PreferencesUIPage {
    Button _activeButton;
    private Button _addButton;
    private Button _removeButton;
    private Table _table;
    private TextInputDialog _dialog;
    private Preferences _page;

    AbstractPreferencesUIPage(Preferences page, TextInputDialog dialog) {
        this._page = page;
        this._dialog = dialog;
    }

    protected abstract void setEnabledWidgetsByActiveControl();

    Composite buildPreferencePage(Composite parent) {
        Composite mainContainer = this.setLayout(parent);
        this.createActiveButton(mainContainer);
        this.createTable(mainContainer);
        this.createTableButtons(mainContainer);
        return mainContainer;
    }

    private void createActiveButton(Composite mainContainer) {
        this._activeButton = this.getCheckButtonFillHorizontalWithText(mainContainer, Messages.NLS("Active") + " " + this._page.getId() + " " + Messages.NLS("Control"));
        this._activeButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                AbstractPreferencesUIPage.this.setEnabledWidgetsByActiveControl();
            }
        });
    }

    private void createTableButtons(Composite mainContainer) {
        Composite buttonBox = new Composite(mainContainer, 0);
        buttonBox.setLayout(new FillLayout());
        this.createAddItemButton(buttonBox);
        this.createRemoveItemButton(buttonBox);
    }

    private void createAddItemButton(Composite buttonBox) {
        this._addButton = new Button(buttonBox, 0);
        this._addButton.setText(Messages.NLS("Add"));
        this._addButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                AbstractPreferencesUIPage.this._dialog.setTable(AbstractPreferencesUIPage.this._table);
                if (AbstractPreferencesUIPage.this._dialog.open() == 1) {
                    AbstractPreferencesUIPage.this.packTable();
                }
            }
        });
    }

    private void createRemoveItemButton(Composite buttonBox) {
        this._removeButton = new Button(buttonBox, 0);
        this._removeButton.setText(Messages.NLS("Remove"));
        this._removeButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                AbstractPreferencesUIPage.this._table.remove(AbstractPreferencesUIPage.this._table.getSelectionIndices()[0]);
                AbstractPreferencesUIPage.this.packTable();
                AbstractPreferencesUIPage.this._removeButton.setEnabled(AbstractPreferencesUIPage.this._table.getSelectionCount() != 0);
            }
        });
        this._removeButton.setEnabled(false);
    }

    private Composite setLayout(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout(new GridLayout());
        composite.setLayoutData(new GridData(0, 1, false, true));
        return composite;
    }

    void initWidgets(boolean enabled, List<Row> rowRows) {
        this._activeButton.setSelection(enabled);
        for (Row row : rowRows) {
            String[] values = new String[row.getValues().size()];
            new TableItem(this._table, 0).setText(row.getValues().toArray(values));
        }
        this.packTable();
    }

    private void packTable() {
        for (TableColumn column : this._table.getColumns()) {
            column.pack();
        }
    }

    protected void initPage() {
        this.initWidgets(this._page.isEnabled(), this._page.getTableRows());
    }

    boolean saveBeforeToClose() {
        this.saveActiveControlState(this._activeButton);
        this.saveTableValues();
        return true;
    }

    void saveActiveControlState(Button activeControl) {
        this._page.setEnabled(activeControl.getSelection());
    }

    private void saveTableValues() {
        ArrayList<Row> prefsRows = new ArrayList<Row>();
        for (TableItem row : this._table.getItems()) {
            this.saveTableRowValues(prefsRows, row, new Row());
        }
        this.setTableRows(prefsRows);
    }

    void setTableRows(List<Row> prefsRows) {
        this._page.setTableRows(prefsRows);
    }

    private void saveTableRowValues(List<Row> prefsRows, TableItem row, Row prefsRow) {
        for (int i = 0; i < this._table.getColumnCount(); ++i) {
            prefsRow.addValue(row.getText(i));
        }
        prefsRows.add(prefsRow);
    }

    private void createTable(Composite parent) {
        this._table = new Table(parent, 0);
        this._table.setLinesVisible(true);
        this._table.setHeaderVisible(true);
        for (String c : this._dialog.getColumnsNames()) {
            TableColumn column = new TableColumn(this._table, 0);
            column.setText(c);
            column.pack();
        }
        this._table.setLayoutData(new GridData(1808));
        this._table.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                AbstractPreferencesUIPage.this._removeButton.setEnabled(AbstractPreferencesUIPage.this._table.getSelectionCount() != 0);
            }
        });
    }

    Button getCheckButtonFillHorizontalWithText(Composite composite, String text) {
        Button button = new Button(composite, 32);
        button.setText(text);
        button.setLayoutData(new GridData(768));
        return button;
    }

    protected void enabledWidgets() {
        boolean enable = this._activeButton.getSelection();
        this._table.setEnabled(enable);
        this._addButton.setEnabled(enable);
        this._removeButton.setEnabled(!enable ? false : this._table.getSelectionCount() != 0);
    }

    Preferences getPage() {
        return this._page;
    }

    boolean isTableEnabledAndEmpty() {
        return this._activeButton.getSelection() && this._table.getItemCount() == 0;
    }
}

