/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.queries;

import net.sourceforge.glsof.queries.queries.Queries;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class QueryTreeItemNewListener
implements Listener {
    private final Queries _queries;
    private final TreeEditor _treeEditor;
    private TreeItem _queryTreeItem;
    private Text _text;

    public QueryTreeItemNewListener(Queries queries) {
        this._queries = queries;
        this._treeEditor = new TreeEditor(queries.getQueryTree());
    }

    @Override
    public void handleEvent(Event event) {
        this._treeEditor.horizontalAlignment = 16384;
        this._treeEditor.grabHorizontal = true;
        Tree tree = this._queries.getQueryTree();
        this._queryTreeItem = new TreeItem(tree, 0);
        this._queryTreeItem.setText("");
        tree.setTopItem(this._queryTreeItem);
        this._text = new Text(tree, 0);
        this._text.setText(this._queryTreeItem.getText());
        this._text.selectAll();
        this._text.setFocus();
        this._text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                switch (event.keyCode) {
                    case 13: {
                        QueryTreeItemNewListener.this.createQuery();
                        break;
                    }
                    case 27: {
                        QueryTreeItemNewListener.this.removeQueryLabel();
                        break;
                    }
                }
            }
        });
        this._treeEditor.setEditor(this._text, this._queryTreeItem);
    }

    private void createQuery() {
        this._queries.initQueryItem(this._queryTreeItem, this._text.getText());
        this._text.dispose();
        this._queries.createQueryIfPossible(this._queryTreeItem);
    }

    private void removeQueryLabel() {
        this._queryTreeItem.dispose();
        this._text.dispose();
    }
}

