/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.queries;

import java.io.File;
import java.util.Map;
import net.sourceforge.glsof.common.i18n.Messages;
import net.sourceforge.glsof.common.main.AbstractMainWindow;
import net.sourceforge.glsof.queries.QueriesBuilder;
import net.sourceforge.glsof.queries.QueriesUIConfRepository;
import net.sourceforge.glsof.queries.queries.QueriesUIConf;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class QueriesWindow
extends AbstractMainWindow {
    private static final String SETTINGS_DIR = ".glsof" + File.separator + "queries";
    private static final String ABOUT_LOGO = "/icons/glsof-banner-q.png";
    private MenuItem _logItem;
    private MenuItem _statusBarItem;
    private QueriesUIConfRepository _queriesUIConfRepository;
    private QueriesBuilder _queriesBuilder;
    private int _loggerHeight;

    public static void main(String[] args) {
        Messages.initNLS("nl.queries", "nl.common");
        new QueriesWindow();
    }

    public QueriesWindow() {
        super(Messages.NLS("GLSOF_Queries"));
    }

    @Override
    protected void createMenuItems() {
        Menu fileMenu = this.createMenu(Messages.NLS("FFile"));
        this.createExitItem(fileMenu);
        Menu viewMenu = this.createMenu(Messages.NLS("VView"));
        this._logItem = this.createMenuItem(viewMenu, 32, Messages.NLS("LLogs_CtrlL"), 262220, "");
        this._statusBarItem = this.createMenuItem(viewMenu, 32, Messages.NLS("SStatus_Bar_CtrlS"), 262227, "");
        this.createFullscreenItem(viewMenu);
        Menu helpMenu = this.createMenu(Messages.NLS("HHelp"));
        this.createAboutItem(helpMenu, ABOUT_LOGO, Messages.NLS("A_multi_LSOF-instances_manager"));
    }

    @Override
    protected void createContents(Composite main) {
        File dir = this.createSettingsDir(SETTINGS_DIR);
        this._queriesUIConfRepository = new QueriesUIConfRepository(dir.getParentFile());
        QueriesUIConf conf = this._queriesUIConfRepository.read();
        main.setLocation(conf.getPosX(), conf.getPosY());
        main.setSize(conf.getWidth(), conf.getHeight());
        final Composite mainContainer = new Composite(main, 0);
        mainContainer.setLayout(new GridLayout(1, false));
        this._queriesBuilder = new QueriesBuilder(dir, mainContainer, conf);
        this._loggerHeight = conf.getLogHeight();
        this._logItem.setSelection(conf.isMenuItemLogs());
        this._statusBarItem.setSelection(conf.isMenuItemStatusBar());
        final SashForm vForm = this._queriesBuilder.getVForm();
        this._logItem.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event) {
                if (QueriesWindow.this._logItem.getSelection()) {
                    vForm.setWeights(new int[]{vForm.getWeights()[0] - QueriesWindow.this._loggerHeight, QueriesWindow.this._loggerHeight});
                } else {
                    QueriesWindow.this._loggerHeight = vForm.getWeights()[1];
                    vForm.setWeights(new int[]{vForm.getWeights()[0] + QueriesWindow.this._loggerHeight, 0});
                }
            }
        });
        final Composite barContainer = this._queriesBuilder.getStatusBarContainer();
        this._statusBarItem.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event event) {
                GridData data = (GridData)barContainer.getLayoutData();
                data.exclude = !QueriesWindow.this._statusBarItem.getSelection();
                barContainer.setVisible(!data.exclude);
                mainContainer.layout(false);
            }
        });
        if (this._logItem.getSelection()) {
            this._logItem.notifyListeners(13, new Event());
        }
        this._statusBarItem.notifyListeners(13, new Event());
    }

    @Override
    protected void close() {
        int[] nArray;
        Point point = this.getWindowPosition();
        Point point2 = this.getWindowSize();
        Map<String, Color> map = this._queriesBuilder.getQueries().getLoggerColors();
        int[] nArray2 = this._queriesBuilder.getHForm().getWeights();
        if (this._queriesBuilder.getVForm().getWeights()[1] == 0) {
            int[] nArray3 = new int[2];
            nArray3[0] = this._queriesBuilder.getVForm().getWeights()[0];
            nArray = nArray3;
            nArray3[1] = this._loggerHeight;
        } else {
            nArray = this._queriesBuilder.getVForm().getWeights();
        }
        this._queriesUIConfRepository.save(point, point2, map, nArray2, nArray, this._logItem.getSelection(), this._statusBarItem.getSelection());
        this._queriesBuilder.getQueries().stopAllTheQueries();
    }
}

