/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.common.about;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.glsof.common.about.AbstractButtonsDialog;
import net.sourceforge.glsof.common.i18n.Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TextDialog
extends AbstractButtonsDialog {
    private String _filePath;

    public TextDialog(Shell shell, String filePath) {
        super(shell, Messages.NLS("License"));
        this._filePath = filePath;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        Text area = new Text(composite, 2826);
        area.setEditable(false);
        try {
            area.setText(new String(this.getBytesFromFile(new File(this._filePath))));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        area.setBounds(0, 0, 500, 400);
        return composite;
    }

    @Override
    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, Messages.NLS("Close"));
    }

    @Override
    protected void buttonPressed(int buttonId) {
        this.close();
    }

    private byte[] getBytesFromFile(File file) throws IOException {
        int offset;
        int numRead;
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File is too large! (larger or equal to 2G)");
        }
        byte[] bytes = new byte[(int)length];
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }
}

