"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var electron_1 = require("electron");
var eventType_1 = require("../lib/eventType");
var ConfigurationPersistence_1 = require("../settings/ConfigurationPersistence");
var environment = require("./environment");
var windowManager = require("./window-manager");
var isFirstInstance = undefined;
exports.isFirstInstance = isFirstInstance;
var checkForUpdate = function () {
    if (environment.platform.IS_WINDOWS) {
        var squirrel_1 = require('./squirrel');
        squirrel_1.handleSquirrelEvent(isFirstInstance);
        electron_1.ipcMain.on(eventType_1.EVENT_TYPE.WRAPPER.UPDATE, function () { return squirrel_1.installUpdate(); });
    }
};
exports.checkForUpdate = checkForUpdate;
var checkSingleInstance = function () {
    if (process.mas) {
        exports.isFirstInstance = isFirstInstance = true;
    }
    else {
        exports.isFirstInstance = isFirstInstance = electron_1.app.requestSingleInstanceLock();
        if (!environment.platform.IS_WINDOWS && !isFirstInstance) {
            quit();
        }
        else {
            electron_1.app.on('second-instance', function () { return windowManager.showPrimaryWindow(); });
        }
    }
};
exports.checkSingleInstance = checkSingleInstance;
var quit = function () {
    ConfigurationPersistence_1.settings.persistToFile();
    electron_1.app.exit();
};
exports.quit = quit;
var relaunch = function () {
    if (environment.platform.IS_MAC_OS) {
        windowManager.getPrimaryWindow().webContents.send(eventType_1.EVENT_TYPE.WRAPPER.RELOAD);
    }
    else {
        electron_1.app.relaunch();
        quit();
    }
};
exports.relaunch = relaunch;
//# sourceMappingURL=lifecycle.js.map