"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var RandomUtil = require("./RandomUtil");
exports.STRONG_BLUE = {
    color: '#2391d3',
    id: 1,
    name: 'StrongBlue',
};
exports.STRONG_LIME_GREEN = {
    color: '#00c800',
    id: 2,
    name: 'StrongLimeGreen',
};
exports.DEPRECATED_YELLOW = {
    color: '#febf02',
    id: 3,
    name: 'Yellow',
};
exports.VIVID_RED = {
    color: '#fb0807',
    id: 4,
    name: 'VividRed',
};
exports.BRIGHT_ORANGE = {
    color: '#ff8900',
    id: 5,
    name: 'BrightOrange',
};
exports.SOFT_PINK = {
    color: '#fe5ebd',
    id: 6,
    name: 'SoftPink',
};
exports.VIOLET = {
    color: '#9c00fe',
    id: 7,
    name: 'Violet',
};
exports.ACCENT_COLORS = [
    exports.BRIGHT_ORANGE,
    exports.SOFT_PINK,
    exports.STRONG_BLUE,
    exports.STRONG_LIME_GREEN,
    exports.VIOLET,
    exports.VIVID_RED,
];
exports.getById = function (id) { return exports.ACCENT_COLORS.find(function (color) { return color.id === id; }); };
exports.getRandom = function () { return RandomUtil.randomArrayElement(exports.ACCENT_COLORS); };
exports.DEPRECATED_ACCENT_COLORS = [
    exports.BRIGHT_ORANGE,
    exports.DEPRECATED_YELLOW,
    exports.SOFT_PINK,
    exports.STRONG_BLUE,
    exports.STRONG_LIME_GREEN,
    exports.VIOLET,
    exports.VIVID_RED,
];
exports.DEPRECATED_getById = function (id) {
    return exports.DEPRECATED_ACCENT_COLORS.find(function (color) { return color.id === id; });
};
//# sourceMappingURL=AccentColor.js.map