"use strict";
var __values = (this && this.__values) || function (o) {
    var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
    if (m) return m.call(o);
    return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
};
Object.defineProperty(exports, "__esModule", { value: true });
var Electron = require("electron");
var config = require("../js/config");
var ConfigurationPersistence_1 = require("../settings/ConfigurationPersistence");
var SettingsType_1 = require("../settings/SettingsType");
var cs = require('../../locale/strings-cs');
var da = require('../../locale/strings-da');
var de = require('../../locale/strings-de');
var el = require('../../locale/strings-el');
var en = require('../../locale/strings-en');
var es = require('../../locale/strings-es');
var et = require('../../locale/strings-et');
var fi = require('../../locale/strings-fi');
var fr = require('../../locale/strings-fr');
var hr = require('../../locale/strings-hr');
var hu = require('../../locale/strings-hu');
var it = require('../../locale/strings-it');
var lt = require('../../locale/strings-lt');
var nl = require('../../locale/strings-nl');
var pl = require('../../locale/strings-pl');
var pt = require('../../locale/strings-pt');
var ro = require('../../locale/strings-ro');
var ru = require('../../locale/strings-ru');
var sk = require('../../locale/strings-sk');
var sl = require('../../locale/strings-sl');
var tr = require('../../locale/strings-tr');
var uk = require('../../locale/strings-uk');
var app = Electron.app || Electron.remote.app;
var LANGUAGES = {
    cs: cs,
    da: da,
    de: de,
    el: el,
    en: en,
    es: es,
    et: et,
    fi: fi,
    fr: fr,
    hr: hr,
    hu: hu,
    it: it,
    lt: lt,
    nl: nl,
    pl: pl,
    pt: pt,
    ro: ro,
    ru: ru,
    sk: sk,
    sl: sl,
    tr: tr,
    uk: uk,
};
exports.LANGUAGES = LANGUAGES;
var SUPPORTED_LANGUAGES = {
    en: 'English',
    cs: 'Čeština',
    da: 'Dansk',
    de: 'Deutsch',
    el: 'Ελληνικά',
    et: 'Eesti',
    es: 'Español',
    fr: 'Français',
    hr: 'Hrvatski',
    it: 'Italiano',
    lt: 'Lietuvos',
    hu: 'Magyar',
    nl: 'Nederlands',
    pl: 'Polski',
    pt: 'Português do Brasil',
    ro: 'Română',
    ru: 'Русский',
    sk: 'Slovenčina',
    sl: 'Slovenščina',
    fi: 'Suomi',
    tr: 'Türkçe',
    uk: 'Українська',
};
exports.SUPPORTED_LANGUAGES = SUPPORTED_LANGUAGES;
var current;
var getSupportedLanguageKeys = function () {
    return Object.keys(SUPPORTED_LANGUAGES);
};
var getCurrent = function () {
    if (!current) {
        var defaultLocale = parseLocale(app.getLocale().substr(0, 2));
        current = ConfigurationPersistence_1.settings.restore(SettingsType_1.SettingsType.LOCALE, defaultLocale);
    }
    return current;
};
exports.getCurrent = getCurrent;
var parseLocale = function (locale) {
    var languageKeys = getSupportedLanguageKeys();
    return languageKeys.find(function (languageKey) { return languageKey === locale; }) || languageKeys[0];
};
var customReplacements = {
    appName: config.NAME,
    maximumAccounts: config.MAXIMUM_ACCOUNTS.toString(),
};
var getText = function (stringIdentifier) {
    var e_1, _a;
    var strings = getCurrent();
    var str = LANGUAGES[strings][stringIdentifier] || LANGUAGES.en[stringIdentifier] || '';
    if (str) {
        try {
            for (var _b = __values(Object.keys(customReplacements)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var replacement = _c.value;
                var regex = new RegExp("{{" + replacement + "}}", 'g');
                if (str.match(regex)) {
                    str = str.replace(regex, customReplacements[replacement]);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
    }
    return str;
};
exports.getText = getText;
var setLocale = function (locale) {
    current = parseLocale(locale);
    ConfigurationPersistence_1.settings.save(SettingsType_1.SettingsType.LOCALE, current);
};
exports.setLocale = setLocale;
//# sourceMappingURL=locale.js.map