/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.types.TypeEvalContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/python/inspections/PyThirdPartyInspectionExtension;", "Lcom/jetbrains/python/inspections/PyInspectionExtension;", "()V", "ignoreMethodParameters", "", "function", "Lcom/jetbrains/python/psi/PyFunction;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "resolvesTo", "expression", "Lcom/jetbrains/python/psi/PyExpression;", "qualifiedName", "", "resolveContext", "Lcom/jetbrains/python/psi/resolve/PyResolveContext;", "intellij.python.community.impl"})
public final class PyThirdPartyInspectionExtension
extends PyInspectionExtension {
    @Override
    public boolean ignoreMethodParameters(@NotNull PyFunction function, @NotNull TypeEvalContext context) {
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        PyClass cls = function.getContainingClass();
        if (cls != null) {
            String interfaceQName = "zope.interface.interface.Interface";
            if (cls.isSubclass(interfaceQName, context)) {
                return true;
            }
            PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(context);
            PyExpression[] pyExpressionArray = cls.getSuperClassExpressions();
            int n = pyExpressionArray.length;
            for (int i = 0; i < n; ++i) {
                PyExpression expression;
                PyExpression pyExpression = expression = pyExpressionArray[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)pyExpression, (String)"expression");
                PyResolveContext pyResolveContext = resolveContext;
                Intrinsics.checkExpressionValueIsNotNull((Object)pyResolveContext, (String)"resolveContext");
                if (!this.resolvesTo(pyExpression, interfaceQName, pyResolveContext)) continue;
                return true;
            }
        }
        return false;
    }

    private final boolean resolvesTo(PyExpression expression, String qualifiedName, PyResolveContext resolveContext) {
        return ContainerUtil.exists((Iterable)PyUtil.multiResolveTopPriority((PsiElement)expression, resolveContext), (Condition)new Condition<T>(qualifiedName){
            final /* synthetic */ String $qualifiedName;

            public final boolean value(PsiElement it) {
                return it instanceof PyElement && Intrinsics.areEqual((Object)QualifiedNameFinder.getQualifiedName((PyElement)it), (Object)this.$qualifiedName);
            }
            {
                this.$qualifiedName = string;
            }
        });
    }
}

