/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.highlighting;

import com.intellij.codeInsight.daemon.RainbowVisitor;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.highlighting.PyRainbowVisitor;
import com.jetbrains.python.highlighting.PyRainbowVisitor$getTargetContext$;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyGlobalStatement;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 &2\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\b\u0010\f\u001a\u00020\u0000H\u0016J\u0018\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u001c\u0010#\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0006H\u0016\u00a8\u0006'"}, d2={"Lcom/jetbrains/python/highlighting/PyRainbowVisitor;", "Lcom/intellij/codeInsight/daemon/RainbowVisitor;", "()V", "addInfo", "", "context", "Lcom/intellij/psi/PsiElement;", "rainbowElement", "name", "", "key", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "clone", "getLeastCommonScope", "Lcom/jetbrains/python/codeInsight/controlflow/ScopeOwner;", "elements", "", "getNamedParameterContext", "namedParameter", "Lcom/jetbrains/python/psi/PyNamedParameter;", "getReferenceContext", "referenceExpression", "Lcom/jetbrains/python/psi/PyReferenceExpression;", "visitedReferenceExpressions", "", "getTargetContext", "targetExpression", "Lcom/jetbrains/python/psi/PyTargetExpression;", "processNamedParameter", "processReference", "processTarget", "suitableForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "updateNameIfGlobal", "visit", "element", "Companion", "intellij.python.community.impl"})
public final class PyRainbowVisitor
extends RainbowVisitor {
    private static final Set<String> IGNORED_NAMES;
    private static final TextAttributesKey DEFAULT_HIGHLIGHTING_KEY;
    @NotNull
    private static final Set<TextAttributesKey> HIGHLIGHTING_KEYS;
    public static final Companion Companion;

    public boolean suitableForFile(@NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return file instanceof PyFile;
    }

    public void visit(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        PsiElement psiElement = element;
        if (psiElement instanceof PyReferenceExpression) {
            this.processReference((PyReferenceExpression)element);
        } else if (psiElement instanceof PyTargetExpression) {
            this.processTarget((PyTargetExpression)element);
        } else if (psiElement instanceof PyNamedParameter) {
            this.processNamedParameter((PyNamedParameter)element);
        }
    }

    @NotNull
    public PyRainbowVisitor clone() {
        return new PyRainbowVisitor();
    }

    private final void processReference(PyReferenceExpression referenceExpression) {
        PyReferenceExpression pyReferenceExpression = referenceExpression;
        PyRainbowVisitor pyRainbowVisitor = this;
        Set set = new LinkedHashSet();
        PsiElement psiElement = pyRainbowVisitor.getReferenceContext(pyReferenceExpression, set);
        if (psiElement == null) {
            return;
        }
        PsiElement context = psiElement;
        String string = this.updateNameIfGlobal(context, referenceExpression.getName());
        if (string == null) {
            return;
        }
        String name = string;
        PyRainbowVisitor.addInfo$default(this, context, (PsiElement)referenceExpression, name, null, 8, null);
    }

    private final void processTarget(PyTargetExpression targetExpression) {
        PsiElement psiElement = this.getTargetContext(targetExpression);
        if (psiElement == null) {
            return;
        }
        PsiElement context = psiElement;
        String string = this.updateNameIfGlobal(context, targetExpression.getName());
        if (string == null) {
            return;
        }
        String name = string;
        PyRainbowVisitor.addInfo$default(this, context, targetExpression, name, null, 8, null);
    }

    private final void processNamedParameter(PyNamedParameter namedParameter) {
        PsiElement psiElement = this.getNamedParameterContext(namedParameter);
        if (psiElement == null) {
            return;
        }
        PsiElement context = psiElement;
        String string = namedParameter.getName();
        if (string == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"namedParameter.name ?: return");
        String name = string;
        PsiElement psiElement2 = namedParameter.getNameIdentifier();
        if (psiElement2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"namedParameter.nameIdentifier ?: return");
        PsiElement element = psiElement2;
        this.addInfo(context, element, name, PyHighlighter.PY_PARAMETER);
    }

    private final PsiElement getReferenceContext(PyReferenceExpression referenceExpression, Set<PyReferenceExpression> visitedReferenceExpressions) {
        PsiElement psiElement;
        if (referenceExpression.isQualified() || CollectionsKt.contains((Iterable)IGNORED_NAMES, (Object)referenceExpression.getName())) {
            return null;
        }
        PsiElement resolved = referenceExpression.getReference().resolve();
        PsiElement psiElement2 = resolved;
        if (psiElement2 instanceof PyTargetExpression) {
            psiElement = this.getTargetContext((PyTargetExpression)resolved);
        } else if (psiElement2 instanceof PyNamedParameter) {
            psiElement = this.getNamedParameterContext((PyNamedParameter)resolved);
        } else {
            if (psiElement2 instanceof PyReferenceExpression) {
                if (!visitedReferenceExpressions.add((PyReferenceExpression)resolved)) {
                    return (PsiElement)this.getLeastCommonScope((Collection<? extends PsiElement>)visitedReferenceExpressions);
                }
                return ((PyReferenceExpression)resolved).getParent() instanceof PyAugAssignmentStatement ? this.getReferenceContext((PyReferenceExpression)resolved, visitedReferenceExpressions) : null;
            }
            psiElement = null;
        }
        return psiElement;
    }

    /*
     * WARNING - void declaration
     */
    private final PsiElement getTargetContext(PyTargetExpression targetExpression) {
        Object v3;
        block9: {
            Sequence $receiver$iv;
            boolean resolvesToGlobal2;
            Object[] resolveResults;
            block8: {
                boolean bl;
                void $receiver$iv2;
                if (targetExpression.isQualified() || CollectionsKt.contains((Iterable)IGNORED_NAMES, (Object)targetExpression.getName())) {
                    return null;
                }
                PsiElement parent = targetExpression.getParent();
                if (parent instanceof PyGlobalStatement) {
                    return (PsiElement)targetExpression.getContainingFile();
                }
                if (parent instanceof PyNonlocalStatement) {
                    PsiElement outerResolved = targetExpression.getReference().resolve();
                    return outerResolved instanceof PyTargetExpression ? this.getTargetContext((PyTargetExpression)outerResolved) : null;
                }
                Object[] objectArray = targetExpression.getReference(PyResolveContext.noImplicits()).multiResolve(false);
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"targetExpression.getRefe\u2026ts()).multiResolve(false)");
                resolveResults = objectArray;
                Sequence sequence = SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])resolveResults), (Function1)getTargetContext.resolvesToGlobal.1.INSTANCE);
                for (Object element$iv : $receiver$iv2) {
                    PsiElement it = (PsiElement)element$iv;
                    if (!(it instanceof PyTargetExpression && ((PyTargetExpression)it).getParent() instanceof PyGlobalStatement)) continue;
                    bl = true;
                    break block8;
                }
                bl = resolvesToGlobal2 = false;
            }
            if (resolvesToGlobal2) {
                return (PsiElement)targetExpression.getContainingFile();
            }
            Iterator iterator = SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])resolveResults), (Function1)getTargetContext.resolvedNonLocal.1.INSTANCE);
            Sequence sequence = SequencesKt.filter((Sequence)$receiver$iv, (Function1)getTargetContext$$inlined$filterIsInstance$1.INSTANCE);
            if (sequence == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
            }
            Sequence sequence2 = $receiver$iv = sequence;
            for (Object e : sequence2) {
                PyTargetExpression it = (PyTargetExpression)e;
                if (!(it.getParent() instanceof PyNonlocalStatement)) continue;
                v3 = e;
                break block9;
            }
            v3 = null;
        }
        PyTargetExpression resolvedNonLocal2 = v3;
        if (resolvedNonLocal2 != null) {
            return this.getTargetContext(resolvedNonLocal2);
        }
        ScopeOwner scopeOwner = ScopeUtil.getScopeOwner(targetExpression);
        return scopeOwner instanceof PyFile || scopeOwner instanceof PyFunction || scopeOwner instanceof PyLambdaExpression ? (PsiElement)scopeOwner : null;
    }

    private final PsiElement getNamedParameterContext(PyNamedParameter namedParameter) {
        if (namedParameter.isSelf()) {
            return null;
        }
        ScopeOwner scopeOwner = ScopeUtil.getScopeOwner(namedParameter);
        return scopeOwner instanceof PyLambdaExpression || scopeOwner instanceof PyFunction ? (PsiElement)scopeOwner : null;
    }

    private final String updateNameIfGlobal(PsiElement context, String name) {
        return context instanceof PyFile && name != null ? "global_" + name : name;
    }

    private final void addInfo(PsiElement context, PsiElement rainbowElement, String name, TextAttributesKey key) {
        this.addInfo(this.getInfo(context, rainbowElement, name, key));
    }

    static /* synthetic */ void addInfo$default(PyRainbowVisitor pyRainbowVisitor, PsiElement psiElement, PsiElement psiElement2, String string, TextAttributesKey textAttributesKey, int n, Object object) {
        if ((n & 8) != 0) {
            textAttributesKey = DEFAULT_HIGHLIGHTING_KEY;
        }
        pyRainbowVisitor.addInfo(psiElement, psiElement2, string, textAttributesKey);
    }

    private final ScopeOwner getLeastCommonScope(Collection<? extends PsiElement> elements) {
        ScopeOwner result = null;
        Iterable $receiver$iv = elements;
        for (Object element$iv : $receiver$iv) {
            PsiElement it = (PsiElement)element$iv;
            ScopeOwner currentScopeOwner = ScopeUtil.getScopeOwner(it);
            if (result == null) {
                result = currentScopeOwner;
                continue;
            }
            if (!(Intrinsics.areEqual((Object)result, (Object)currentScopeOwner) ^ true) || currentScopeOwner == null || !PsiTreeUtil.isAncestor((PsiElement)((PsiElement)result), (PsiElement)((PsiElement)currentScopeOwner), (boolean)true)) continue;
            result = currentScopeOwner;
        }
        return result;
    }

    static {
        Companion = new Companion(null);
        IGNORED_NAMES = SetsKt.setOf((Object[])new String[]{"None", "True", "False"});
        DEFAULT_HIGHLIGHTING_KEY = DefaultLanguageHighlighterColors.LOCAL_VARIABLE;
        HIGHLIGHTING_KEYS = SetsKt.setOf((Object[])new TextAttributesKey[]{PyHighlighter.PY_PARAMETER, DEFAULT_HIGHLIGHTING_KEY});
    }

    @NotNull
    public static final Set<TextAttributesKey> getHIGHLIGHTING_KEYS() {
        Companion companion = Companion;
        return HIGHLIGHTING_KEYS;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/highlighting/PyRainbowVisitor$Companion;", "", "()V", "DEFAULT_HIGHLIGHTING_KEY", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "kotlin.jvm.PlatformType", "HIGHLIGHTING_KEYS", "", "HIGHLIGHTING_KEYS$annotations", "getHIGHLIGHTING_KEYS", "()Ljava/util/Set;", "IGNORED_NAMES", "", "intellij.python.community.impl"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void HIGHLIGHTING_KEYS$annotations() {
        }

        @NotNull
        public final Set<TextAttributesKey> getHIGHLIGHTING_KEYS() {
            return HIGHLIGHTING_KEYS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

