/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.proxy;

import com.intellij.openapi.util.io.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jetbrains.annotations.NotNull;

public class PropertiesEncryptionSupport {
    private final Key myKey;

    public PropertiesEncryptionSupport(Key key) {
        this.myKey = key;
    }

    public PropertiesEncryptionSupport() {
        this(PropertiesEncryptionSupport.generateKey());
    }

    public static Key generateKey() {
        byte[] bytes = new byte[16];
        new SecureRandom().nextBytes(bytes);
        return new SecretKeySpec(bytes, "AES");
    }

    @NotNull
    public Properties load(@NotNull File file) throws Exception {
        if (file == null) {
            PropertiesEncryptionSupport.$$$reportNull$$$0(0);
        }
        byte[] bytes = this.decrypt(FileUtil.loadFileBytes((File)file));
        Properties props = new Properties();
        props.load(new ByteArrayInputStream(bytes));
        Properties properties = props;
        if (properties == null) {
            PropertiesEncryptionSupport.$$$reportNull$$$0(1);
        }
        return properties;
    }

    public void store(@NotNull Properties props, @NotNull String comments, @NotNull File file) throws Exception {
        if (props == null) {
            PropertiesEncryptionSupport.$$$reportNull$$$0(2);
        }
        if (comments == null) {
            PropertiesEncryptionSupport.$$$reportNull$$$0(3);
        }
        if (file == null) {
            PropertiesEncryptionSupport.$$$reportNull$$$0(4);
        }
        if (props.isEmpty()) {
            FileUtil.delete((File)file);
            return;
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            props.store(out, comments);
            FileUtil.writeToFile((File)file, (byte[])this.encrypt(out.toByteArray()));
        }
    }

    public byte[] encrypt(byte[] bytes) throws Exception {
        return PropertiesEncryptionSupport.encrypt(bytes, this.myKey);
    }

    public byte[] decrypt(byte[] bytes) throws Exception {
        return PropertiesEncryptionSupport.decrypt(bytes, this.myKey);
    }

    private static byte[] encrypt(byte[] msgBytes, Key key) throws Exception {
        Cipher ciph = Cipher.getInstance("AES/CBC/PKCS5Padding");
        ciph.init(1, key);
        byte[] body = ciph.doFinal(msgBytes);
        byte[] iv = ciph.getIV();
        byte[] data = new byte[4 + iv.length + body.length];
        int length = body.length;
        data[0] = (byte)(length >> 24 & 0xFF);
        data[1] = (byte)(length >> 16 & 0xFF);
        data[2] = (byte)(length >> 8 & 0xFF);
        data[3] = (byte)(length & 0xFF);
        System.arraycopy(iv, 0, data, 4, iv.length);
        System.arraycopy(body, 0, data, 4 + iv.length, body.length);
        return data;
    }

    private static byte[] decrypt(byte[] data, Key key) throws Exception {
        int bodyLength = (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
        int ivlength = data.length - 4 - bodyLength;
        Cipher ciph = Cipher.getInstance("AES/CBC/PKCS5Padding");
        ciph.init(2, key, new IvParameterSpec(data, 4, ivlength));
        return ciph.doFinal(data, 4 + ivlength, bodyLength);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/proxy/PropertiesEncryptionSupport";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "props";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/proxy/PropertiesEncryptionSupport";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "store";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

