/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.extract;

import java.util.Map;
import java.util.function.Consumer;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TitledPane;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javax.inject.Inject;
import javax.inject.Named;
import org.pdfsam.context.UserContext;
import org.pdfsam.extract.ExtractOptionsPane;
import org.pdfsam.extract.ExtractParametersBuilder;
import org.pdfsam.extract.ExtractSelectionPane;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.ModuleCategory;
import org.pdfsam.module.ModuleDescriptor;
import org.pdfsam.module.ModuleDescriptorBuilder;
import org.pdfsam.module.ModuleInputOutputType;
import org.pdfsam.module.ModulePriority;
import org.pdfsam.support.params.AbstractPdfOutputParametersBuilder;
import org.pdfsam.support.params.MultipleOutputTaskParametersBuilder;
import org.pdfsam.ui.commons.ClearModuleEvent;
import org.pdfsam.ui.io.BrowsableField;
import org.pdfsam.ui.io.BrowsableOutputDirectoryField;
import org.pdfsam.ui.io.PdfDestinationPane;
import org.pdfsam.ui.module.BaseTaskExecutionModule;
import org.pdfsam.ui.module.Footer;
import org.pdfsam.ui.module.OpenButton;
import org.pdfsam.ui.module.RunButton;
import org.pdfsam.ui.prefix.PrefixPane;
import org.pdfsam.ui.support.Views;
import org.sejda.eventstudio.annotation.EventListener;
import org.sejda.eventstudio.annotation.EventStation;
import org.sejda.injector.Auto;
import org.sejda.injector.Components;
import org.sejda.injector.Provides;
import org.sejda.model.prefix.Prefix;

@Auto
public class ExtractModule
extends BaseTaskExecutionModule {
    private static final String MODULE_ID = "extract";
    private ExtractSelectionPane selectionPane = new ExtractSelectionPane("extract");
    private ExtractOptionsPane extractOptions = new ExtractOptionsPane();
    private BrowsableOutputDirectoryField destinationDirectoryField;
    private PdfDestinationPane destinationPane;
    private PrefixPane prefix = new PrefixPane();
    private ModuleDescriptor descriptor = ModuleDescriptorBuilder.builder().category(ModuleCategory.SPLIT).inputTypes(new ModuleInputOutputType[]{ModuleInputOutputType.MULTIPLE_PDF, ModuleInputOutputType.SINGLE_PDF}).name(DefaultI18nContext.getInstance().i18n("Extract")).description(DefaultI18nContext.getInstance().i18n("Extract pages from PDF documents.")).priority(ModulePriority.DEFAULT.getPriority()).supportURL("http://www.pdfsam.org/pdf-extract-pages").build();

    @Inject
    public ExtractModule(@Named(value="extractfield") BrowsableOutputDirectoryField destinationDirectoryField, @Named(value="extractpane") PdfDestinationPane destinationPane, @Named(value="extractfooter") Footer footer) {
        super(footer);
        this.destinationDirectoryField = destinationDirectoryField;
        this.destinationPane = destinationPane;
        this.initModuleSettingsPanel(this.settingPanel());
    }

    public ModuleDescriptor descriptor() {
        return this.descriptor;
    }

    protected ExtractParametersBuilder getBuilder(Consumer<String> onError) {
        ExtractParametersBuilder builder = new ExtractParametersBuilder();
        this.extractOptions.apply(builder, onError);
        this.selectionPane.apply(builder, onError);
        this.destinationDirectoryField.apply((MultipleOutputTaskParametersBuilder)builder, onError);
        this.destinationPane.apply((AbstractPdfOutputParametersBuilder)builder, onError);
        this.prefix.apply((MultipleOutputTaskParametersBuilder)builder, onError);
        return builder;
    }

    public void onSaveWorkspace(Map<String, String> data) {
        this.selectionPane.saveStateTo(data);
        this.extractOptions.saveStateTo(data);
        this.destinationPane.saveStateTo(data);
        this.destinationDirectoryField.saveStateTo(data);
        this.prefix.saveStateTo(data);
    }

    public void onLoadWorkspace(Map<String, String> data) {
        if (data.containsKey("input")) {
            data.put("input.0", data.get("input"));
            data.put("input.password.0", data.get("input.password"));
            data.put("input.size", "1");
        }
        this.selectionPane.restoreStateFrom(data);
        this.extractOptions.restoreStateFrom(data);
        this.destinationPane.restoreStateFrom(data);
        this.destinationDirectoryField.restoreStateFrom(data);
        this.prefix.restoreStateFrom(data);
    }

    private VBox settingPanel() {
        VBox pane = new VBox();
        pane.setAlignment(Pos.TOP_CENTER);
        VBox.setVgrow((Node)this.selectionPane, (Priority)Priority.ALWAYS);
        TitledPane prefixTitled = Views.titledPane((String)DefaultI18nContext.getInstance().i18n("File names settings"), (Node)this.prefix);
        this.prefix.addMenuItemFor(new Prefix[]{Prefix.FILENUMBER});
        pane.getChildren().addAll((Object[])new Node[]{this.selectionPane, Views.titledPane((String)DefaultI18nContext.getInstance().i18n("Extract settings"), (Node)this.extractOptions), Views.titledPane((String)DefaultI18nContext.getInstance().i18n("Output settings"), (Node)this.destinationPane), prefixTitled});
        return pane;
    }

    @EventStation
    public String id() {
        return MODULE_ID;
    }

    @EventListener
    public void onClearModule(ClearModuleEvent e) {
        if (e.clearEverything) {
            this.extractOptions.resetView();
            this.prefix.resetView();
            this.destinationPane.resetView();
        }
    }

    public Node graphic() {
        return new ImageView("extract.png");
    }

    @Components(value={ExtractModule.class})
    public static class ModuleConfig {
        @Provides
        @Named(value="extractfield")
        public BrowsableOutputDirectoryField destinationDirectoryField() {
            return new BrowsableOutputDirectoryField();
        }

        @Provides
        @Named(value="extractpane")
        public PdfDestinationPane destinationPane(@Named(value="extractfield") BrowsableOutputDirectoryField outputField, UserContext userContext) {
            return new PdfDestinationPane((BrowsableField)outputField, ExtractModule.MODULE_ID, userContext, new PdfDestinationPane.DestinationPanelFields[]{PdfDestinationPane.DestinationPanelFields.DISCARD_BOOKMARKS});
        }

        @Provides
        @Named(value="extractfooter")
        public Footer footer(RunButton runButton, @Named(value="extractopenButton") OpenButton openButton) {
            return new Footer(runButton, openButton, ExtractModule.MODULE_ID);
        }

        @Provides
        @Named(value="extractopenButton")
        public OpenButton openButton() {
            return new OpenButton(ExtractModule.MODULE_ID, ModuleInputOutputType.MULTIPLE_PDF);
        }
    }
}

