/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.io;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.input.DragEvent;
import javafx.scene.input.TransferMode;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.support.io.FileType;
import org.pdfsam.support.validation.Validator;
import org.pdfsam.support.validation.Validators;
import org.pdfsam.ui.io.BrowsableField;
import org.pdfsam.ui.io.FileChoosers;
import org.pdfsam.ui.io.RememberingLatestFileChooserWrapper;

public class BrowsableFileField
extends BrowsableField {
    private final FileType fileType;
    private final RememberingLatestFileChooserWrapper.OpenType openType;
    private BrowseEventHandler handler = new BrowseEventHandler();

    public BrowsableFileField(FileType fileType, RememberingLatestFileChooserWrapper.OpenType openType) {
        this.setBrowseWindowTitle(DefaultI18nContext.getInstance().i18n("Select a file"));
        this.getBrowseButton().setOnAction((EventHandler)this.handler);
        this.getTextField().setOnAction(this.handler);
        this.fileType = (FileType)ObjectUtils.defaultIfNull((Object)fileType, (Object)FileType.ALL);
        this.openType = (RememberingLatestFileChooserWrapper.OpenType)((Object)ObjectUtils.defaultIfNull((Object)((Object)openType), (Object)((Object)RememberingLatestFileChooserWrapper.OpenType.OPEN)));
        if (FileType.ALL != fileType) {
            this.getTextField().setPromptText(String.format("%s: %s", DefaultI18nContext.getInstance().i18n("Select a file"), fileType.getFilter().getExtensions()));
        } else {
            this.getTextField().setPromptText(DefaultI18nContext.getInstance().i18n("Select a file"));
        }
        this.setOnDragOver(e -> this.dragConsume((DragEvent)e, this.onDragOverConsumer()));
        this.setOnDragDropped(e -> this.dragConsume((DragEvent)e, this.onDragDropped()));
    }

    public void enforceValidation(boolean selectedFileMustExists, boolean allowEmptyString) {
        Validator validator = Validators.fileType((FileType)this.fileType, (boolean)selectedFileMustExists);
        if (allowEmptyString) {
            validator = Validators.validEmpty((Validator)validator);
        }
        this.getTextField().setValidator((Validator<String>)validator);
        this.getTextField().setErrorMessage(this.buildErrorMessage(selectedFileMustExists));
    }

    private String buildErrorMessage(boolean selectedFileMustExists) {
        Object errorMessage;
        Object object = errorMessage = selectedFileMustExists ? DefaultI18nContext.getInstance().i18n("The selected file must exist. ") : "";
        if (FileType.ALL != this.fileType) {
            errorMessage = (String)errorMessage + DefaultI18nContext.getInstance().i18n("Allowed extensions are {0}", this.fileType.getFilter().getExtensions().toString());
        }
        return StringUtils.trim((String)errorMessage);
    }

    @Override
    public void setTextFromFile(File inputFile) {
        if (inputFile != null) {
            this.getTextField().setText(inputFile.getAbsolutePath());
            this.getTextField().validate();
        }
    }

    private void dragConsume(DragEvent e, Consumer<DragEvent> c) {
        if (e.getDragboard().hasFiles()) {
            c.accept(e);
        }
        e.consume();
    }

    private Consumer<DragEvent> onDragOverConsumer() {
        return e -> e.acceptTransferModes(TransferMode.COPY_OR_MOVE);
    }

    private Consumer<DragEvent> onDragDropped() {
        return e -> {
            e.getDragboard().getFiles().stream().filter(f -> this.fileType.matches(f.getName())).findFirst().ifPresent(file -> this.setTextFromFile((File)file));
            e.setDropCompleted(true);
        };
    }

    private class BrowseEventHandler
    implements EventHandler<ActionEvent> {
        private BrowseEventHandler() {
        }

        public void handle(ActionEvent event) {
            Path path;
            RememberingLatestFileChooserWrapper fileChooser = FileChoosers.getFileChooser(BrowsableFileField.this.fileType, BrowsableFileField.this.getBrowseWindowTitle());
            String currentSelection = BrowsableFileField.this.getTextField().getText();
            if (StringUtils.isNotBlank((CharSequence)currentSelection) && Files.exists(path = Paths.get(currentSelection, new String[0]), new LinkOption[0])) {
                fileChooser.setInitialDirectory(path.getParent().toFile());
                fileChooser.setInitialFileName(path.getFileName().toString());
            }
            BrowsableFileField.this.setTextFromFile(fileChooser.showDialog(BrowsableFileField.this.getTextField().getScene().getWindow(), BrowsableFileField.this.openType));
        }
    }
}

