/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.commons;

import java.io.File;
import org.pdfsam.support.RequireUtils;

public class SetDestinationRequest {
    private File footprint;
    private boolean fallback = false;

    private SetDestinationRequest(File footprint, boolean fallback) {
        this.footprint = footprint;
        this.fallback = fallback;
    }

    public File getFootprint() {
        return this.footprint;
    }

    public boolean isFallback() {
        return this.fallback;
    }

    public static SetDestinationRequest requestDestination(File footprint, String module) {
        RequireUtils.requireNotNull((Object)footprint, (String)"Footprint file cannot be null");
        return new SetDestinationRequest(new File(footprint.getParent(), String.format("PDFsam_%s.pdf", module)), false);
    }

    public static SetDestinationRequest requestFallbackDestination(File footprint, String module) {
        RequireUtils.requireNotNull((Object)footprint, (String)"Footprint file cannot be null");
        return new SetDestinationRequest(new File(footprint.getParent(), String.format("PDFsam_%s.pdf", module)), true);
    }
}

