/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.dashboard.preference;

import org.pdfsam.context.IntUserPreference;
import org.pdfsam.context.UserContext;
import org.pdfsam.support.validation.Validator;
import org.pdfsam.ui.commons.ValidableTextField;
import org.pdfsam.ui.support.FXValidationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PreferenceIntTextField
extends ValidableTextField {
    private static final Logger LOG = LoggerFactory.getLogger(PreferenceIntTextField.class);

    PreferenceIntTextField(IntUserPreference preference, UserContext userContext, Validator<String> validator) {
        this.setValidator(validator);
        this.setEnableInvalidStyle(true);
        this.setOnEnterValidation(true);
        this.validProperty().addListener((o, oldVal, newVal) -> {
            if (newVal == FXValidationSupport.ValidationState.VALID) {
                userContext.setIntegerPreference(preference, Integer.parseInt(this.getText()));
                LOG.trace("Preference {} set to {}", (Object)preference, (Object)this.getText());
            }
        });
    }
}

