/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.spi;

import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.lsp.client.LanguageServerProviderAccessor;
import org.openide.util.Lookup;

public interface LanguageServerProvider {
    @CheckForNull
    public LanguageServerDescription startServer(@NonNull Lookup var1);

    public static final class LanguageServerDescription {
        private final InputStream in;
        private final OutputStream out;
        private final Process process;

        @NonNull
        public static LanguageServerDescription create(@NonNull InputStream in, @NonNull OutputStream out, @NullAllowed Process process) {
            return new LanguageServerDescription(in, out, process);
        }

        private LanguageServerDescription(InputStream in, OutputStream out, Process process) {
            this.in = in;
            this.out = out;
            this.process = process;
        }

        static {
            LanguageServerProviderAccessor.setINSTANCE(new LanguageServerProviderAccessor(){

                @Override
                public InputStream getInputStream(LanguageServerDescription desc) {
                    return desc.in;
                }

                @Override
                public OutputStream getOutputStream(LanguageServerDescription desc) {
                    return desc.out;
                }

                @Override
                public Process getProcess(LanguageServerDescription desc) {
                    return desc.process;
                }
            });
        }
    }
}

