/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.eclipse.persistence.jpa.jpql.tools.spi.IType;
import org.eclipse.persistence.jpa.jpql.tools.spi.ITypeDeclaration;
import org.eclipse.persistence.jpa.jpql.tools.spi.ITypeRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeHelper {
    private IType objectType;
    private IType stringType;
    private final ITypeRepository typeRepository;
    private IType unknownType;

    public TypeHelper(ITypeRepository typeRepository) {
        this.typeRepository = typeRepository;
    }

    public IType bigDecimal() {
        return this.getType(BigDecimal.class);
    }

    public IType bigInteger() {
        return this.getType(BigInteger.class);
    }

    public IType booleanType() {
        return this.getType(Boolean.class);
    }

    public IType byteType() {
        return this.getType(Byte.class);
    }

    public IType characterType() {
        return this.getType(Character.class);
    }

    public IType collectionType() {
        return this.getType(Collection.class);
    }

    public IType convertPrimitive(IType type) {
        IType newType = this.toByteType(type);
        if (newType != type) {
            return newType;
        }
        newType = this.toShortType(type);
        if (newType != type) {
            return newType;
        }
        newType = this.toIntegerType(type);
        if (newType != type) {
            return newType;
        }
        newType = this.longType(type);
        if (newType != type) {
            return newType;
        }
        newType = this.toFloatType(type);
        if (newType != type) {
            return newType;
        }
        newType = this.toDoubleType(type);
        if (newType != type) {
            return newType;
        }
        newType = this.toBooleanType(type);
        if (newType != type) {
            return newType;
        }
        return type;
    }

    public IType dateType() {
        return this.getType(Date.class);
    }

    public IType doubleType() {
        return this.getType(Double.class);
    }

    public IType enumType() {
        return this.getType(Enum.class);
    }

    public IType floatType() {
        return this.getType(Float.class);
    }

    public IType getType(Class<?> type) {
        return this.typeRepository.getType(type);
    }

    public IType getType(String typeName) {
        return this.typeRepository.getType(typeName);
    }

    public ITypeRepository getTypeRepository() {
        return this.typeRepository;
    }

    public IType integerType() {
        return this.getType(Integer.class);
    }

    public boolean isBooleanType(IType type) {
        return type.equals(this.booleanType());
    }

    public boolean isCollectionType(IType type) {
        return type.isAssignableTo(this.collectionType());
    }

    public boolean isDateType(IType type) {
        return type.equals(this.dateType()) || type.equals(this.timestampType()) || type.equals(this.getType(Calendar.class));
    }

    public boolean isEnumType(IType type) {
        return type.isAssignableTo(this.enumType());
    }

    public boolean isFloatingType(IType type) {
        return type.equals(this.floatType()) || type.equals(this.doubleType()) || type.equals(this.primitiveFloat()) || type.equals(this.primitiveDouble());
    }

    public boolean isIntegralType(IType type) {
        return type.equals(this.integerType()) || type.equals(this.longType()) || type.equals(this.shortType()) || type.equals(this.characterType()) || type.equals(this.primitiveInteger()) || type.equals(this.primitiveLong()) || type.equals(this.primitiveShort()) || type.equals(this.primitiveChar());
    }

    public boolean isMapType(IType type) {
        return type.isAssignableTo(this.mapType());
    }

    public boolean isNumericType(IType type) {
        return type.isAssignableTo(this.numberType());
    }

    public boolean isObjectType(IType type) {
        return type.equals(this.objectType());
    }

    public boolean isPrimitiveType(IType type) {
        return type == this.primitiveBoolean() || type == this.primitiveByte() || type == this.primitiveDouble() || type == this.primitiveFloat() || type == this.primitiveInteger() || type == this.primitiveLong() || type == this.primitiveShort();
    }

    public boolean isStringType(IType type) {
        return type.equals(this.stringType());
    }

    public IType longType() {
        return this.getType(Long.class);
    }

    public IType longType(IType type) {
        if (type.equals(this.primitiveLong())) {
            return this.longType();
        }
        return type;
    }

    public IType mapType() {
        return this.getType(Map.class);
    }

    public IType numberType() {
        return this.getType(Number.class);
    }

    public IType objectType() {
        if (this.objectType == null) {
            this.objectType = this.getType(Object.class);
        }
        return this.objectType;
    }

    public ITypeDeclaration objectTypeDeclaration() {
        return this.objectType().getTypeDeclaration();
    }

    public IType primitiveBoolean() {
        return this.getType(Boolean.TYPE);
    }

    public IType primitiveByte() {
        return this.getType(Byte.TYPE);
    }

    public IType primitiveChar() {
        return this.getType(Character.TYPE);
    }

    public IType primitiveDouble() {
        return this.getType(Double.TYPE);
    }

    public IType primitiveFloat() {
        return this.getType(Float.TYPE);
    }

    public IType primitiveInteger() {
        return this.getType(Integer.TYPE);
    }

    public IType primitiveLong() {
        return this.getType(Long.TYPE);
    }

    public IType primitiveShort() {
        return this.getType(Short.TYPE);
    }

    public IType shortType() {
        return this.getType(Short.class);
    }

    public IType stringType() {
        if (this.stringType == null) {
            this.stringType = this.getType(String.class);
        }
        return this.stringType;
    }

    public IType timestampType() {
        return this.getType(Timestamp.class);
    }

    public IType toBooleanType(IType type) {
        if (type.equals(this.primitiveBoolean())) {
            return this.booleanType();
        }
        return type;
    }

    public IType toByteType(IType type) {
        if (type.equals(this.primitiveByte())) {
            return this.byteType();
        }
        return type;
    }

    public IType toDoubleType(IType type) {
        if (type.equals(this.primitiveDouble())) {
            return this.doubleType();
        }
        return type;
    }

    public IType toFloatType(IType type) {
        if (type.equals(this.primitiveFloat())) {
            return this.floatType();
        }
        return type;
    }

    public IType toIntegerType(IType type) {
        if (type.equals(this.primitiveInteger())) {
            return this.integerType();
        }
        return type;
    }

    public IType toShortType(IType type) {
        if (type.equals(this.primitiveShort())) {
            return this.shortType();
        }
        return type;
    }

    public IType unknownType() {
        if (this.unknownType == null) {
            this.unknownType = this.getType("UNRESOLVABLE_TYPE");
        }
        return this.unknownType;
    }

    public ITypeDeclaration unknownTypeDeclaration() {
        return this.unknownType().getTypeDeclaration();
    }
}

