/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.diff;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JList;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.modules.git.ui.diff.Bundle;
import org.netbeans.modules.git.ui.diff.DiffToRevisionKind;
import org.netbeans.modules.git.ui.diff.DiffToRevisionPanel;
import org.netbeans.modules.git.ui.repository.Revision;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;

class DiffToRevision
implements ActionListener,
PropertyChangeListener {
    private final DiffToRevisionPanel panel;
    private final JButton okButton;
    private final JButton cancelButton;
    private final File repository;
    private final DiffToRevisionKind[] kinds;
    static final String PROP_VALID = "diffto.propValid";

    public DiffToRevision(File repository, GitBranch currentBranch) {
        this.repository = repository;
        Revision.BranchReference baseRevision = new Revision.BranchReference(currentBranch);
        this.kinds = new DiffToRevisionKind[]{new DiffToRevisionKind.LocalToBaseKind(), new DiffToRevisionKind.LocalToRevisionKind(repository, baseRevision), new DiffToRevisionKind.BaseToRevisionKind(repository, baseRevision)};
        this.panel = new DiffToRevisionPanel();
        this.okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)Bundle.CTL_DiffToRevision_okButton_text());
        this.okButton.getAccessibleContext().setAccessibleDescription(Bundle.CTL_DiffToRevision_okButton_ACSD());
        this.cancelButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)Bundle.CTL_DiffToRevision_cancelButton_text());
        this.cancelButton.getAccessibleContext().setAccessibleDescription(Bundle.CTL_DiffToRevision_cancelButton_ACSD());
        this.okButton.setEnabled(false);
        this.attachListeners();
        this.initializeCombo();
    }

    public boolean showDialog() {
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.panel, Bundle.CTL_DiffToRevision_ACSD());
        dialogDescriptor.setOptions(new Object[]{this.okButton, this.cancelButton});
        dialogDescriptor.setModal(true);
        dialogDescriptor.setHelpCtx(new HelpCtx("org.netbeans.modules.git.ui.diff.DiffToRevisionPanel"));
        dialogDescriptor.setValid(false);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(Bundle.CTL_DiffToRevision_ACSD());
        dialog.setVisible(true);
        dialog.setResizable(false);
        boolean ret = dialogDescriptor.getValue() == this.okButton;
        return ret;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.panel.cmbDiffKind) {
            DiffToRevisionKind rebaseKind = (DiffToRevisionKind)this.panel.cmbDiffKind.getSelectedItem();
            this.panel.lblDescription.setText(rebaseKind.getDescription());
            ((CardLayout)this.panel.panelDiffKind.getLayout()).show(this.panel.panelDiffKind, rebaseKind.getId());
            this.okButton.setEnabled(rebaseKind.isValid());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.okButton != null && evt.getSource() == this.panel.cmbDiffKind.getSelectedItem() && PROP_VALID.equals(evt.getPropertyName())) {
            boolean valid = (Boolean)evt.getNewValue();
            this.okButton.setEnabled(valid);
        }
    }

    public Revision getSelectedTreeFirst() {
        return this.getSelectedKind().getTreeFirst();
    }

    public Revision getSelectedTreeSecond() {
        return this.getSelectedKind().getTreeSecond();
    }

    private void attachListeners() {
        this.panel.cmbDiffKind.addActionListener(this);
    }

    private void initializeCombo() {
        DefaultComboBoxModel<DiffToRevisionKind> model = new DefaultComboBoxModel<DiffToRevisionKind>(this.kinds);
        for (DiffToRevisionKind kind : this.kinds) {
            this.panel.panelDiffKind.add((Component)kind.getPanel(), kind.getId());
            kind.addPropertyChangeListener(this);
        }
        this.panel.cmbDiffKind.setModel(model);
        this.panel.cmbDiffKind.setRenderer(new DiffKindRenderer());
        this.panel.cmbDiffKind.setSelectedIndex(1);
    }

    private DiffToRevisionKind getSelectedKind() {
        return (DiffToRevisionKind)this.panel.cmbDiffKind.getSelectedItem();
    }

    private static class DiffKindRenderer
    extends DefaultListCellRenderer {
        private DiffKindRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof DiffToRevisionKind) {
                value = ((DiffToRevisionKind)value).getDisplayName();
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

