/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.api;

import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.html.editor.lib.api.SyntaxAnalyzerResult;
import org.netbeans.modules.web.common.api.WebPageMetadata;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class Utils {
    public static TokenSequence<HTMLTokenId> getJoinedHtmlSequence(Document doc, int offset) {
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        return Utils.getJoinedHtmlSequence(th, offset);
    }

    public static TokenSequence<HTMLTokenId> getJoinedHtmlSequence(TokenHierarchy th, int offset) {
        TokenSequence ts = th.tokenSequence();
        if (ts == null) {
            return null;
        }
        ts.move(offset);
        while (ts.moveNext() || ts.movePrevious()) {
            if (ts.language() == HTMLTokenId.language()) {
                return ts;
            }
            if ((ts = ts.embeddedJoined()) == null) break;
            ts.move(offset);
        }
        return null;
    }

    public static Token<HTMLTokenId> findTagOpenToken(TokenSequence ts) {
        TokenId id;
        assert (ts != null);
        if (ts.token().id() == HTMLTokenId.TAG_CLOSE_SYMBOL && !ts.movePrevious()) {
            return null;
        }
        do {
            Token t;
            if ((id = (t = ts.token()).id()) != HTMLTokenId.TAG_OPEN) continue;
            return t;
        } while (id != HTMLTokenId.TAG_OPEN_SYMBOL && id != HTMLTokenId.TAG_CLOSE_SYMBOL && id != HTMLTokenId.TEXT && ts.movePrevious());
        return null;
    }

    public static String getWebPageMimeType(SyntaxAnalyzerResult result) {
        String mimeType;
        InstanceContent ic = new InstanceContent();
        ic.add((Object)result);
        WebPageMetadata wpmeta = WebPageMetadata.getMetadata((Lookup)new AbstractLookup((AbstractLookup.Content)ic));
        if (wpmeta != null && (mimeType = (String)wpmeta.value("mimeType")) != null) {
            return mimeType;
        }
        FileObject fo = result.getSource().getSourceFileObject();
        if (fo != null) {
            return fo.getMIMEType();
        }
        return result.getSource().getSnapshot().getMimeType();
    }
}

