/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.infra.build.ant;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.netbeans.installer.infra.build.ant.utils.Utils;

public class ProductDescriptor
extends Task {
    private File file;

    public void setFile(String path) {
        this.file = new File(path);
        if (!this.file.equals(this.file.getAbsoluteFile())) {
            this.file = new File(this.getProject().getBaseDir(), path);
        }
    }

    public void execute() throws BuildException {
        int i;
        String name;
        Utils.setProject(this.getProject());
        StringBuilder xml = new StringBuilder();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        xml.append("<registry xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"registry.xsd\">\n");
        xml.append("    <components>\n");
        String uid = this.get("product.uid");
        String version = this.get("product.version");
        String platform = this.get("product.platforms");
        String status = this.get("product.status");
        String offset = this.get("product.offset");
        String expand = this.get("product.expand");
        String visible = this.get("product.visible");
        String features = this.get("product.features");
        xml.append("        <product uid=\"" + uid + "\" version=\"" + version + "\" platforms=\"" + platform + "\" status=\"" + status + "\" offset=\"" + offset + "\" expand=\"" + expand + "\" built=\"" + new Date().getTime() + "\" visible=\"" + visible + "\" features=\"" + features + "\">\n");
        String locales = this.get("product.locales.list").trim();
        xml.append("            <display-name>\n");
        xml.append("                <default><![CDATA[" + Utils.toAscii(this.get("product.display.name.default")) + "]]></default>\n");
        if (!locales.equals("")) {
            for (String locale : locales.split(" ")) {
                name = this.get("product.display.name." + locale);
                if (name == null) continue;
                xml.append("                <localized locale=\"" + locale + "\"><![CDATA[" + Utils.toAscii(name) + "]]></localized>\n");
            }
        }
        xml.append("            </display-name>\n");
        xml.append("            <description>\n");
        xml.append("                <default><![CDATA[" + this.get("product.description.default") + "]]></default>\n");
        if (!locales.equals("")) {
            for (String locale : locales.split(" ")) {
                String desc = this.get("product.description." + locale);
                if (desc == null) continue;
                xml.append("                <localized locale=\"" + locale + "\"><![CDATA[" + Utils.toAscii(desc) + "]]></localized>\n");
            }
        }
        xml.append("            </description>\n");
        String size = this.get("product.icon.size");
        String md5 = this.get("product.icon.md5");
        String uri = this.get("product.icon.correct.uri");
        xml.append("            <icon size=\"" + size + "\" md5=\"" + md5 + "\">\n");
        xml.append("                <default-uri>" + uri.replace(" ", "%20") + "</default-uri>\n");
        xml.append("            </icon>\n");
        if (this.getInt("product.properties.length") > 0) {
            xml.append("            <properties>\n");
            for (int i2 = 1; i2 <= this.getInt("product.properties.length"); ++i2) {
                name = this.get("product.properties." + i2 + ".name");
                String value = this.get("product.properties." + i2 + ".value");
                xml.append("                <property name=\"" + name + "\"><![CDATA[" + value + "]]></property>\n");
            }
            xml.append("            </properties>\n");
        }
        xml.append("            <configuration-logic>\n");
        for (i = 1; i <= this.getInt("product.logic.length"); ++i) {
            size = this.get("product.logic." + i + ".size");
            md5 = this.get("product.logic." + i + ".md5");
            uri = this.get("product.logic." + i + ".correct.uri");
            xml.append("                <file size=\"" + size + "\" md5=\"" + md5 + "\">\n");
            xml.append("                    <default-uri>" + uri.replace(" ", "%20") + "</default-uri>\n");
            xml.append("                </file>\n");
        }
        xml.append("            </configuration-logic>\n");
        xml.append("            <installation-data>\n");
        for (i = 1; i <= this.getInt("product.data.length"); ++i) {
            size = this.get("product.data." + i + ".size");
            md5 = this.get("product.data." + i + ".md5");
            uri = this.get("product.data." + i + ".correct.uri");
            xml.append("                <file size=\"" + size + "\" md5=\"" + md5 + "\">\n");
            xml.append("                    <default-uri>" + uri.replace(" ", "%20") + "</default-uri>\n");
            xml.append("                </file>\n");
        }
        xml.append("            </installation-data>\n");
        xml.append("            <system-requirements>\n");
        xml.append("                <disk-space>" + this.get("product.disk.space") + "</disk-space>\n");
        xml.append("            </system-requirements>\n");
        if (this.getInt("product.requirements.length") + this.getInt("product.conflicts.length") + this.getInt("product.install-afters.length") > 0) {
            String upper;
            String lower;
            xml.append("            <dependencies>\n");
            for (i = 1; i <= this.getInt("product.requirements.length"); ++i) {
                uid = this.get("product.requirements." + i + ".uid");
                lower = this.get("product.requirements." + i + ".version-lower");
                upper = this.get("product.requirements." + i + ".version-upper");
                int alternativeRequirements = this.getInt("product.requirements." + i + ".alternatives.length");
                if (alternativeRequirements == 0) {
                    xml.append("                <requirement uid=\"" + uid + "\" version-lower=\"" + lower + "\" version-upper=\"" + upper + "\"/>\n");
                    continue;
                }
                xml.append("                <requirement uid=\"" + uid + "\" version-lower=\"" + lower + "\" version-upper=\"" + upper + "\">\n");
                for (int j = 1; j <= alternativeRequirements; ++j) {
                    int reqs = this.getInt("product.requirements." + i + ".alternatives." + j + ".requirements.length");
                    if (reqs <= 0) continue;
                    xml.append("                    <or>\n");
                    for (int k = 1; k <= reqs; ++k) {
                        String prefix = "product.requirements." + i + ".alternatives." + j + ".requirements." + k + ".";
                        uid = this.get(prefix + "uid");
                        lower = this.get(prefix + "version-lower");
                        upper = this.get(prefix + "version-upper");
                        xml.append("                        <requirement uid=\"" + uid + "\" version-lower=\"" + lower + "\" version-upper=\"" + upper + "\"/>\n");
                    }
                    xml.append("                    </or>\n");
                }
                xml.append("                </requirement>\n");
            }
            for (i = 1; i <= this.getInt("product.conflicts.length"); ++i) {
                uid = this.get("product.conflicts." + i + ".uid");
                lower = this.get("product.conflicts." + i + ".version-lower");
                upper = this.get("product.conflicts." + i + ".version-upper");
                xml.append("                <conflict uid=\"" + uid + "\" version-lower=\"" + lower + "\" version-upper=\"" + upper + "\"/>\n");
            }
            for (i = 1; i <= this.getInt("product.install-afters.length"); ++i) {
                uid = this.get("product.install-afters." + i + ".uid");
                xml.append("                <install-after uid=\"" + uid + "\"/>\n");
            }
            xml.append("            </dependencies>\n");
        }
        xml.append("        </product>\n");
        xml.append("    </components>\n");
        xml.append("</registry>\n");
        try {
            Utils.write(this.file, xml);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private String get(String name) {
        return Utils.resolveProperty(this.getProject().getProperty(name));
    }

    private int getInt(String name) {
        if (this.get(name) == null) {
            return 0;
        }
        return Integer.parseInt(this.get(name));
    }
}

