/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.ErrorAwareTreeScanner;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.CreateElementUtilities;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.api.ChangeParametersRefactoring;
import org.netbeans.modules.refactoring.java.api.IntroduceParameterRefactoring;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.plugins.ChangeParametersPlugin;
import org.netbeans.modules.refactoring.java.plugins.ChangeParamsTransformer;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.java.spi.ToPhaseException;
import org.netbeans.modules.refactoring.java.ui.ChangeParametersPanel;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class IntroduceParameterPlugin
extends JavaRefactoringPlugin {
    private static final EnumSet<ElementKind> VARIABLES = EnumSet.of(ElementKind.FIELD, new ElementKind[]{ElementKind.ENUM_CONSTANT, ElementKind.LOCAL_VARIABLE, ElementKind.PARAMETER, ElementKind.TYPE_PARAMETER, ElementKind.RESOURCE_VARIABLE});
    private IntroduceParameterRefactoring refactoring;
    private TreePathHandle treePathHandle;
    private Set<ElementHandle<ExecutableElement>> allMethods;
    private ChangeParametersRefactoring.ParameterInfo[] paramTable;
    private int index;
    private TreePathHandle methodHandle;

    public IntroduceParameterPlugin(IntroduceParameterRefactoring refactoring) {
        this.refactoring = refactoring;
        this.treePathHandle = (TreePathHandle)refactoring.getRefactoringSource().lookup(TreePathHandle.class);
    }

    @Override
    protected Problem checkParameters(CompilationController javac) throws IOException {
        javac.toPhase(JavaSource.Phase.RESOLVED);
        Problem p = null;
        return p;
    }

    @Override
    protected Problem fastCheckParameters(CompilationController javac) throws IOException {
        javac.toPhase(JavaSource.Phase.RESOLVED);
        Problem p = this.initDelegate(javac);
        TreePath resolved = this.treePathHandle.resolve((CompilationInfo)javac);
        final Element variableElement = javac.getTrees().getElement(resolved);
        ChangeParametersPlugin.Checks check = new ChangeParametersPlugin.Checks(javac){

            @Override
            Problem duplicateLocalName(Problem p, ChangeParametersRefactoring.ParameterInfo[] paramTable, int index, ExecutableElement method) throws MissingResourceException {
                String name = paramTable[index].getName();
                int originalIndex = paramTable[index].getOriginalIndex();
                final VariableElement parameterElement = originalIndex == -1 ? null : method.getParameters().get(originalIndex);
                ErrorAwareTreeScanner<Boolean, String> scanner = new ErrorAwareTreeScanner<Boolean, String>(){

                    public Boolean visitVariable(VariableTree vt, String p) {
                        super.visitVariable(vt, (Object)p);
                        TreePath path = javac.getTrees().getPath(javac.getCompilationUnit(), vt);
                        Element element = javac.getTrees().getElement(path);
                        boolean sameName = element != null && vt.getName().contentEquals(p) && !element.equals(parameterElement);
                        return sameName && element != variableElement;
                    }

                    public Boolean visitIdentifier(IdentifierTree it, String p) {
                        super.visitIdentifier(it, (Object)p);
                        TreePath path = javac.getTrees().getPath(javac.getCompilationUnit(), it);
                        Element element = javac.getTrees().getElement(path);
                        boolean sameName = element != null && VARIABLES.contains((Object)element.getKind()) && it.getName().contentEquals(p) && !element.equals(parameterElement);
                        return sameName && element != variableElement;
                    }

                    public Boolean reduce(Boolean left, Boolean right) {
                        return left != null && left != false || right != null && right != false;
                    }
                };
                if (((Boolean)scanner.scan((Tree)this.javac.getTrees().getTree(method), (Object)name)).booleanValue() && !this.isParameterBeingRemoved(method, name, paramTable)) {
                    p = IntroduceParameterPlugin.createProblem(p, true, NbBundle.getMessage(ChangeParametersPlugin.class, (String)"ERR_NameAlreadyUsed", (Object)name));
                }
                return p;
            }
        };
        TreePath methodPath = JavaPluginUtils.findMethod(resolved);
        if (methodPath == null) {
            return p;
        }
        ExecutableElement method = (ExecutableElement)javac.getTrees().getElement(methodPath);
        if (method == null) {
            return p;
        }
        boolean isConstructor = method.getKind() == ElementKind.CONSTRUCTOR;
        TypeElement enclosingTypeElement = javac.getElementUtilities().enclosingTypeElement((Element)method);
        List<? extends Element> allMembers = javac.getElements().getAllMembers(enclosingTypeElement);
        p = !isConstructor ? check.duplicateSignature(p, this.paramTable, method, enclosingTypeElement, allMembers) : check.duplicateConstructor(p, this.paramTable, method, enclosingTypeElement, allMembers);
        for (int i = 0; i < this.paramTable.length; ++i) {
            ChangeParametersRefactoring.ParameterInfo parameterInfo = this.paramTable[i];
            p = check.checkParameterName(p, parameterInfo.getName());
            if (parameterInfo.getOriginalIndex() == -1) {
                p = check.defaultValue(p, parameterInfo.getDefaultValue());
            }
            p = check.duplicateParamName(p, this.paramTable, i);
            p = check.duplicateLocalName(p, this.paramTable, i, method);
            p = check.parameterType(p, this.paramTable, i, method, enclosingTypeElement);
        }
        return p;
    }

    private Set<FileObject> getRelevantFiles() {
        ClasspathInfo cpInfo = this.getClasspathInfo(this.refactoring);
        final HashSet<FileObject> set = new HashSet<FileObject>();
        JavaSource source = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{((TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class)).getFileObject()});
        try {
            source.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public void run(CompilationController info) throws Exception {
                    ElementHandle encl;
                    ElementHandle handle;
                    ClassIndex idx = info.getClasspathInfo().getClassIndex();
                    info.toPhase(JavaSource.Phase.RESOLVED);
                    ElementUtilities elmUtils = info.getElementUtilities();
                    ExecutableElement el = IntroduceParameterPlugin.this.getMethodElement(IntroduceParameterPlugin.this.treePathHandle, (CompilationInfo)info);
                    ElementHandle methodHandle = ElementHandle.create((Element)el);
                    ElementHandle enclosingType = ElementHandle.create((Element)elmUtils.enclosingTypeElement((Element)el));
                    IntroduceParameterPlugin.this.allMethods = new HashSet();
                    IntroduceParameterPlugin.this.allMethods.add(methodHandle);
                    for (ExecutableElement e : JavaRefactoringUtils.getOverridingMethods(el, (CompilationInfo)info, IntroduceParameterPlugin.this.cancelRequested)) {
                        handle = ElementHandle.create((Element)e);
                        set.add(SourceUtils.getFile((ElementHandle)handle, (ClasspathInfo)info.getClasspathInfo()));
                        encl = ElementHandle.create((Element)elmUtils.enclosingTypeElement((Element)e));
                        set.addAll(idx.getResources(encl, EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                        IntroduceParameterPlugin.this.allMethods.add(ElementHandle.create((Element)e));
                    }
                    for (ExecutableElement e : JavaRefactoringUtils.getOverriddenMethods(el, (CompilationInfo)info)) {
                        handle = ElementHandle.create((Element)e);
                        set.add(SourceUtils.getFile((ElementHandle)handle, (ClasspathInfo)info.getClasspathInfo()));
                        encl = ElementHandle.create((Element)elmUtils.enclosingTypeElement((Element)e));
                        set.addAll(idx.getResources(encl, EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                        IntroduceParameterPlugin.this.allMethods.add(ElementHandle.create((Element)e));
                    }
                    set.addAll(idx.getResources(enclosingType, EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                    set.add(SourceUtils.getFile((ElementHandle)methodHandle, (ClasspathInfo)info.getClasspathInfo()));
                }
            }, true);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return set;
    }

    public Problem prepare(RefactoringElementsBag elements) {
        Set<FileObject> a = this.getRelevantFiles();
        this.initDelegate();
        ChangeParametersPanel.Javadoc javadoc = (ChangeParametersPanel.Javadoc)((Object)this.refactoring.getContext().lookup(ChangeParametersPanel.Javadoc.class));
        final ChangeParamsTransformer changeParamsTransformer = new ChangeParamsTransformer(this.paramTable, null, null, null, this.refactoring.isOverloadMethod(), javadoc == null ? ChangeParametersPanel.Javadoc.NONE : javadoc, this.allMethods, this.methodHandle, true);
        this.fireProgressListenerStart(3, a.size() * 2);
        Problem p = null;
        if (!a.isEmpty()) {
            CancellableTask<WorkingCopy> t = new CancellableTask<WorkingCopy>(){

                public void cancel() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(WorkingCopy workingCopy) throws Exception {
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    if (workingCopy.getFileObject().equals(IntroduceParameterPlugin.this.treePathHandle.getFileObject())) {
                        BlockTree sttmts;
                        boolean variableRewrite;
                        TreePath resolved = IntroduceParameterPlugin.this.treePathHandle.resolve((CompilationInfo)workingCopy);
                        TreePath meth = JavaPluginUtils.findMethod(resolved);
                        IntroduceParameterPlugin.this.methodHandle = TreePathHandle.create((TreePath)meth, (CompilationInfo)workingCopy);
                        TreeMaker make = workingCopy.getTreeMaker();
                        boolean expressionStatement = resolved.getParentPath().getLeaf().getKind() == Tree.Kind.EXPRESSION_STATEMENT;
                        boolean bl = variableRewrite = resolved.getLeaf().getKind() == Tree.Kind.VARIABLE;
                        if (IntroduceParameterPlugin.this.refactoring.isReplaceAll() || variableRewrite) {
                            Set candidates = IntroduceParameterPlugin.this.computeDuplicates(workingCopy, resolved, meth);
                            for (TreePath p : candidates) {
                                Tree leaf = p.getLeaf();
                                workingCopy.rewrite(leaf, (Tree)make.Identifier((CharSequence)IntroduceParameterPlugin.this.refactoring.getParameterName()));
                            }
                            sttmts = IntroduceParameterPlugin.findAddPosition((CompilationInfo)workingCopy, resolved, candidates);
                        } else {
                            sttmts = IntroduceParameterPlugin.findAddPosition((CompilationInfo)workingCopy, resolved, Collections.emptySet());
                        }
                        if (sttmts != null) {
                            LinkedList<? extends StatementTree> nueStatements2 = new LinkedList<StatementTree>(sttmts.getStatements());
                            if (expressionStatement) {
                                nueStatements2.remove(resolved.getParentPath().getLeaf());
                            }
                            if (variableRewrite) {
                                nueStatements2.remove(resolved.getLeaf());
                            }
                            BlockTree nueBlock2 = make.Block(nueStatements2, false);
                            workingCopy.rewrite((Tree)sttmts, (Tree)nueBlock2);
                        }
                        if (!variableRewrite) {
                            Tree origParent = resolved.getParentPath().getLeaf();
                            Tree leaf = resolved.getLeaf();
                            ExpressionTree identifier = make.Identifier((CharSequence)IntroduceParameterPlugin.this.refactoring.getParameterName());
                            if (leaf.getKind() == Tree.Kind.PARENTHESIZED) {
                                switch (origParent.getKind()) {
                                    case FOR_LOOP: 
                                    case ENHANCED_FOR_LOOP: 
                                    case WHILE_LOOP: 
                                    case DO_WHILE_LOOP: 
                                    case IF: {
                                        identifier = make.Parenthesized(identifier);
                                    }
                                }
                            }
                            Tree newParent = workingCopy.getTreeUtilities().translate(origParent, Collections.singletonMap(leaf, identifier));
                            workingCopy.rewrite(origParent, newParent);
                        }
                    }
                    try {
                        try {
                            changeParamsTransformer.setWorkingCopy(workingCopy);
                        }
                        catch (ToPhaseException e) {
                            IntroduceParameterPlugin.this.fireProgressListenerStep();
                            return;
                        }
                        CompilationUnitTree cu = workingCopy.getCompilationUnit();
                        if (cu == null) {
                            ErrorManager.getDefault().log(65536, "compiler.getCompilationUnit() is null " + workingCopy);
                            return;
                        }
                        Element el = null;
                        if (IntroduceParameterPlugin.this.methodHandle != null && (el = IntroduceParameterPlugin.this.methodHandle.resolveElement((CompilationInfo)workingCopy)) == null) {
                            ErrorManager.getDefault().log(16, "Cannot resolve " + IntroduceParameterPlugin.this.methodHandle + "in " + workingCopy.getFileObject().getPath());
                            return;
                        }
                        changeParamsTransformer.scan((Tree)workingCopy.getCompilationUnit(), el);
                    }
                    finally {
                        IntroduceParameterPlugin.this.fireProgressListenerStep();
                    }
                }
            };
            p = JavaPluginUtils.chainProblems(p, this.createAndAddElements(a, t, elements, this.refactoring));
        }
        this.fireProgressListenerStop();
        return p;
    }

    private Set<TreePath> computeDuplicates(WorkingCopy workingCopy, TreePath resolved, TreePath meth) {
        Set ret = SourceUtils.computeDuplicates((CompilationInfo)workingCopy, (TreePath)resolved, (TreePath)meth, (AtomicBoolean)new AtomicBoolean());
        return ret;
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase p) {
        switch (p) {
            case CHECKPARAMETERS: 
            case FASTCHECKPARAMETERS: 
            case PRECHECK: {
                ClasspathInfo cpInfo = this.getClasspathInfo(this.refactoring);
                return JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{this.treePathHandle.getFileObject()});
            }
        }
        return null;
    }

    @Override
    protected Problem preCheck(CompilationController info) throws IOException {
        this.fireProgressListenerStart(1, 4);
        Problem preCheckProblem = null;
        info.toPhase(JavaSource.Phase.RESOLVED);
        TreePath tp = this.treePathHandle.resolve((CompilationInfo)info);
        TreePath method = JavaPluginUtils.findMethod(tp);
        if (method == null) {
            preCheckProblem = IntroduceParameterPlugin.createProblem(preCheckProblem, true, NbBundle.getMessage(IntroduceParameterPlugin.class, (String)"ERR_ChangeParamsWrongType"));
            return preCheckProblem;
        }
        Element el = info.getTrees().getElement(method);
        if (!RefactoringUtils.isExecutableElement(el)) {
            preCheckProblem = IntroduceParameterPlugin.createProblem(preCheckProblem, true, NbBundle.getMessage(IntroduceParameterPlugin.class, (String)"ERR_ChangeParamsWrongType"));
            return preCheckProblem;
        }
        preCheckProblem = JavaPluginUtils.isSourceElement(el, (CompilationInfo)info);
        if (preCheckProblem != null) {
            return preCheckProblem;
        }
        if (info.getElementUtilities().enclosingTypeElement(el).getKind() == ElementKind.ANNOTATION_TYPE) {
            preCheckProblem = new Problem(true, NbBundle.getMessage(IntroduceParameterPlugin.class, (String)"ERR_MethodsInAnnotationsNotSupported"));
            return preCheckProblem;
        }
        for (ExecutableElement e : JavaRefactoringUtils.getOverriddenMethods((ExecutableElement)el, (CompilationInfo)info)) {
            ElementHandle handle = ElementHandle.create((Element)e);
            if (!RefactoringUtils.isFromLibrary((ElementHandle<? extends Element>)handle, info.getClasspathInfo())) continue;
            preCheckProblem = IntroduceParameterPlugin.createProblem(preCheckProblem, true, NbBundle.getMessage(IntroduceParameterPlugin.class, (String)"ERR_CannnotRefactorLibrary", (Object)el));
        }
        this.fireProgressListenerStop();
        return preCheckProblem;
    }

    private static BlockTree findAddPosition(CompilationInfo info, TreePath original, Set<? extends TreePath> candidates) {
        TreePath statement = original;
        for (TreePath treePath : candidates) {
            int stPathStart;
            Tree leaf = treePath.getLeaf();
            int leafStart = (int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), leaf);
            if (leafStart >= (stPathStart = (int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), statement.getLeaf()))) continue;
            statement = treePath;
        }
        LinkedList<? extends TreePath> allCandidates = new LinkedList<TreePath>();
        allCandidates.add(original);
        allCandidates.addAll(candidates);
        statement = JavaPluginUtils.findStatement(statement);
        if (statement == null) {
            return null;
        }
        while (statement.getParentPath() != null && !JavaPluginUtils.isParentOf(statement.getParentPath(), allCandidates)) {
            statement = statement.getParentPath();
        }
        while (statement.getParentPath() != null && statement.getParentPath().getLeaf().getKind() != Tree.Kind.BLOCK) {
            statement = statement.getParentPath();
        }
        if (statement.getParentPath() == null) {
            return null;
        }
        BlockTree blockTree = (BlockTree)statement.getParentPath().getLeaf();
        StatementTree statementTree = (StatementTree)statement.getLeaf();
        int index = blockTree.getStatements().indexOf(statementTree);
        if (index == -1) {
            return null;
        }
        return blockTree;
    }

    private Problem initDelegate() throws IllegalArgumentException {
        final Problem[] p = new Problem[1];
        if (this.paramTable == null) {
            try {
                JavaSource source = JavaSource.forFileObject((FileObject)this.treePathHandle.getFileObject());
                source.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void run(CompilationController info) {
                        p[0] = IntroduceParameterPlugin.this.initDelegate(info);
                    }

                    public void cancel() {
                    }
                }, true);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            this.paramTable[this.index] = new ChangeParametersRefactoring.ParameterInfo(-1, this.refactoring.getParameterName(), this.paramTable[this.index].getType(), this.paramTable[this.index].getDefaultValue());
        }
        return p[0];
    }

    private Problem initDelegate(CompilationController info) throws IllegalArgumentException {
        Problem p = null;
        String FINAL = "final ";
        if (this.paramTable == null) {
            try {
                ExpressionTree expression;
                TypeElement object;
                List<? extends TypeMirror> targetType;
                TypeMirror tm;
                ExecutableElement method;
                info.toPhase(JavaSource.Phase.RESOLVED);
                TreePath path = this.treePathHandle.resolve((CompilationInfo)info);
                TreePath methodPath = JavaPluginUtils.findMethod(path);
                ExecutableElement executableElement = method = methodPath == null ? null : (ExecutableElement)info.getTrees().getElement(methodPath);
                if (method == null) {
                    p = JavaPluginUtils.chainProblems(p, new Problem(true, NbBundle.getMessage(IntroduceParameterPlugin.class, (String)"ERR_canNotResolve", (Object)(methodPath != null ? methodPath.getLeaf().toString() : this.treePathHandle))));
                    return p;
                }
                List<? extends VariableElement> parameters = method.getParameters();
                this.paramTable = new ChangeParametersRefactoring.ParameterInfo[parameters.size() + 1];
                for (int originalIndex = 0; originalIndex < parameters.size(); ++originalIndex) {
                    VariableElement param = parameters.get(originalIndex);
                    VariableTree parTree = (VariableTree)info.getTrees().getTree(param);
                    String typeRepresentation = method.isVarArgs() && originalIndex == parameters.size() - 1 ? parTree.getType().toString().replace("[]", "...") : parTree.getType().toString();
                    this.paramTable[originalIndex] = new ChangeParametersRefactoring.ParameterInfo(originalIndex, param.getSimpleName().toString(), typeRepresentation, null);
                }
                this.index = this.paramTable.length - 1;
                if (method.isVarArgs()) {
                    this.paramTable[this.index] = this.paramTable[--this.index];
                }
                tm = (tm = info.getTrees().getTypeMirror(path)) != null && tm.getKind() == TypeKind.NULL ? (!(targetType = CreateElementUtilities.resolveType(new HashSet<ElementKind>(), (CompilationInfo)info, path.getParentPath(), path.getLeaf(), (int)info.getTrees().getSourcePositions().getStartPosition(path.getCompilationUnit(), path.getLeaf()), new TypeMirror[1], new int[1])).isEmpty() ? targetType.get(0) : ((object = info.getElements().getTypeElement("java.lang.Object")) != null ? object.asType() : null)) : JavaPluginUtils.convertIfAnonymous(JavaPluginUtils.resolveCapturedType((CompilationInfo)info, tm));
                if (tm == null) {
                    p = JavaPluginUtils.chainProblems(p, new Problem(true, NbBundle.getMessage(IntroduceParameterPlugin.class, (String)"ERR_canNotResolve", (Object)path.getLeaf().toString())));
                }
                String type = info.getTypeUtilities().getTypeName(tm, new TypeUtilities.TypeNameOptions[0]).toString();
                Tree original = path.getLeaf();
                boolean variableRewrite = original.getKind() == Tree.Kind.VARIABLE;
                ExpressionTree expressionTree = expression = !variableRewrite ? (ExpressionTree)original : ((VariableTree)original).getInitializer();
                if (expression != null && expression.getKind() == Tree.Kind.PARENTHESIZED) {
                    ParenthesizedTree parents = (ParenthesizedTree)expression;
                    expression = parents.getExpression();
                }
                this.paramTable[this.index] = new ChangeParametersRefactoring.ParameterInfo(-1, this.refactoring.getParameterName(), (this.refactoring.isFinal() ? "final " : "") + type, expression == null ? ((VariableTree)original).getName().toString() : expression.toString());
                TreePath resolved = this.treePathHandle.resolve((CompilationInfo)info);
                TreePath meth = JavaPluginUtils.findMethod(resolved);
                this.methodHandle = TreePathHandle.create((TreePath)meth, (CompilationInfo)info);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            String type = this.paramTable[this.index].getType();
            type = type.startsWith("final ") ? (this.refactoring.isFinal() ? type : type.substring("final ".length())) : (this.refactoring.isFinal() ? "final " + type : type);
            this.paramTable[this.index] = new ChangeParametersRefactoring.ParameterInfo(-1, this.refactoring.getParameterName(), type, this.paramTable[this.index].getDefaultValue());
        }
        return p;
    }

    private ExecutableElement getMethodElement(TreePathHandle handle, CompilationInfo info) {
        return (ExecutableElement)info.getTrees().getElement(JavaPluginUtils.findMethod(handle.resolve(info)));
    }
}

