/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.resolver;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.framework.resolver.WrappedCapability;
import org.apache.felix.framework.resolver.WrappedRequirement;
import org.apache.felix.framework.util.ImmutableList;
import org.apache.felix.framework.wiring.BundleCapabilityImpl;
import org.apache.felix.framework.wiring.BundleRequirementImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WrappedRevision
implements BundleRevision {
    private final BundleRevision m_host;
    private final List<BundleRevision> m_fragments;
    private List<BundleCapability> m_cachedCapabilities = null;
    private List<BundleRequirement> m_cachedRequirements = null;

    public WrappedRevision(BundleRevision host, List<BundleRevision> fragments) {
        this.m_host = host;
        this.m_fragments = fragments;
    }

    public BundleRevision getHost() {
        return this.m_host;
    }

    public List<BundleRevision> getFragments() {
        return this.m_fragments;
    }

    @Override
    public String getSymbolicName() {
        return this.m_host.getSymbolicName();
    }

    @Override
    public Version getVersion() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<Capability> getCapabilities(String namespace) {
        return WrappedRevision.asCapabilityList(this.getDeclaredCapabilities(namespace));
    }

    private static List<Capability> asCapabilityList(List caps) {
        return caps;
    }

    @Override
    public List<BundleCapability> getDeclaredCapabilities(String namespace) {
        if (this.m_cachedCapabilities == null) {
            ArrayList<WrappedCapability> caps = new ArrayList<WrappedCapability>();
            for (BundleCapability cap : this.m_host.getDeclaredCapabilities(null)) {
                caps.add(new WrappedCapability(this, (BundleCapabilityImpl)cap));
            }
            if (this.m_fragments != null) {
                for (BundleRevision fragment : this.m_fragments) {
                    for (BundleCapability cap : fragment.getDeclaredCapabilities(null)) {
                        caps.add(new WrappedCapability(this, (BundleCapabilityImpl)cap));
                    }
                }
            }
            this.m_cachedCapabilities = ImmutableList.newInstance(caps);
        }
        return this.m_cachedCapabilities;
    }

    @Override
    public List<Requirement> getRequirements(String namespace) {
        return WrappedRevision.asRequirementList(this.getDeclaredRequirements(namespace));
    }

    private static List<Requirement> asRequirementList(List reqs) {
        return reqs;
    }

    @Override
    public List<BundleRequirement> getDeclaredRequirements(String namespace) {
        if (this.m_cachedRequirements == null) {
            ArrayList<WrappedRequirement> reqs = new ArrayList<WrappedRequirement>();
            for (BundleRequirement req : this.m_host.getDeclaredRequirements(null)) {
                reqs.add(new WrappedRequirement(this, (BundleRequirementImpl)req));
            }
            if (this.m_fragments != null) {
                for (BundleRevision fragment : this.m_fragments) {
                    for (BundleRequirement req : fragment.getDeclaredRequirements(null)) {
                        if (req.getNamespace().equals("osgi.wiring.host")) continue;
                        reqs.add(new WrappedRequirement(this, (BundleRequirementImpl)req));
                    }
                }
            }
            this.m_cachedRequirements = ImmutableList.newInstance(reqs);
        }
        return this.m_cachedRequirements;
    }

    @Override
    public int getTypes() {
        return this.m_host.getTypes();
    }

    @Override
    public BundleWiring getWiring() {
        return null;
    }

    @Override
    public Bundle getBundle() {
        return this.m_host.getBundle();
    }

    public String toString() {
        return this.m_host.toString();
    }
}

