/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.proxy.pac.datetime;

import java.util.Calendar;

class TimeRange {
    private static final int UNDEFINED = -1;
    private final int hourMin;
    private final int hourMax;
    private final int minuteMin;
    private final int minuteMax;
    private final int secondMin;
    private final int secondMax;

    public TimeRange(int hourMin, int hourMax, int minuteMin, int minuteMax, int secondMin, int secondMax) {
        this.hourMin = hourMin;
        this.hourMax = hourMax == -1 && hourMin != -1 ? hourMin : hourMax;
        this.minuteMin = minuteMin;
        this.minuteMax = minuteMax == -1 && minuteMin != -1 ? minuteMin : minuteMax;
        this.secondMin = secondMin;
        this.secondMax = secondMax == -1 && secondMin != -1 ? secondMin : secondMax;
    }

    public boolean isInRange(Calendar cal) {
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        if (this.hourDefined() && (this.hourMin <= this.hourMax ? hour < this.hourMin || hour > this.hourMax : hour < this.hourMin && hour > this.hourMax)) {
            return false;
        }
        if (this.minuteDefined()) {
            if (this.hourDefined()) {
                if (hour == this.hourMin && minute < this.minuteMin) {
                    return false;
                }
                if (hour == this.hourMax && minute > this.minuteMax) {
                    return false;
                }
            } else if (this.minuteMin <= this.minuteMax ? minute < this.minuteMin || minute > this.minuteMax : minute < this.minuteMin && minute > this.minuteMax) {
                return false;
            }
        }
        if (this.secondDefined()) {
            if (this.minuteDefined()) {
                if (this.hourDefined()) {
                    if (hour == this.hourMin && minute == this.minuteMin && second < this.secondMin) {
                        return false;
                    }
                    if (hour == this.hourMax && minute == this.minuteMax && second > this.secondMax) {
                        return false;
                    }
                } else {
                    if (minute == this.minuteMin && second < this.secondMin) {
                        return false;
                    }
                    if (minute == this.minuteMax && second > this.secondMax) {
                        return false;
                    }
                }
            } else if (this.secondMin <= this.secondMax ? second < this.secondMin || second > this.secondMax : second < this.secondMin && second > this.secondMax) {
                return false;
            }
        }
        return true;
    }

    private boolean hourDefined() {
        return this.hourMin != -1 || this.hourMax != -1;
    }

    private boolean minuteDefined() {
        return this.minuteMin != -1 || this.minuteMax != -1;
    }

    private boolean secondDefined() {
        return this.secondMin != -1 || this.secondMax != -1;
    }

    public static TimeRangeBuilder getBuilder() {
        return new TimeRangeBuilder();
    }

    public static class TimeRangeBuilder {
        private int hourMin = -1;
        private int hourMax = -1;
        private int minuteMin = -1;
        private int minuteMax = -1;
        private int secondMin = -1;
        private int secondMax = -1;

        private TimeRangeBuilder() {
        }

        public TimeRangeBuilder setHourMinMax(int hourMin, int hourMax) {
            this.hourMin = hourMin;
            this.hourMax = hourMax;
            return this;
        }

        public TimeRangeBuilder setMinuteMinMax(int minuteMin, int minuteMax) {
            this.minuteMin = minuteMin;
            this.minuteMax = minuteMax;
            return this;
        }

        public TimeRangeBuilder setSecondMinMax(int secondMin, int secondMax) {
            this.secondMin = secondMin;
            this.secondMax = secondMax;
            return this;
        }

        public TimeRange createTimeRange() {
            return new TimeRange(this.hourMin, this.hourMax, this.minuteMin, this.minuteMax, this.secondMin, this.secondMax);
        }
    }
}

