# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.volume_mapper import VolumeMapper


class AMRVolumeMapper(VolumeMapper):
    """
    AMRVolumeMapper - AMR class for a volume mapper
    
    Superclass: VolumeMapper
    
    AMRVolumeMapper is the  definition of a volume mapper. for AMR
    Structured Data
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkAMRVolumeMapper, obj, update, **traits)
    
    interpolation_mode = traits.Trait('cubic',
    tvtk_base.TraitRevPrefixMap({'cubic': 2, 'linear': 1, 'nearest_neighbor': 0}), desc=\
        """
        Set interpolation mode for downsampling (lowres GPU) (initial
        value: cubic).
        """
    )

    def _interpolation_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInterpolationMode,
                        self.interpolation_mode_)

    requested_render_mode = traits.Trait('default',
    tvtk_base.TraitRevPrefixMap({'default': 0, 'gpu': 4, 'ray_cast': 2, 'ray_cast_and_texture': 2, 'texture': 2}), desc=\
        """
        Set the requested render mode. The default is
        SmartVolumeMapper::DefaultRenderMode.
        """
    )

    def _requested_render_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRequestedRenderMode,
                        self.requested_render_mode_)

    array_access_mode = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        Control how the mapper works with scalar point data and cell
        attribute data.  By default (_scalar_mode_to_default), the mapper
        will use point data, and if no point data is available, then cell
        data is used. Alternatively you can explicitly set the mapper to
        use point data (_scalar_mode_to_use_point_data) or cell data
        (_scalar_mode_to_use_cell_data). You can also choose to get the scalars
        from an array in point field data (_scalar_mode_to_use_point_field_data)
        or cell field data (_scalar_mode_to_use_cell_field_data).  If scalars
        are coming from a field data array, you must call
        select_scalar_array.
        """
    )

    def _array_access_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetArrayAccessMode,
                        self.array_access_mode)

    cropping_region_planes = traits.Array(enter_set=True, auto_set=False, shape=(6,), dtype="float", value=(0.0, 1.0, 0.0, 1.0, 0.0, 1.0), cols=3, desc=\
        """
        Set/Get the Cropping Region Planes ( xmin, xmax, ymin, ymax,
        zmin, zmax ) These planes are defined in volume coordinates -
        spacing and origin are considered.
        """
    )

    def _cropping_region_planes_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCroppingRegionPlanes,
                        self.cropping_region_planes)

    freeze_focal_point = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        """
        Select the type of resampling techinque approach to use.
        """
    )

    def _freeze_focal_point_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFreezeFocalPoint,
                        self.freeze_focal_point)

    def _get_input_connection(self):
        if self._vtk_obj.GetTotalNumberOfInputConnections():
            return wrap_vtk(self._vtk_obj.GetInputConnection(0, 0))
        else:
            return None
    
    def _set_input_connection(self, obj):
        old_val = self._get_input_connection()
        self._wrap_call(self._vtk_obj.SetInputConnection, deref_vtk(obj))
        self.trait_property_changed('input_connection', old_val, obj)
    input_connection = traits.Property(_get_input_connection,
                                       _set_input_connection,
                                       desc="The first input connection for this object, i.e. the result of `get_input_connection(0, 0)`.")
    
    def get_input_connection(self, *args):
        """
        V.get_input_connection(int, int) -> AlgorithmOutput
        C++: AlgorithmOutput *GetInputConnection(int port, int index)
        Get the algorithm output port connected to an input port.
        """
        ret = self._wrap_call(self._vtk_obj.GetInputConnection, *args)
        return wrap_vtk(ret)

    def set_input_connection(self, *args):
        """
        V.set_input_connection(int, AlgorithmOutput)
        C++: void SetInputConnection(int port, AlgorithmOutput *input)
            override;
        V.set_input_connection(AlgorithmOutput)
        
        Set the input data
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetInputConnection, *my_args)
        return ret

    number_of_samples = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="int", value=(128, 128, 128), cols=3, desc=\
        """
        
        """
    )

    def _number_of_samples_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfSamples,
                        self.number_of_samples)

    requested_resampling_mode = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        Select the type of resampling techinque approach to use.
        """
    )

    def _requested_resampling_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRequestedResamplingMode,
                        self.requested_resampling_mode)

    resampler_update_tolerance = traits.Float(1e-07, enter_set=True, auto_set=False, desc=\
        """
        Sets/Gets the tolerance used to determine if the resampler needs
        to be updated. Default is 10e-8
        """
    )

    def _resampler_update_tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetResamplerUpdateTolerance,
                        self.resampler_update_tolerance)

    use_default_threading = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        """
        Sets/Gets a flag that indicates the internal volume mapper should
        use the  default number of threads.  This is useful in
        applications such as para_view that will turn off multiple threads
        by default. Default is false
        """
    )

    def _use_default_threading_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseDefaultThreading,
                        self.use_default_threading)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        """
        Set/Get the input data
        """
    )

    def compute_resampler_bounds_frustum_method(self, *args):
        """
        V.compute_resampler_bounds_frustum_method(Camera, Renderer, (
            float, float, float, float, float, float), [float, float,
            float, float, float, float]) -> bool
        C++: static bool ComputeResamplerBoundsFrustumMethod(
            Camera *camera, Renderer *renderer,
            const double data_bounds[6], double out_bounds[6])
        Utility method used by update_resampler_frustrum_method() to compute
        the bounds.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ComputeResamplerBoundsFrustumMethod, *my_args)
        return ret

    def update_resampler(self, *args):
        """
        V.update_resampler(Renderer, OverlappingAMR)
        C++: void UpdateResampler(Renderer *ren,
            OverlappingAMR *amr)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.UpdateResampler, *my_args)
        return ret

    def update_resampler_frustrum_method(self, *args):
        """
        V.update_resampler_frustrum_method(Renderer, OverlappingAMR)
        C++: void UpdateResamplerFrustrumMethod(Renderer *ren,
            OverlappingAMR *amr)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.UpdateResamplerFrustrumMethod, *my_args)
        return ret

    _updateable_traits_ = \
    (('cropping', 'GetCropping'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('interpolation_mode', 'GetInterpolationMode'),
    ('requested_render_mode', 'GetRequestedRenderMode'), ('blend_mode',
    'GetBlendMode'), ('cropping_region_flags', 'GetCroppingRegionFlags'),
    ('scalar_mode', 'GetScalarMode'), ('array_access_mode',
    'GetArrayAccessMode'), ('cropping_region_planes',
    'GetCroppingRegionPlanes'), ('freeze_focal_point',
    'GetFreezeFocalPoint'), ('number_of_samples', 'GetNumberOfSamples'),
    ('requested_resampling_mode', 'GetRequestedResamplingMode'),
    ('resampler_update_tolerance', 'GetResamplerUpdateTolerance'),
    ('use_default_threading', 'GetUseDefaultThreading'),
    ('average_ip_scalar_range', 'GetAverageIPScalarRange'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'cropping', 'debug', 'global_warning_display',
    'release_data_flag', 'blend_mode', 'cropping_region_flags',
    'interpolation_mode', 'requested_render_mode', 'scalar_mode',
    'array_access_mode', 'average_ip_scalar_range',
    'cropping_region_planes', 'freeze_focal_point', 'number_of_samples',
    'progress_text', 'requested_resampling_mode',
    'resampler_update_tolerance', 'use_default_threading'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(AMRVolumeMapper, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit AMRVolumeMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['cropping'], ['blend_mode', 'cropping_region_flags',
            'interpolation_mode', 'requested_render_mode', 'scalar_mode'],
            ['array_access_mode', 'average_ip_scalar_range',
            'cropping_region_planes', 'freeze_focal_point', 'number_of_samples',
            'requested_resampling_mode', 'resampler_update_tolerance',
            'use_default_threading']),
            title='Edit AMRVolumeMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit AMRVolumeMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

