/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.common;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.common.io.DeadLetterQueueWriter;
import org.logstash.ext.JrubyEventExtLibrary;

@JRubyClass(name={"AbstractDeadLetterQueueWriter"})
public abstract class AbstractDeadLetterQueueWriterExt
extends RubyObject {
    AbstractDeadLetterQueueWriterExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @JRubyMethod(name={"is_open"})
    public final RubyBoolean isOpen(ThreadContext context) {
        return this.open(context);
    }

    @JRubyMethod(name={"plugin_id"})
    public final IRubyObject pluginId(ThreadContext context) {
        return this.getPluginId(context);
    }

    @JRubyMethod(name={"plugin_type"})
    public final IRubyObject pluginType(ThreadContext context) {
        return this.getPluginType(context);
    }

    @JRubyMethod(name={"inner_writer"})
    public final IRubyObject innerWriter(ThreadContext context) {
        return this.getInnerWriter(context);
    }

    @JRubyMethod
    public final IRubyObject write(ThreadContext context, IRubyObject event, IRubyObject reason) {
        return this.doWrite(context, event, reason);
    }

    @JRubyMethod
    public final IRubyObject close(ThreadContext context) {
        return this.doClose(context);
    }

    protected abstract RubyBoolean open(ThreadContext var1);

    protected abstract IRubyObject getPluginId(ThreadContext var1);

    protected abstract IRubyObject getPluginType(ThreadContext var1);

    protected abstract IRubyObject getInnerWriter(ThreadContext var1);

    protected abstract IRubyObject doWrite(ThreadContext var1, IRubyObject var2, IRubyObject var3);

    protected abstract IRubyObject doClose(ThreadContext var1);

    @JRubyClass(name={"PluginDeadLetterQueueWriter"})
    public static final class PluginDeadLetterQueueWriterExt
    extends AbstractDeadLetterQueueWriterExt {
        private IRubyObject writerWrapper;
        private DeadLetterQueueWriter innerWriter;
        private IRubyObject pluginId;
        private IRubyObject pluginType;
        private String pluginIdString;
        private String pluginTypeString;

        public PluginDeadLetterQueueWriterExt(Ruby runtime, RubyClass metaClass) {
            super(runtime, metaClass);
        }

        @JRubyMethod
        public PluginDeadLetterQueueWriterExt initialize(ThreadContext context, IRubyObject innerWriter, IRubyObject pluginId, IRubyObject pluginType) {
            this.writerWrapper = innerWriter;
            if (this.writerWrapper.getJavaClass().equals(DeadLetterQueueWriter.class)) {
                this.innerWriter = (DeadLetterQueueWriter)this.writerWrapper.toJava(DeadLetterQueueWriter.class);
            }
            this.pluginId = pluginId;
            if (!pluginId.isNil()) {
                this.pluginIdString = pluginId.asJavaString();
            }
            this.pluginType = pluginType;
            if (!pluginType.isNil()) {
                this.pluginTypeString = pluginType.asJavaString();
            }
            return this;
        }

        @Override
        protected IRubyObject getPluginId(ThreadContext context) {
            return this.pluginId;
        }

        @Override
        protected IRubyObject getPluginType(ThreadContext context) {
            return this.pluginType;
        }

        @Override
        protected IRubyObject getInnerWriter(ThreadContext context) {
            return this.writerWrapper;
        }

        @Override
        protected IRubyObject doWrite(ThreadContext context, IRubyObject event, IRubyObject reason) {
            if (this.hasOpenWriter()) {
                try {
                    this.innerWriter.writeEntry(((JrubyEventExtLibrary.RubyEvent)event).getEvent(), this.pluginIdString, this.pluginTypeString, reason.asJavaString());
                }
                catch (IOException ex) {
                    throw new IllegalStateException(ex);
                }
            }
            return context.nil;
        }

        @Override
        protected IRubyObject doClose(ThreadContext context) {
            if (this.hasOpenWriter()) {
                this.innerWriter.close();
            }
            return context.nil;
        }

        @Override
        protected RubyBoolean open(ThreadContext context) {
            return context.runtime.newBoolean(this.hasOpenWriter());
        }

        private boolean hasOpenWriter() {
            return this.innerWriter != null && this.innerWriter.isOpen();
        }
    }

    @JRubyClass(name={"DummyDeadLetterQueueWriter"})
    public static final class DummyDeadLetterQueueWriterExt
    extends AbstractDeadLetterQueueWriterExt {
        public DummyDeadLetterQueueWriterExt(Ruby runtime, RubyClass metaClass) {
            super(runtime, metaClass);
        }

        @JRubyMethod
        public IRubyObject initialize(ThreadContext context) {
            return super.initialize(context);
        }

        @Override
        protected IRubyObject getPluginId(ThreadContext context) {
            return context.nil;
        }

        @Override
        protected IRubyObject getPluginType(ThreadContext context) {
            return context.nil;
        }

        @Override
        protected IRubyObject getInnerWriter(ThreadContext context) {
            return context.nil;
        }

        @Override
        protected IRubyObject doWrite(ThreadContext context, IRubyObject event, IRubyObject reason) {
            return context.nil;
        }

        @Override
        protected IRubyObject doClose(ThreadContext context) {
            return context.nil;
        }

        @Override
        protected RubyBoolean open(ThreadContext context) {
            return context.fals;
        }
    }
}

