/*
 * Decompiled with CFR 0.152.
 */
package org.logstash;

import org.logstash.ConvertedList;
import org.logstash.ConvertedMap;
import org.logstash.FieldReference;

public final class Accessors {
    private Accessors() {
    }

    public static Object get(ConvertedMap data, FieldReference field) {
        Object target = Accessors.findParent(data, field);
        return target == null ? null : Accessors.fetch(target, field.getKey());
    }

    public static Object set(ConvertedMap data, FieldReference field, Object value) {
        return Accessors.setChild(Accessors.findCreateTarget(data, field), field.getKey(), value);
    }

    public static Object del(ConvertedMap data, FieldReference field) {
        Object target = Accessors.findParent(data, field);
        if (target instanceof ConvertedMap) {
            return ((ConvertedMap)target).remove(field.getKey());
        }
        return target == null ? null : Accessors.delFromList((ConvertedList)target, field.getKey());
    }

    public static boolean includes(ConvertedMap data, FieldReference field) {
        Object target = Accessors.findParent(data, field);
        String key = field.getKey();
        return target instanceof ConvertedMap && ((ConvertedMap)target).containsKey(key) || target instanceof ConvertedList && Accessors.foundInList(key, (ConvertedList)target);
    }

    private static Object delFromList(ConvertedList list, String key) {
        try {
            return list.remove(Accessors.listIndex(key, list.size()));
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            return null;
        }
    }

    private static Object setOnList(String key, Object value, ConvertedList list) {
        int index;
        try {
            index = Integer.parseInt(key);
        }
        catch (NumberFormatException e) {
            return null;
        }
        int size = list.size();
        if (index >= size) {
            Accessors.appendAtIndex(list, value, index, size);
        } else {
            list.set(Accessors.listIndex(index, size), value);
        }
        return value;
    }

    private static void appendAtIndex(ConvertedList list, Object value, int index, int size) {
        for (int i = size; i < index; ++i) {
            list.add(null);
        }
        list.add(value);
    }

    private static Object findParent(ConvertedMap data, FieldReference field) {
        Object target = data;
        for (String key : field.getPath()) {
            if ((target = Accessors.fetch(target, key)) instanceof ConvertedMap || target instanceof ConvertedList) continue;
            return null;
        }
        return target;
    }

    private static Object findCreateTarget(ConvertedMap data, FieldReference field) {
        Object target = data;
        boolean create = false;
        for (String key : field.getPath()) {
            Object result;
            if (create) {
                result = Accessors.createChild((ConvertedMap)target, key);
            } else {
                result = Accessors.fetch(target, key);
                boolean bl = create = result == null;
                if (create) {
                    result = new ConvertedMap(1);
                    Accessors.setChild(target, key, result);
                }
            }
            target = result;
        }
        return target;
    }

    private static Object setChild(Object target, String key, Object value) {
        if (target instanceof ConvertedMap) {
            ((ConvertedMap)target).putInterned(key, value);
            return value;
        }
        if (target instanceof ConvertedList) {
            return Accessors.setOnList(key, value, (ConvertedList)target);
        }
        throw new InvalidFieldSetException(target, key, value);
    }

    private static Object createChild(ConvertedMap target, String key) {
        ConvertedMap result = new ConvertedMap(1);
        target.putInterned(key, result);
        return result;
    }

    private static Object fetch(Object target, String key) {
        return target instanceof ConvertedMap ? ((ConvertedMap)target).get(key) : Accessors.fetchFromList((ConvertedList)target, key);
    }

    private static Object fetchFromList(ConvertedList list, String key) {
        try {
            return list.get(Accessors.listIndex(key, list.size()));
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            return null;
        }
    }

    private static boolean foundInList(String key, ConvertedList target) {
        return Accessors.fetchFromList(target, key) != null;
    }

    public static int listIndex(int i, int size) {
        return i < 0 ? size + i : i;
    }

    private static int listIndex(String key, int size) {
        return Accessors.listIndex(Integer.parseInt(key), size);
    }

    public static class InvalidFieldSetException
    extends RuntimeException {
        public InvalidFieldSetException(Object target, String key, Object value) {
            super(String.format("Could not set field '%s' on object '%s' to value '%s'.This is probably due to trying to set a field like [foo][bar] = someValuewhen [foo] is not either a map or a string", key, target, value));
        }
    }
}

