/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util.slicedMap;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.util.Key;
import com.intellij.util.keyFMap.KeyFMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import kotlin.jvm.functions.Function3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.util.slicedMap.AbstractWritableSlice;
import org.jetbrains.kotlin.util.slicedMap.KeyWithSlice;
import org.jetbrains.kotlin.util.slicedMap.MutableSlicedMap;
import org.jetbrains.kotlin.util.slicedMap.OpenAddressLinearProbingHashTable;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.RewritePolicy;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class SlicedMapImpl
implements MutableSlicedMap {
    private final boolean alwaysAllowRewrite;
    @Nullable
    private Map<Object, KeyFMap> map = null;
    private Multimap<WritableSlice<?, ?>, Object> collectiveSliceKeys = null;

    public SlicedMapImpl(boolean alwaysAllowRewrite) {
        this.alwaysAllowRewrite = alwaysAllowRewrite;
    }

    @Override
    public <K, V> void put(WritableSlice<K, V> slice, K key, V value) {
        Object oldValue;
        KeyFMap holder;
        if (!slice.check(key, value)) {
            return;
        }
        if (this.map == null) {
            this.map = new OpenAddressLinearProbingHashTable<Object, KeyFMap>();
        }
        if ((holder = this.map.get(key)) == null) {
            holder = KeyFMap.EMPTY_MAP;
        }
        KeyWithSlice<K, V, WritableSlice<K, V>> sliceKey = slice.getKey();
        RewritePolicy rewritePolicy = slice.getRewritePolicy();
        if (!this.alwaysAllowRewrite && rewritePolicy.rewriteProcessingNeeded(key) && (oldValue = holder.get(sliceKey)) != null && !rewritePolicy.processRewrite(slice, key, oldValue, value)) {
            return;
        }
        if (slice.isCollective()) {
            if (this.collectiveSliceKeys == null) {
                this.collectiveSliceKeys = ArrayListMultimap.create();
            }
            this.collectiveSliceKeys.put(slice, key);
        }
        this.map.put(key, holder.plus(sliceKey, value));
        slice.afterPut(this, key, value);
    }

    @Override
    public void clear() {
        this.map = null;
        this.collectiveSliceKeys = null;
    }

    @Override
    public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
        KeyFMap holder = this.map != null ? this.map.get(key) : null;
        Object value = holder == null ? null : (Object)holder.get(slice.getKey());
        return slice.computeValue(this, key, value, value == null);
    }

    @Override
    public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
        assert (slice.isCollective()) : "Keys are not collected for slice " + slice;
        if (this.collectiveSliceKeys == null) {
            return Collections.emptyList();
        }
        return this.collectiveSliceKeys.get(slice);
    }

    @Override
    public void forEach(@NotNull Function3<WritableSlice, Object, Object, Void> f) {
        if (this.map == null) {
            return;
        }
        this.map.forEach((? super K key, ? super V holder) -> {
            if (holder == null) {
                return;
            }
            for (Key sliceKey : holder.getKeys()) {
                Object value = holder.get(sliceKey);
                f.invoke((WritableSlice)((AbstractWritableSlice)sliceKey).getSlice(), key, value);
            }
        });
    }

    @Override
    @NotNull
    public <K, V> ImmutableMap<K, V> getSliceContents(@NotNull ReadOnlySlice<K, V> slice) {
        if (this.map == null) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.map.forEach((? super K key, ? super V holder) -> {
            Object value = holder.get(slice.getKey());
            if (value != null) {
                builder.put(key, value);
            }
        });
        return builder.build();
    }
}

