/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import javajs.util.Lst;
import org.jmol.minimize.MinAngle;
import org.jmol.minimize.forcefield.Calculation;

class MMFFAngleCalc
extends Calculation {
    static final double CB = -0.006981317007977318;

    MMFFAngleCalc() {
    }

    void setData(Lst<Object[]> lst, MinAngle minAngle) {
        Object object = this.calcs.getParameterObj(minAngle);
        if (object == null) {
            return;
        }
        lst.addLast(new Object[]{minAngle.data, object, minAngle.key});
    }

    @Override
    double compute(Object[] objectArray) {
        this.key = (Integer)objectArray[2];
        this.getPointers(objectArray);
        double d = this.dData[0];
        double d2 = this.dData[1];
        this.calcs.setAngleVariables(this);
        double d3 = this.theta * 57.29577951308232 - d2;
        if (d2 == 180.0) {
            this.energy = 143.9325 * d * (1.0 + Math.cos(this.theta));
            if (this.calcs.gradients) {
                this.dE = -143.9325 * d * Math.sin(this.theta);
            }
        } else {
            this.energy = 0.021922 * d * Math.pow(d3, 2.0) * (1.0 + -0.006981317007977318 * d3);
            if (this.calcs.gradients) {
                this.dE = 0.021922 * d * d3 * (2.0 + -0.020943951023931956 * d3);
            }
        }
        if (this.calcs.gradients) {
            this.calcs.addForces(this, 3);
        }
        if (this.calcs.logging) {
            this.calcs.appendLogData(this.calcs.getDebugLine(1, this));
        }
        return this.energy;
    }
}

