/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.util.Logger;

class IsoIntersectGridReader
extends VolumeFileReader {
    private VolumeFileReader[] readers;
    private float[] factors;

    @Override
    protected void init(SurfaceGenerator surfaceGenerator) {
        this.initSR(surfaceGenerator);
        Object[] objectArray = (Object[])surfaceGenerator.getReaderData();
        this.readers = (VolumeFileReader[])objectArray[0];
        this.factors = (float[])objectArray[1];
    }

    @Override
    protected boolean readVolumeParameters(boolean bl) {
        int n = this.readers.length;
        while (--n >= 0) {
            if (this.readers[n].readVolumeParameters(bl)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected float getNextVoxelValue() throws Exception {
        float f = 0.0f;
        int n = this.readers.length;
        while (--n >= 0) {
            f += this.factors[n] * this.readers[n].getNextVoxelValue();
        }
        return f;
    }

    @Override
    protected void closeReader() {
        if (this.readerClosed) {
            return;
        }
        this.readerClosed = true;
        int n = this.readers.length;
        while (--n >= 0) {
            this.readers[n].closeReaderSFR();
        }
        if (this.nData == 0 || this.dataMax == -3.4028235E38f) {
            return;
        }
        this.dataMean /= (float)this.nData;
        Logger.info("IsoIntersectFileReader closing file: " + this.nData + " points read \ndata min/max/mean = " + this.dataMin + "/" + this.dataMax + "/" + this.dataMean);
    }

    @Override
    protected void readParameters() throws Exception {
    }
}

