#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: ghc-typelits-natnormalise
version: 0.6.2
id: ghc-typelits-natnormalise-0.6.2-CTDye4mw07G4L38KXNoBHf
key: ghc-typelits-natnormalise-0.6.2-CTDye4mw07G4L38KXNoBHf
license: BSD-2-Clause
copyright: Copyright © 2015-2016, University of Twente,
           2017-2018, QBayLogic B.V.
maintainer: christiaan.baaij@gmail.com
author: Christiaan Baaij
homepage: http://www.clash-lang.org/
synopsis: GHC typechecker plugin for types of kind GHC.TypeLits.Nat
description:
    A type checker plugin for GHC that can solve /equalities/ of types of kind
    @Nat@, where these types are either:
    .
    * Type-level naturals
    .
    * Type variables
    .
    * Applications of the arithmetic expressions @(+,-,*,^)@.
    .
    It solves these equalities by normalising them to /sort-of/ @SOP@
    (Sum-of-Products) form, and then perform a simple syntactic equality.
    .
    For example, this solver can prove the equality between:
    .
    @
    (x + 2)^(y + 2)
    @
    .
    and
    .
    @
    4*x*(2 + x)^y + 4*(2 + x)^y + (2 + x)^y*x^2
    @
    .
    Because the latter is actually the @SOP@ normal form of the former.
    .
    To use the plugin, add the
    .
    @
    OPTIONS_GHC -fplugin GHC.TypeLits.Normalise
    @
    .
    Pragma to the header of your file.
category: Type System
abi: 45901addec1f9270d574767b398d796e
exposed: True
exposed-modules:
    GHC.TypeLits.Normalise GHC.TypeLits.Normalise.SOP
    GHC.TypeLits.Normalise.Unify
import-dirs: /usr/lib/ghc-8.6.4/site-local/ghc-typelits-natnormalise-0.6.2
library-dirs: /usr/lib/ghc-8.6.4/site-local/ghc-typelits-natnormalise-0.6.2
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/x86_64-linux-ghc-8.6.4/ghc-typelits-natnormalise-0.6.2
hs-libraries: HSghc-typelits-natnormalise-0.6.2-CTDye4mw07G4L38KXNoBHf
depends:
    base-4.12.0.0 ghc-8.6.4
    ghc-tcplugins-extra-0.3-Ebvoj9UwWkK1Ku3MQihAC5 integer-gmp-1.0.2.0
    transformers-0.5.6.2
haddock-interfaces: /usr/share/doc/haskell-ghc-typelits-natnormalise/html/ghc-typelits-natnormalise.haddock
haddock-html: /usr/share/doc/haskell-ghc-typelits-natnormalise/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

