/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.TaskResolver;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.util.GUtil;

public class DefaultConfigurableFileCollection
extends CompositeFileCollection
implements ConfigurableFileCollection {
    private final Set<Object> files;
    private final String displayName;
    private final PathToFileResolver resolver;
    private final DefaultTaskDependency buildDependency;

    public DefaultConfigurableFileCollection(PathToFileResolver fileResolver, @Nullable TaskResolver taskResolver) {
        this("file collection", fileResolver, taskResolver, null);
    }

    public DefaultConfigurableFileCollection(PathToFileResolver fileResolver, @Nullable TaskResolver taskResolver, Collection<?> files) {
        this("file collection", fileResolver, taskResolver, files);
    }

    public DefaultConfigurableFileCollection(PathToFileResolver fileResolver, @Nullable TaskResolver taskResolver, Object[] files) {
        this("file collection", fileResolver, taskResolver, Arrays.asList(files));
    }

    public DefaultConfigurableFileCollection(String displayName, PathToFileResolver fileResolver, @Nullable TaskResolver taskResolver) {
        this(displayName, fileResolver, taskResolver, null);
    }

    public DefaultConfigurableFileCollection(String displayName, PathToFileResolver fileResolver, @Nullable TaskResolver taskResolver, @Nullable Collection<?> files) {
        this.displayName = displayName;
        this.resolver = fileResolver;
        this.files = new LinkedHashSet<Object>();
        if (files != null) {
            this.files.addAll(files);
        }
        this.buildDependency = new DefaultTaskDependency(taskResolver);
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public Set<Object> getFrom() {
        return this.files;
    }

    public void setFrom(Iterable<?> path) {
        this.files.clear();
        this.files.add(path);
    }

    public void setFrom(Object ... paths) {
        this.files.clear();
        GUtil.addToCollection(this.files, (Iterable[])new Iterable[]{Arrays.asList(paths)});
    }

    public ConfigurableFileCollection from(Object ... paths) {
        GUtil.addToCollection(this.files, (Iterable[])new Iterable[]{Arrays.asList(paths)});
        return this;
    }

    public ConfigurableFileCollection builtBy(Object ... tasks) {
        this.buildDependency.add(tasks);
        return this;
    }

    public Set<Object> getBuiltBy() {
        return this.buildDependency.getMutableValues();
    }

    public ConfigurableFileCollection setBuiltBy(Iterable<?> tasks) {
        this.buildDependency.setValues(tasks);
        return this;
    }

    @Override
    public void visitContents(FileCollectionResolveContext context) {
        FileCollectionResolveContext nested = context.push(this.resolver);
        nested.add(this.files);
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        context.add((Object)this.buildDependency);
        super.visitDependencies(context);
    }
}

