/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.core.builtin.xml;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.php.internal.server.core.builtin.xml.Factory;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLElement {
    private Element xmlElement;
    protected Factory factory;

    public Element getElementNode() {
        return this.xmlElement;
    }

    public Attr addAttribute(String s, String s1) {
        Attr attr = this.factory.createAttribute(s, this.xmlElement);
        attr.setValue(s1);
        return attr;
    }

    public XMLElement createElement(int index, String s) {
        return this.factory.createElement(index, s, this.xmlElement);
    }

    public XMLElement createElement(String s) {
        return this.factory.createElement(s, this.xmlElement);
    }

    public XMLElement findElement(String s) {
        NodeList nodelist = this.xmlElement.getElementsByTagName(s);
        int i = nodelist == null ? 0 : nodelist.getLength();
        int j = 0;
        while (j < i) {
            Node node = nodelist.item(j);
            String s1 = node.getNodeName().trim();
            if (s1.equals(s)) {
                return this.factory.newInstance((Element)node);
            }
            ++j;
        }
        return this.createElement(s);
    }

    public XMLElement findElement(String s, int i) {
        NodeList nodelist = this.xmlElement.getElementsByTagName(s);
        int j = nodelist == null ? 0 : nodelist.getLength();
        int k = 0;
        while (k < j) {
            Node node = nodelist.item(k);
            String s1 = node.getNodeName().trim();
            if (s1.equals(s) && k == i) {
                return this.factory.newInstance((Element)node);
            }
            ++k;
        }
        return this.createElement(s);
    }

    public String getAttributeValue(String s) {
        Attr attr = this.xmlElement.getAttributeNode(s);
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    public Map<String, String> getAttributes() {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        NamedNodeMap attrs = this.xmlElement.getAttributes();
        if (attrs != null) {
            int i = 0;
            while (i < attrs.getLength()) {
                Node attr = attrs.item(i);
                String name = attr.getNodeName();
                String value = attr.getNodeValue();
                attributes.put(name, value);
                ++i;
            }
        }
        return attributes;
    }

    public String getElementName() {
        return this.xmlElement.getNodeName();
    }

    public String getElementValue() {
        return XMLElement.getElementValue(this.xmlElement);
    }

    protected static String getElementValue(Element element) {
        String s = element.getNodeValue();
        if (s != null) {
            return s;
        }
        NodeList nodelist = element.getChildNodes();
        int i = 0;
        while (i < nodelist.getLength()) {
            if (nodelist.item(i) instanceof Text) {
                return ((Text)nodelist.item(i)).getData();
            }
            ++i;
        }
        return null;
    }

    public Element getSubElement(String s) {
        NodeList nodelist = this.xmlElement.getElementsByTagName(s);
        int i = nodelist == null ? 0 : nodelist.getLength();
        int j = 0;
        while (j < i) {
            Node node = nodelist.item(j);
            String s1 = node.getNodeName().trim();
            if (s1.equals(s)) {
                return (Element)node;
            }
            ++j;
        }
        return null;
    }

    public String getSubElementValue(String s) {
        Element element = this.getSubElement(s);
        if (element == null) {
            return null;
        }
        String value = XMLElement.getElementValue(element);
        if (value == null) {
            return null;
        }
        return value.trim();
    }

    public boolean removeAttribute(String s) {
        try {
            this.xmlElement.removeAttribute(s);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean removeElement(String s, int i) {
        NodeList nodelist = this.xmlElement.getElementsByTagName(s);
        int j = nodelist == null ? 0 : nodelist.getLength();
        int k = 0;
        while (k < j) {
            Node node = nodelist.item(k);
            String s1 = node.getNodeName().trim();
            if (s1.equals(s) && k == i) {
                this.xmlElement.removeChild(node);
                return true;
            }
            ++k;
        }
        return false;
    }

    public void setAttributeValue(String s, String s1) {
        Attr attr = this.xmlElement.getAttributeNode(s);
        if (attr == null) {
            attr = this.addAttribute(s, s1);
        } else {
            attr.setValue(s1);
        }
    }

    void setElement(Element element) {
        this.xmlElement = element;
    }

    protected static void setElementValue(Element element, String value) {
        String s = element.getNodeValue();
        if (s != null) {
            element.setNodeValue(value);
            return;
        }
        NodeList nodelist = element.getChildNodes();
        int i = 0;
        while (i < nodelist.getLength()) {
            if (nodelist.item(i) instanceof Text) {
                Text text = (Text)nodelist.item(i);
                text.setData(value);
                return;
            }
            ++i;
        }
    }

    void setFactory(Factory factory1) {
        this.factory = factory1;
    }

    public void setSubElementValue(String s, String value) {
        Element element = this.getSubElement(s);
        if (element == null) {
            element = this.factory.document.createElement(s);
            element.appendChild(this.factory.document.createTextNode("temp"));
            this.xmlElement.appendChild(element);
        }
        XMLElement.setElementValue(element, value);
    }

    public int sizeOfElement(String s) {
        NodeList nodelist = this.xmlElement.getElementsByTagName(s);
        int i = nodelist == null ? 0 : nodelist.getLength();
        return i;
    }

    /*
     * Unable to fully structure code
     */
    public void updateElementValue(String s) {
        block4: {
            block5: {
                try {
                    this.xmlElement.setNodeValue(s);
                    break block4;
                }
                catch (DOMException ex) {
                    nodelist = this.xmlElement.getChildNodes();
                    v0 = i = nodelist == null ? 0 : nodelist.getLength();
                    if (i <= 0) break block5;
                    j = 0;
                    ** while (j < i)
                }
lbl-1000:
                // 1 sources

                {
                    if (nodelist.item(j) instanceof Text) {
                        ((Text)nodelist.item(j)).setData(s);
                        return;
                    }
                    ++j;
                    continue;
lbl15:
                    // 1 sources

                    break block4;
                }
            }
            this.xmlElement.appendChild(this.factory.document.createTextNode(s));
        }
    }

    public boolean hasChildNodes() {
        return this.xmlElement.hasChildNodes();
    }

    public void removeChildren() {
        while (this.xmlElement.hasChildNodes()) {
            this.xmlElement.removeChild(this.xmlElement.getFirstChild());
        }
    }

    public void copyChildrenTo(XMLElement destination) {
        NodeList nodelist = this.xmlElement.getChildNodes();
        int len = nodelist == null ? 0 : nodelist.getLength();
        int i = 0;
        while (i < len) {
            Node node = nodelist.item(i);
            destination.importNode(node, true);
            ++i;
        }
    }

    public void importNode(Node node, boolean deep) {
        this.xmlElement.appendChild(this.xmlElement.getOwnerDocument().importNode(node, deep));
    }

    public boolean isEquivalent(XMLElement obj) {
        if (obj != null) {
            try {
                return XMLElement.elementsAreEquivalent(this.xmlElement, obj.getElementNode());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isEquivalentTest(XMLElement obj) {
        if (obj != null) {
            return XMLElement.elementsAreEquivalent(this.xmlElement, obj.getElementNode());
        }
        return false;
    }

    private static boolean elementsAreEquivalent(Element element, Element otherElement) {
        if (element == otherElement) {
            return true;
        }
        if (!element.getNodeName().equals(otherElement.getNodeName())) {
            return false;
        }
        if (element.hasChildNodes()) {
            if (otherElement.hasChildNodes() && XMLElement.attributesAreEqual(element, otherElement)) {
                NodeList nodelist = element.getChildNodes();
                NodeList otherNodelist = otherElement.getChildNodes();
                if (nodelist.getLength() == otherNodelist.getLength()) {
                    Node node = XMLElement.nextNonTextNode(element.getFirstChild());
                    Node otherNode = XMLElement.nextNonTextNode(otherElement.getFirstChild());
                    while (node != null) {
                        if (otherNode == null) {
                            return false;
                        }
                        short nextNodeType = node.getNodeType();
                        if (nextNodeType != otherNode.getNodeType()) {
                            return false;
                        }
                        if (nextNodeType == 1) {
                            if (!XMLElement.elementsAreEquivalent((Element)node, (Element)otherNode)) {
                                return false;
                            }
                        } else if (nextNodeType == 8) {
                            if (!XMLElement.nodeValuesAreEqual(node, otherNode)) {
                                return false;
                            }
                        } else {
                            return false;
                        }
                        node = XMLElement.nextNonTextNode(node.getNextSibling());
                        otherNode = XMLElement.nextNonTextNode(otherNode.getNextSibling());
                    }
                    if (otherNode == null) {
                        return true;
                    }
                }
            }
        } else if (!otherElement.hasChildNodes()) {
            return XMLElement.attributesAreEqual(element, otherElement);
        }
        return false;
    }

    private static Node nextNonTextNode(Node node) {
        while (node != null && node.getNodeType() == 3) {
            node = node.getNextSibling();
        }
        return node;
    }

    private static boolean attributesAreEqual(Element element, Element otherElement) {
        NamedNodeMap attrs = element.getAttributes();
        NamedNodeMap otherAttrs = otherElement.getAttributes();
        if (attrs == null && otherAttrs == null) {
            return XMLElement.nodeValuesAreEqual(element, otherElement);
        }
        if (attrs != null && otherAttrs != null && attrs.getLength() == otherAttrs.getLength()) {
            if (attrs.getLength() == 0) {
                return XMLElement.nodeValuesAreEqual(element, otherElement);
            }
            int i = 0;
            while (i < attrs.getLength()) {
                Node otherAttr;
                Node attr = attrs.item(i);
                if (!XMLElement.nodeValuesAreEqual(attr, otherAttr = otherAttrs.getNamedItem(attr.getNodeName()))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private static boolean nodeValuesAreEqual(Node node, Node otherNode) {
        String value = node.getNodeValue();
        String otherValue = otherNode.getNodeValue();
        return value != null && otherValue != null ? value.equals(otherValue) : value == null && otherValue == null;
    }
}

