/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************
 *
 **/
/**
  * Object object()
  * @type object
  * @super Object
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535859.aspx
*/

function object(){};
object.prototype= new Object();
/**
  * Property accessKey
  * @type String
  * @returns {String}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533062.aspx
*/

object.prototype.accessKey="";
/**
  * Property align
  * @type String
  * @returns {String}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533066.aspx
*/

object.prototype.align="";
/**
  * Property alt
  * @type String
  * @returns {String}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533073.aspx
*/

object.prototype.alt="";
/**
  * Property altHTML
  * @type String
  * @returns {String}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533074.aspx
*/

object.prototype.altHTML="";
/**
  * Property archive
  * @type String
  * @returns {String}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533081.aspx
*/

object.prototype.archive="";
/**
  * Property BaseHref
  * @type String
  * @returns {String}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533501.aspx
*/

object.prototype.BaseHref="";
/**
  * Property href
  * @type String
  * @returns {String}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533865.aspx
*/

object.prototype.href="";
/**
  * Property base
  * @type base
  * @returns {base}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535191.aspx
*/

object.prototype.base= new base();
/**
  * Property border
  * @type Object
  * @returns {Object}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533534.aspx
*/

object.prototype.border=new Object();
/**
  * Property canHaveChildren
  * @type Boolean
  * @returns {Boolean}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533546.aspx
*/

object.prototype.canHaveChildren=false;
/**
  * Property canHaveHTML
  * @type Boolean
  * @returns {Boolean}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537836.aspx
*/

object.prototype.canHaveHTML=false;
/**
  * Property classid
  * @type String
  * @returns {String}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533559.aspx
*/

object.prototype.classid="";
/**
  * Property className
  * @type String
  * @returns {String}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533560.aspx
*/

object.prototype.className="";
/**
  * Property clientHeight
  * @type Number
  * @returns {Number}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533563.aspx
*/

object.prototype.clientHeight=0;
/**
  * Property clientLeft
  * @type Number
  * @returns {Number}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533564.aspx
*/

object.prototype.clientLeft=0;
/**
  * Property offsetLeft
  * @type Number
  * @returns {Number}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534200.aspx
*/

object.prototype.offsetLeft=0;
/**
  * Property clientTop
  * @type Number
  * @returns {Number}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533565.aspx
*/

object.prototype.clientTop=0;
/**
  * Property offsetTop
  * @type Number
  * @returns {Number}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534303.aspx
*/

object.prototype.offsetTop=0;
/**
  * Property clientWidth
  * @type Number
  * @returns {Number}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533566.aspx
*/

object.prototype.clientWidth=0;
/**
  * Property code
  * @type String
  * @returns {String}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533575.aspx
*/

object.prototype.code="";
/**
  * Property codeBase
  * @type String
  * @returns {String}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533576.aspx
*/

object.prototype.codeBase="";
/**
  * Property codeType
  * @type String
  * @returns {String}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533577.aspx
*/

object.prototype.codeType="";
/**
  * Property data
  * @type String
  * @returns {String}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533702.aspx
*/

object.prototype.data="";
/**
  * Property declare
  * @type Boolean
  * @returns {Boolean}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533713.aspx
*/

object.prototype.declare=false;
/**
  * Property dir
  * @type String
  * @returns {String}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533728.aspx
*/

object.prototype.dir="";
/**
  * Property form
  * @type Object
  * @returns {Object}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533768.aspx
*/

object.prototype.form=new Object();
/**
  * Property height
  * @type Object
  * @returns {Object}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533781.aspx
*/

object.prototype.height=new Object();
/**
  * Property hideFocus
  * @type Boolean
  * @returns {Boolean}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533783.aspx
*/

object.prototype.hideFocus=false;
/**
  * Property hspace
  * @type Number
  * @returns {Number}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533868.aspx
*/

object.prototype.hspace=0;
/**
  * Property id
  * @type String
  * @returns {String}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533880.aspx
*/

object.prototype.id="";
/**
  * Property isContentEditable
  * @type Boolean
  * @returns {Boolean}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537838.aspx
*/

object.prototype.isContentEditable=false;
/**
  * Property isDisabled
  * @type Boolean
  * @returns {Boolean}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533902.aspx
*/

object.prototype.isDisabled=false;
/**
  * Property isMultiLine
  * @type Boolean
  * @returns {Boolean}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537839.aspx
*/

object.prototype.isMultiLine=false;
/**
  * Property isTextEdit
  * @type Boolean
  * @returns {Boolean}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533920.aspx
*/

object.prototype.isTextEdit=false;
/**
  * Property TextRange
  * @type TextRange
  * @returns {TextRange}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535872.aspx
*/

object.prototype.TextRange= new TextRange();
/**
  * Property lang
  * @type String
  * @returns {String}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533935.aspx
*/

object.prototype.lang="";
/**
  * Property language
  * @type String
  * @returns {String}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533940.aspx
*/

object.prototype.language="";
/**
  * Property name
  * @type String
  * @returns {String}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534184.aspx
*/

object.prototype.name="";
/**
  * Property nextSibling
  * @type Object
  * @returns {Object}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534189.aspx
*/

object.prototype.nextSibling=new Object();
/**
  * Property nodeName
  * @type String
  * @returns {String}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534190.aspx
*/

object.prototype.nodeName="";
/**
  * Property nodeType
  * @type Number
  * @returns {Number}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534191.aspx
*/

object.prototype.nodeType=0;
/**
  * Property nodeValue
  * @type Object
  * @returns {Object}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534192.aspx
*/

object.prototype.nodeValue=new Object();
/**
  * Property object
  * @type Object
  * @returns {Object}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534197.aspx
*/

object.prototype.object=new Object();
/**
  * Property offsetHeight
  * @type Number
  * @returns {Number}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534199.aspx
*/

object.prototype.offsetHeight=0;
/**
  * Property offsetParent
  * @type Object
  * @returns {Object}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534302.aspx
*/

object.prototype.offsetParent=new Object();
/**
  * Property offsetWidth
  * @type Number
  * @returns {Number}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534304.aspx
*/

object.prototype.offsetWidth=0;
/**
  * Property outerHTML
  * @type String
  * @returns {String}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534310.aspx
*/

object.prototype.outerHTML="";
/**
  * Property outerText
  * @type String
  * @returns {String}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534311.aspx
*/

object.prototype.outerText="";
/**
  * Property parentElement
  * @type Object
  * @returns {Object}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534327.aspx
*/

object.prototype.parentElement=new Object();
/**
  * Property parentNode
  * @type Object
  * @returns {Object}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534328.aspx
*/

object.prototype.parentNode=new Object();
/**
  * Property parentTextEdit
  * @type Object
  * @returns {Object}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534330.aspx
*/

object.prototype.parentTextEdit=new Object();
/**
  * Property previousSibling
  * @type Object
  * @returns {Object}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534350.aspx
*/

object.prototype.previousSibling=new Object();
/**
  * Property readyState
  * @type Number
  * @returns {Number}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534360.aspx
*/

object.prototype.readyState=0;
/**
  * Property recordset
  * @type recordset
  * @returns {recordset}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534364.aspx
*/

object.prototype.recordset= new recordset();
/**
  * Property scopeName
  * @type String
  * @returns {String}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534388.aspx
*/

object.prototype.scopeName="";
/**
  * Property scrollHeight
  * @type Object
  * @returns {Object}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534615.aspx
*/

object.prototype.scrollHeight=new Object();
/**
  * Property scrollLeft
  * @type Number
  * @returns {Number}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534617.aspx
*/

object.prototype.scrollLeft=0;
/**
  * Property scrollTop
  * @type Number
  * @returns {Number}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534618.aspx
*/

object.prototype.scrollTop=0;
/**
  * Property scrollWidth
  * @type Object
  * @returns {Object}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534619.aspx
*/

object.prototype.scrollWidth=new Object();
/**
  * Property sourceIndex
  * @type Number
  * @returns {Number}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534635.aspx
*/

object.prototype.sourceIndex=0;
/**
  * Property all
  * @type all
  * @returns {all}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537434.aspx
*/

object.prototype.all= new all();
/**
  * Property standby
  * @type String
  * @returns {String}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534644.aspx
*/

object.prototype.standby="";
/**
  * Property tabIndex
  * @type Number
  * @returns {Number}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534654.aspx
*/

object.prototype.tabIndex=0;
/**
  * Property tagName
  * @type String
  * @returns {String}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534657.aspx
*/

object.prototype.tagName="";
/**
  * Property tagUrn
  * @type String
  * @returns {String}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534658.aspx
*/

object.prototype.tagUrn="";
/**
  * Property title
  * @type String
  * @returns {String}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534683.aspx
*/

object.prototype.title="";
/**
  * Property type
  * @type String
  * @returns {String}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534698.aspx
*/

object.prototype.type="";
/**
  * Property uniqueID
  * @type String
  * @returns {String}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534704.aspx
*/

object.prototype.uniqueID="";
/**
  * Property useMap
  * @type String
  * @returns {String}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534711.aspx
*/

object.prototype.useMap="";
/**
  * Property vspace
  * @type Number
  * @returns {Number}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535141.aspx
*/

object.prototype.vspace=0;
/**
  * Property width
  * @type Object
  * @returns {Object}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535147.aspx
*/

object.prototype.width=new Object();
/**
  * function addBehavior(sUrl)
  * @param {String} sUrl
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535922.aspx
*/

object.prototype.addBehavior=function(sUrl){};
/**
  * function applyElement(oNewElement)
  * @param {String} oNewElement
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536341.aspx
*/

object.prototype.applyElement=function(oNewElement){};
/**
  * function attachEvent(sEvent,fpNotify)
  * @param {String} sEvent
  * @param {Boolean} fpNotify
  * @type Boolean
  * @returns {Boolean}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536343.aspx
*/

object.prototype.attachEvent=function(sEvent,fpNotify){};
/**
  * function blur()
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536347.aspx
*/

object.prototype.blur=function(){};
/**
  * Property onblur
  * @type onblur
  * @returns {onblur}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536909.aspx
*/

object.prototype.onblur= new onblur();
/**
  * function clearAttributes()
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536350.aspx
*/

object.prototype.clearAttributes=function(){};
/**
  * function click()
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536363.aspx
*/

object.prototype.click=function(){};
/**
  * Property onclick
  * @type onclick
  * @returns {onclick}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536913.aspx
*/

object.prototype.onclick= new onclick();
/**
  * function cloneNode(bCloneChildren)
  * @param {Boolean} bCloneChildren
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536365.aspx
*/

object.prototype.cloneNode=function(bCloneChildren){};
/**
  * function componentFromPoint(iCoordX,iCoordY)
  * @param {Number} iCoordX
  * @param {Number} iCoordY
  * @type String
  * @returns {String}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536375.aspx
*/

object.prototype.componentFromPoint=function(iCoordX,iCoordY){};
/**
  * function detachEvent(sEvent,fpNotify)
  * @param {String} sEvent
  * @param {attachEvent} fpNotify
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536411.aspx
*/

object.prototype.detachEvent=function(sEvent,fpNotify){};
/**
  * function dragDrop()
  * @type Boolean
  * @returns {Boolean}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536415.aspx
*/

object.prototype.dragDrop=function(){};
/**
  * function fireEvent(sEvent,oEventObject)
  * @param {String} sEvent
  * @param {event} oEventObject
  * @type Boolean
  * @returns {Boolean}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536423.aspx
*/

object.prototype.fireEvent=function(sEvent,oEventObject){};
/**
  * function focus()
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536425.aspx
*/

object.prototype.focus=function(){};
/**
  * Property onfocus
  * @type onfocus
  * @returns {onfocus}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536934.aspx
*/

object.prototype.onfocus= new onfocus();
/**
  * function getAdjacentText(sWhere)
  * @param {String} sWhere
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536427.aspx
*/

object.prototype.getAdjacentText=function(sWhere){};
/**
  * function getAttribute(sAttrName,iFlags,sAttrName)
  * @param {String} sAttrName
  * @param {Number} iFlags
  * @param {getAttribute} sAttrName
  * @type Object
  * @returns {Object}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536429.aspx
*/

object.prototype.getAttribute=function(sAttrName,iFlags,sAttrName){};
/**
  * function getAttributeNode(sName)
  * @param {String} sName
  * @type attribute
  * @returns {attribute}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536430.aspx
*/

object.prototype.getAttributeNode=function(sName){};
/**
  * Property attribute
  * @type attribute
  * @returns {attribute}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535187.aspx
*/

object.prototype.attribute= new attribute();
/**
  * Property name
  * @type String
  * @returns {String}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534184.aspx
*/

object.prototype.name="";
/**
  * function getBoundingClientRect()
  * @type TextRectangle
  * @returns {TextRectangle}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536433.aspx
*/

object.prototype.getBoundingClientRect=function(){};
/**
  * Property TextRectangle
  * @type TextRectangle
  * @returns {TextRectangle}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535906.aspx
*/

object.prototype.TextRectangle= new TextRectangle();
/**
  * function getClientRects()
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536435.aspx
*/

object.prototype.getClientRects=function(){};
/**
  * function getExpression(sPropertyName)
  * @param {String} sPropertyName
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/aa358797.aspx
*/

object.prototype.getExpression=function(sPropertyName){};
/**
  * function insertAdjacentElement(sWhere,oElement)
  * @param {String} sWhere
  * @param {insertAdjacentElement} oElement
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536451.aspx
*/

object.prototype.insertAdjacentElement=function(sWhere,oElement){};
/**
  * function insertBefore(oNewNode,oChildNode)
  * @param {Object} oNewNode
  * @param {Object} oChildNode
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536454.aspx
*/

object.prototype.insertBefore=function(oNewNode,oChildNode){};
/**
  * function mergeAttributes(oSource,bPreserve)
  * @param {Object} oSource
  * @param {Boolean} bPreserve
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536614.aspx
*/

object.prototype.mergeAttributes=function(oSource,bPreserve){};
/**
  * function namedRecordset(sQualifier,sSubChapter)
  * @param {String} sQualifier
  * @param {String} sSubChapter
  * @type Object
  * @returns {Object}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536636.aspx
*/

object.prototype.namedRecordset=function(sQualifier,sSubChapter){};
/**
  * function normalize()
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536646.aspx
*/

object.prototype.normalize=function(){};
/**
  * Property TextNode
  * @type TextNode
  * @returns {TextNode}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535905.aspx
*/

object.prototype.TextNode= new TextNode();
/**
  * function releaseCapture()
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536689.aspx
*/

object.prototype.releaseCapture=function(){};
/**
  * function removeAttribute(sName,iCaseSensitive)
  * @param {String} sName
  * @param {Number} iCaseSensitive
  * @type Boolean
  * @returns {Boolean}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536696.aspx
*/

object.prototype.removeAttribute=function(sName,iCaseSensitive){};
/**
  * function removeAttributeNode(oSrcAttribute)
  * @param {attribute} oSrcAttribute
  * @type attribute
  * @returns {attribute}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536698.aspx
*/

object.prototype.removeAttributeNode=function(oSrcAttribute){};
/**
  * function removeBehavior(iID)
  * @param {Number} iID
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536700.aspx
*/

object.prototype.removeBehavior=function(iID){};
/**
  * function removeExpression(sPropertyName)
  * @param {String} sPropertyName
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/aa358798.aspx
*/

object.prototype.removeExpression=function(sPropertyName){};
/**
  * function removeNode(bRemoveChildren)
  * @param {Boolean} bRemoveChildren
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536708.aspx
*/

object.prototype.removeNode=function(bRemoveChildren){};
/**
  * function replaceAdjacentText(sWhere,sReplaceText)
  * @param {String} sWhere
  * @param {String} sReplaceText
  * @type String
  * @returns {String}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536714.aspx
*/

object.prototype.replaceAdjacentText=function(sWhere,sReplaceText){};
/**
  * function replaceNode(oNewNode)
  * @param {Object} oNewNode
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536719.aspx
*/

object.prototype.replaceNode=function(oNewNode){};
/**
  * function scrollIntoView(bAlignToTop)
  * @param {Boolean} bAlignToTop
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536730.aspx
*/

object.prototype.scrollIntoView=function(bAlignToTop){};
/**
  * function setActive()
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536738.aspx
*/

object.prototype.setActive=function(){};
/**
  * function setAttribute(sName,vValue)
  * @param {String} sName
  * @param {Number} vValue
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536739.aspx
*/

object.prototype.setAttribute=function(sName,vValue){};
/**
  * function setAttributeNode(oSrcAttribute)
  * @param {attribute} oSrcAttribute
  * @type attribute
  * @returns {attribute}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536741.aspx
*/

object.prototype.setAttributeNode=function(oSrcAttribute){};
/**
  * function setCapture(bContainerCapture)
  * @param {Boolean} bContainerCapture
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536742.aspx
*/

object.prototype.setCapture=function(bContainerCapture){};
/**
  * function setExpression(sPropertyName,sExpression,sLanguage)
  * @param {String} sPropertyName
  * @param {String} sExpression
  * @param {String} sLanguage
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms531196.aspx
*/

object.prototype.setExpression=function(sPropertyName,sExpression,sLanguage){};
/**
  * function swapNode(oNode)
  * @param {Object} oNode
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536774.aspx
*/

object.prototype.swapNode=function(oNode){};
/**
  * Property onactivate
  * @type onactivate
  * @returns {onactivate}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536787.aspx
*/

object.prototype.onactivate= new onactivate();
/**
  * Property activeElement
  * @type Object
  * @returns {Object}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533065.aspx
*/

object.prototype.activeElement=new Object();
/**
  * Property onbeforedeactivate
  * @type onbeforedeactivate
  * @returns {onbeforedeactivate}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536903.aspx
*/

object.prototype.onbeforedeactivate= new onbeforedeactivate();
/**
  * Property onbeforeeditfocus
  * @type onbeforeeditfocus
  * @returns {onbeforeeditfocus}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536904.aspx
*/

object.prototype.onbeforeeditfocus= new onbeforeeditfocus();
/**
  * Property onblur
  * @type onblur
  * @returns {onblur}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536909.aspx
*/

object.prototype.onblur= new onblur();
/**
  * Property oncellchange
  * @type oncellchange
  * @returns {oncellchange}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536911.aspx
*/

object.prototype.oncellchange= new oncellchange();
/**
  * Property onclick
  * @type onclick
  * @returns {onclick}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536913.aspx
*/

object.prototype.onclick= new onclick();
/**
  * Property oncontrolselect
  * @type oncontrolselect
  * @returns {oncontrolselect}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537844.aspx
*/

object.prototype.oncontrolselect= new oncontrolselect();
/**
  * Property ondataavailable
  * @type ondataavailable
  * @returns {ondataavailable}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536918.aspx
*/

object.prototype.ondataavailable= new ondataavailable();
/**
  * Property ondatasetchanged
  * @type ondatasetchanged
  * @returns {ondatasetchanged}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536919.aspx
*/

object.prototype.ondatasetchanged= new ondatasetchanged();
/**
  * Property ondatasetcomplete
  * @type ondatasetcomplete
  * @returns {ondatasetcomplete}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536920.aspx
*/

object.prototype.ondatasetcomplete= new ondatasetcomplete();
/**
  * Property ondblclick
  * @type ondblclick
  * @returns {ondblclick}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536921.aspx
*/

object.prototype.ondblclick= new ondblclick();
/**
  * Property ondeactivate
  * @type ondeactivate
  * @returns {ondeactivate}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536922.aspx
*/

object.prototype.ondeactivate= new ondeactivate();
/**
  * Property ondrag
  * @type ondrag
  * @returns {ondrag}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536923.aspx
*/

object.prototype.ondrag= new ondrag();
/**
  * Property ondragend
  * @type ondragend
  * @returns {ondragend}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536924.aspx
*/

object.prototype.ondragend= new ondragend();
/**
  * Property ondragenter
  * @type ondragenter
  * @returns {ondragenter}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536925.aspx
*/

object.prototype.ondragenter= new ondragenter();
/**
  * Property ondragleave
  * @type ondragleave
  * @returns {ondragleave}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536926.aspx
*/

object.prototype.ondragleave= new ondragleave();
/**
  * Property ondragover
  * @type ondragover
  * @returns {ondragover}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536927.aspx
*/

object.prototype.ondragover= new ondragover();
/**
  * Property ondragstart
  * @type ondragstart
  * @returns {ondragstart}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536928.aspx
*/

object.prototype.ondragstart= new ondragstart();
/**
  * Property ondrop
  * @type ondrop
  * @returns {ondrop}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536929.aspx
*/

object.prototype.ondrop= new ondrop();
/**
  * Property onerror
  * @type onerror
  * @returns {onerror}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536930.aspx
*/

object.prototype.onerror= new onerror();
/**
  * Property onfocus
  * @type onfocus
  * @returns {onfocus}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536934.aspx
*/

object.prototype.onfocus= new onfocus();
/**
  * Property onkeydown
  * @type onkeydown
  * @returns {onkeydown}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536938.aspx
*/

object.prototype.onkeydown= new onkeydown();
/**
  * Property onkeypress
  * @type onkeypress
  * @returns {onkeypress}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536939.aspx
*/

object.prototype.onkeypress= new onkeypress();
/**
  * Property onkeyup
  * @type onkeyup
  * @returns {onkeyup}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536940.aspx
*/

object.prototype.onkeyup= new onkeyup();
/**
  * Property onlosecapture
  * @type onlosecapture
  * @returns {onlosecapture}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536943.aspx
*/

object.prototype.onlosecapture= new onlosecapture();
/**
  * Property onmove
  * @type onmove
  * @returns {onmove}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536952.aspx
*/

object.prototype.onmove= new onmove();
/**
  * Property onmoveend
  * @type onmoveend
  * @returns {onmoveend}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536953.aspx
*/

object.prototype.onmoveend= new onmoveend();
/**
  * Property onmovestart
  * @type onmovestart
  * @returns {onmovestart}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536954.aspx
*/

object.prototype.onmovestart= new onmovestart();
/**
  * Property onpropertychange
  * @type onpropertychange
  * @returns {onpropertychange}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536956.aspx
*/

object.prototype.onpropertychange= new onpropertychange();
/**
  * Property onreadystatechange
  * @type onreadystatechange
  * @returns {onreadystatechange}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536957.aspx
*/

object.prototype.onreadystatechange= new onreadystatechange();
/**
  * Property onresize
  * @type onresize
  * @returns {onresize}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536959.aspx
*/

object.prototype.onresize= new onresize();
/**
  * Property onresizeend
  * @type onresizeend
  * @returns {onresizeend}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536960.aspx
*/

object.prototype.onresizeend= new onresizeend();
/**
  * Property onresizestart
  * @type onresizestart
  * @returns {onresizestart}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536961.aspx
*/

object.prototype.onresizestart= new onresizestart();
/**
  * Property onrowenter
  * @type onrowenter
  * @returns {onrowenter}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536962.aspx
*/

object.prototype.onrowenter= new onrowenter();
/**
  * Property onrowexit
  * @type onrowexit
  * @returns {onrowexit}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536963.aspx
*/

object.prototype.onrowexit= new onrowexit();
/**
  * Property onrowsdelete
  * @type onrowsdelete
  * @returns {onrowsdelete}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536964.aspx
*/

object.prototype.onrowsdelete= new onrowsdelete();
/**
  * Property onrowsinserted
  * @type onrowsinserted
  * @returns {onrowsinserted}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536965.aspx
*/

object.prototype.onrowsinserted= new onrowsinserted();
/**
  * Property onscroll
  * @type onscroll
  * @returns {onscroll}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536966.aspx
*/

object.prototype.onscroll= new onscroll();
/**
  * Property onselectstart
  * @type onselectstart
  * @returns {onselectstart}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536969.aspx
*/

object.prototype.onselectstart= new onselectstart();
/**
  * Property all
  * @type all
  * @returns {all}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537434.aspx
*/

object.prototype.all= new all();
/**
  * Property attributes
  * @type attributes
  * @returns {attributes}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537438.aspx
*/

object.prototype.attributes= new attributes();
/**
  * Property behaviorUrns
  * @type behaviorUrns
  * @returns {behaviorUrns}
  * @memberOf object
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537439.aspx
*/

object.prototype.behaviorUrns= new behaviorUrns();
