/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.rose.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.importer.rose.RoseImporterPlugin;
import org.eclipse.emf.importer.rose.builder.RoseUtil;
import org.eclipse.emf.importer.rose.builder.RoseVisitor;
import org.eclipse.emf.importer.rose.builder.TableObject;
import org.eclipse.emf.importer.rose.parser.RoseNode;
import org.eclipse.emf.importer.rose.parser.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoseEcoreBuilder
implements RoseVisitor {
    public boolean noQualify = false;
    public boolean unsettablePrimitive = "true".equals(System.getProperty("EMF_UNSETTABLE_PRIMITIVE"));
    protected RoseUtil roseUtil;
    protected Set<EModelElement> bounded = new HashSet<EModelElement>();
    protected Map<EStructuralFeature, String> eStructuralFeatureToXMLNamespaceMap = new HashMap<EStructuralFeature, String>();
    protected List<EStructuralFeature> eStructuralFeatures = new BasicEList.FastCompare();
    protected Map<EEnum, String> eEnums = new HashMap<EEnum, String>();
    protected Map<String, Object> idToParentMap = new HashMap<String, Object>();
    protected EReference ref1 = null;
    protected EReference ref2 = null;
    protected RoseNode role1 = null;
    protected RoseNode role2 = null;
    protected EGenericType eGenericType1;
    protected EGenericType eGenericType2;
    protected Set<EAttribute> attributesToConvert = new HashSet<EAttribute>();
    protected Map<EModelElement, RoseNode> eModelElementToRoseNodeMap = new HashMap<EModelElement, RoseNode>();
    protected static final Pattern ANNOTATION_PATTERN = Pattern.compile("\\G\\s*((?>\\\\.|\\S)+)((?:\\s+(?>\\\\.|\\S)+\\s*+=\\s*(['\"])((?>\\\\.|.)*?)\\3)*)");
    protected static final Pattern ANNOTATION_DETAIL_PATTERN = Pattern.compile("\\s+((?>\\\\.|\\S)+)\\s*+=\\s*((['\"])((?>\\\\.|.)*?)\\3)");
    protected static Comparator<Object> eClassComparator = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            int count2;
            EClass c1 = (EClass)(o1 instanceof EGenericType ? ((EGenericType)o1).getEClassifier() : o1);
            EClass c2 = (EClass)(o2 instanceof EGenericType ? ((EGenericType)o2).getEClassifier() : o2);
            int count1 = c1.getEAllAttributes().size() + c1.getEAllReferences().size();
            if (count1 < (count2 = c2.getEAllAttributes().size() + c2.getEAllReferences().size())) {
                return 1;
            }
            if (count1 > count2) {
                return -1;
            }
            return c1.getName().compareTo(c2.getName());
        }
    };
    protected Comparator<EStructuralFeature> eStructuralFeatureComparator = new Comparator<EStructuralFeature>(){

        @Override
        public int compare(EStructuralFeature o1, EStructuralFeature o2) {
            return RoseEcoreBuilder.this.eStructuralFeatures.indexOf(o1) - RoseEcoreBuilder.this.eStructuralFeatures.indexOf(o2);
        }
    };

    public RoseEcoreBuilder(RoseUtil roseUtil) {
        this.roseUtil = roseUtil;
    }

    @Override
    public void visitList(RoseNode roseNode) {
    }

    @Override
    public void visitObject(RoseNode roseNode) {
        String roseNodeValue = roseNode.getValue();
        String objectKey = roseNode.getKey();
        String objectType = Util.getType(roseNodeValue);
        String objectName = Util.getName(roseNodeValue);
        RoseNode currentNode = roseNode;
        Object parent = currentNode.getNode();
        while (parent == null) {
            currentNode = currentNode.getParent();
            parent = currentNode.getNode();
        }
        this.visitObject(roseNode, roseNodeValue, objectKey, objectType, objectName, parent);
    }

    protected void visitObject(RoseNode roseNode, String roseNodeValue, String objectKey, String objectType, String objectName, Object parent) {
        if (objectKey.equals("") && objectType.equals("Class_Category")) {
            this.visitClassCategory(roseNode, roseNodeValue, objectKey, objectName, parent);
        } else if (objectType.equals("Class")) {
            this.visitClass(roseNode, roseNodeValue, objectKey, objectName, parent);
        } else if (objectType.equals("Operation")) {
            this.visitOperation(roseNode, roseNodeValue, objectKey, objectName, parent);
        } else if (objectType.equals("Parameter")) {
            this.visitParameter(roseNode, roseNodeValue, objectKey, objectName, parent);
        } else if (objectType.equals("Inheritance_Relationship")) {
            this.visitInheritanceRelationship(roseNode, roseNodeValue, objectKey, objectName, parent);
        } else if (!(!objectType.equals("ClassAttribute") || roseNode.isDerived() && "reference".equals(roseNode.getStereotype()))) {
            this.visitClassattribute(roseNode, roseNodeValue, objectKey, objectName, parent);
        } else if (objectType.equals("Association")) {
            this.visitAssociation(roseNode, roseNodeValue, objectKey, objectName, parent);
        } else if (objectType.equals("Role") && !objectName.startsWith("/")) {
            this.visitRole(roseNode, roseNodeValue, objectKey, objectName, parent);
        }
    }

    protected void visitClassCategory(RoseNode roseNode, String roseNodeValue, String objectKey, String objectName, Object parent) {
        if (roseNode.isLoaded()) {
            String id = roseNode.getRoseId();
            if (this.idToParentMap.containsKey(id)) {
                parent = this.idToParentMap.get(id);
            }
            EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
            if (parent instanceof EPackage) {
                ((EPackage)parent).getESubpackages().add((Object)ePackage);
            } else if (parent instanceof EList) {
                EList list = (EList)parent;
                list.add((Object)ePackage);
            }
            this.setEPackageProperties(roseNode, ePackage, objectName.toLowerCase());
        } else {
            this.idToParentMap.put(roseNode.getRoseId(), parent);
        }
    }

    protected void visitClass(RoseNode roseNode, String roseNodeValue, String objectKey, String objectName, Object parent) {
        RoseNode stereoTypeNode;
        if (objectName == null || objectName.length() == 0) {
            String quid = roseNode.getRoseId();
            if (quid != null) {
                quid = quid.substring(1, quid.length() - 1);
            }
            objectName = "Unnamed" + quid;
            this.error(RoseImporterPlugin.INSTANCE.getString("_UI_UnnamedClass_message", new Object[]{objectName}));
        }
        if ((stereoTypeNode = roseNode.findNodeWithKey("stereotype")) != null) {
            String stereoTypeValue = stereoTypeNode.getValue();
            if ((stereoTypeValue = stereoTypeValue.substring(1, stereoTypeValue.length() - 1)).equals("Interface")) {
                EClass eClass = EcoreFactory.eINSTANCE.createEClass();
                String classifierName = roseNode.getClassifierName();
                if (classifierName == null || classifierName.length() == 0) {
                    classifierName = this.validName(this.upperCaseName(objectName));
                }
                eClass.setName(classifierName);
                roseNode.setNode(eClass);
                this.setEClassProperties(roseNode, eClass);
                eClass.setInterface(true);
                eClass.setAbstract(true);
                this.build(roseNode, parent, (ENamedElement)eClass);
            } else if (stereoTypeValue.equalsIgnoreCase("enumeration")) {
                EEnum eEnum = EcoreFactory.eINSTANCE.createEEnum();
                String classifierName = roseNode.getClassifierName();
                if (classifierName == null || classifierName.length() == 0) {
                    classifierName = this.validName(this.upperCaseName(objectName));
                }
                eEnum.setName(classifierName);
                roseNode.setNode(eEnum);
                this.setEEnumProperties(roseNode, eEnum);
                this.build(roseNode, parent, (ENamedElement)eEnum);
            } else if (stereoTypeValue.equalsIgnoreCase("datatype") || stereoTypeValue.equalsIgnoreCase("primitive")) {
                EDataType eDataType = EcoreFactory.eINSTANCE.createEDataType();
                String classifierName = roseNode.getClassifierName();
                if (classifierName == null || classifierName.length() == 0) {
                    classifierName = this.validName(this.upperCaseName(objectName));
                }
                eDataType.setName(classifierName);
                roseNode.setNode(eDataType);
                this.setEDataTypeProperties(roseNode, eDataType);
                this.build(roseNode, parent, (ENamedElement)eDataType);
                String uml2MOFCorbaType = roseNode.getUML2MOFCorbaType();
                if (uml2MOFCorbaType != null) {
                    int end;
                    int start = (uml2MOFCorbaType = uml2MOFCorbaType.trim()).indexOf("typedef ");
                    if (start != -1 && (end = (uml2MOFCorbaType = uml2MOFCorbaType.substring(8)).lastIndexOf(" ")) != -1) {
                        uml2MOFCorbaType = uml2MOFCorbaType.substring(0, end);
                    }
                    if (uml2MOFCorbaType != null && uml2MOFCorbaType.length() != 0) {
                        this.roseUtil.typeTable.put((EObject)eDataType, uml2MOFCorbaType);
                    }
                }
            } else if (stereoTypeValue.equalsIgnoreCase("javatype")) {
                int index;
                EDataType eDataType = EcoreFactory.eINSTANCE.createEDataType();
                String classifierName = roseNode.getClassifierName();
                if (classifierName == null || classifierName.length() == 0) {
                    index = objectName.lastIndexOf(".");
                    classifierName = this.validName(this.upperCaseName(index == -1 ? objectName : objectName.substring(index + 1)));
                }
                eDataType.setName(this.validName(this.upperCaseName((index = objectName.lastIndexOf(".")) == -1 ? objectName : objectName.substring(index + 1))));
                eDataType.setInstanceClassName(objectName);
                roseNode.setNode(eDataType);
                this.setEDataTypeProperties(roseNode, eDataType);
                this.build(roseNode, parent, (ENamedElement)eDataType);
            } else if (stereoTypeValue.equalsIgnoreCase("abstract")) {
                EClass eClass = EcoreFactory.eINSTANCE.createEClass();
                String classifierName = roseNode.getClassifierName();
                if (classifierName == null || classifierName.length() == 0) {
                    classifierName = this.validName(this.upperCaseName(objectName));
                }
                eClass.setName(classifierName);
                roseNode.setNode(eClass);
                this.setEClassProperties(roseNode, eClass);
                this.build(roseNode, parent, (ENamedElement)eClass);
            } else if (stereoTypeValue.equalsIgnoreCase("MapEntry")) {
                EClass eClass = EcoreFactory.eINSTANCE.createEClass();
                String classifierName = roseNode.getClassifierName();
                if (classifierName == null || classifierName.length() == 0) {
                    classifierName = this.validName(this.upperCaseName(objectName));
                }
                eClass.setName(classifierName);
                roseNode.setNode(eClass);
                this.setEClassProperties(roseNode, eClass);
                eClass.setInstanceClassName("java.util.Map$Entry");
                this.build(roseNode, parent, (ENamedElement)eClass);
            } else {
                this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_UnrecognizedStereotype_message", new Object[]{stereoTypeValue, objectName}));
                EClass eClass = EcoreFactory.eINSTANCE.createEClass();
                String classifierName = roseNode.getClassifierName();
                if (classifierName == null || classifierName.length() == 0) {
                    classifierName = this.validName(this.upperCaseName(objectName));
                }
                eClass.setName(classifierName);
                roseNode.setNode(eClass);
                this.setEClassProperties(roseNode, eClass);
                this.build(roseNode, parent, (ENamedElement)eClass);
            }
        } else {
            EClass eClass = EcoreFactory.eINSTANCE.createEClass();
            String classifierName = roseNode.getClassifierName();
            if (classifierName == null || classifierName.length() == 0) {
                classifierName = this.validName(this.upperCaseName(objectName));
            }
            eClass.setName(classifierName);
            roseNode.setNode(eClass);
            this.setEClassProperties(roseNode, eClass);
            this.build(roseNode, parent, (ENamedElement)eClass);
        }
    }

    protected void visitOperation(RoseNode roseNode, String roseNodeValue, String objectKey, String objectName, Object parent) {
        int index;
        String operationName;
        EOperation eOperation = EcoreFactory.eINSTANCE.createEOperation();
        String rawName = operationName = roseNode.getOperationName();
        if (operationName == null || operationName.length() == 0) {
            rawName = objectName;
            operationName = this.validName(objectName);
        }
        if ((index = rawName.lastIndexOf(">")) != -1) {
            if (rawName.startsWith("<")) {
                String templateParameters = rawName.substring(1, index);
                eOperation.getETypeParameters().addAll(this.parseTemplateParameters(templateParameters));
            }
            operationName = rawName.substring(index + 1).trim();
            if (roseNode.getOperationName() == null || roseNode.getOperationName().length() == 0) {
                operationName = this.validName(operationName);
            }
        }
        eOperation.setName(operationName);
        roseNode.setNode(eOperation);
        this.setResultType(roseNode, eOperation);
        this.setEOperationProperties(roseNode, eOperation);
        if (parent instanceof EClass) {
            ((EClass)parent).getEOperations().add((Object)eOperation);
        }
    }

    protected void visitParameter(RoseNode roseNode, String roseNodeValue, String objectKey, String objectName, Object parent) {
        EParameter eParameter = EcoreFactory.eINSTANCE.createEParameter();
        eParameter.setName(this.validName(objectName));
        roseNode.setNode(eParameter);
        if (parent instanceof EOperation) {
            ((EOperation)parent).getEParameters().add((Object)eParameter);
        }
        this.setEParameterProperties(roseNode, eParameter);
    }

    protected void visitInheritanceRelationship(RoseNode roseNode, String roseNodeValue, String objectKey, String objectName, Object parent) {
        List<String> superList;
        String quidu = roseNode.getRoseRefId();
        if (quidu != null && !quidu.equals("")) {
            quidu = quidu.substring(1, quidu.length() - 1);
        }
        if ((superList = this.roseUtil.superTable.get(parent)) == null) {
            superList = new ArrayList<String>();
            this.roseUtil.superTable.put(parent, superList);
        }
        superList.add(quidu);
        superList.add(roseNode.getStereotype());
    }

    protected void visitClassattribute(RoseNode roseNode, String roseNodeValue, String objectKey, String objectName, Object parent) {
        if (parent instanceof EEnum) {
            EEnumLiteral eEnumLiteral = ((EEnum)parent).getEEnumLiteral(objectName);
            if (eEnumLiteral == null) {
                eEnumLiteral = EcoreFactory.eINSTANCE.createEEnumLiteral();
                String literalName = roseNode.getAttributeName();
                if (literalName == null || literalName.length() == 0) {
                    literalName = this.validName(objectName);
                } else {
                    eEnumLiteral.setLiteral(objectName);
                }
                eEnumLiteral.setName(literalName);
                roseNode.setNode(eEnumLiteral);
                if (!this.setEEnumLiteralProperties(roseNode, eEnumLiteral)) {
                    if (((EEnum)parent).getELiterals() == null) {
                        eEnumLiteral.setValue(0);
                    } else {
                        eEnumLiteral.setValue(((EEnum)parent).getELiterals().size());
                    }
                }
                ((EEnum)parent).getELiterals().add((Object)eEnumLiteral);
            }
        } else if (parent instanceof EClassifier) {
            String stereoTypeValue = null;
            RoseNode stereoTypeNode = roseNode.findNodeWithKey("stereotype");
            if (stereoTypeNode != null) {
                stereoTypeValue = stereoTypeNode.getValue();
                stereoTypeValue = stereoTypeValue.substring(1, stereoTypeValue.length() - 1);
            }
            if ((parent instanceof EDataType || parent instanceof EClass) && "javaclass".equalsIgnoreCase(stereoTypeValue)) {
                this.roseUtil.typeTable.remove(parent);
                ((EClassifier)parent).setInstanceTypeName(objectName);
            } else if ((parent instanceof EDataType || parent instanceof EClass) && "parameter".equalsIgnoreCase(stereoTypeValue)) {
                String attributeName = roseNode.getAttributeName();
                if (attributeName == null || attributeName.length() == 0) {
                    attributeName = objectName;
                }
                ETypeParameter eTypeParameter = this.parseTemplateParameter(attributeName);
                roseNode.setNode(eTypeParameter);
                ((EClassifier)parent).getETypeParameters().add((Object)eTypeParameter);
            } else if (parent instanceof EClass) {
                EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
                String attributeName = roseNode.getAttributeName();
                if (attributeName == null || attributeName.length() == 0) {
                    attributeName = this.validName(objectName);
                }
                eAttribute.setName(attributeName);
                roseNode.setNode(eAttribute);
                ((EClass)parent).getEStructuralFeatures().add((Object)eAttribute);
                this.setEAttributeProperties(roseNode, eAttribute);
                if (eAttribute.getUpperBound() == 0) {
                    eAttribute.setUpperBound(1);
                }
                if (roseNode.getContainment() != null) {
                    this.eModelElementToRoseNodeMap.put((EModelElement)eAttribute, roseNode);
                }
                if ("reference".equals(stereoTypeValue)) {
                    this.attributesToConvert.add(eAttribute);
                }
            }
        }
    }

    protected void visitAssociation(RoseNode roseNode, String roseNodeValue, String objectKey, String objectName, Object parent) {
        this.ref1 = null;
        this.ref2 = null;
        this.role1 = null;
        this.role2 = null;
    }

    protected void visitRole(RoseNode roseNode, String roseNodeValue, String objectKey, String objectName, Object parent) {
        String referenceName;
        EReference ref = EcoreFactory.eINSTANCE.createEReference();
        ref.setUpperBound(0);
        String rawName = referenceName = roseNode.getReferenceName();
        if (referenceName == null || referenceName.length() == 0) {
            rawName = objectName;
            referenceName = this.validName(objectName);
        }
        EGenericType eGenericType = null;
        int index = rawName.indexOf("<");
        if (index != -1) {
            eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
            if (rawName.endsWith(">")) {
                String templateArguments = rawName.substring(index + 1, rawName.length() - 1);
                eGenericType.getETypeArguments().addAll(this.parseTemplateArguments(templateArguments));
            }
            ref.setEGenericType(eGenericType);
            referenceName = rawName.substring(0, index);
            if (roseNode.getReferenceName() == null || roseNode.getReferenceName().length() == 0) {
                referenceName = this.validName(referenceName);
            }
        }
        ref.setName(referenceName);
        roseNode.setNode(ref);
        this.setEReferenceProperties(roseNode, ref);
        if (this.ref1 == null) {
            this.ref1 = ref;
            this.eGenericType1 = eGenericType;
        } else if (this.ref2 == null) {
            this.ref2 = ref;
            this.eGenericType2 = eGenericType;
        }
        if (this.role1 == null) {
            this.role1 = roseNode;
        } else if (this.role2 == null) {
            this.role2 = roseNode;
        }
        if (this.ref1 != null && this.ref2 != null && this.role1 != null && this.role2 != null) {
            TableObject obj;
            String ref2Quidu;
            String ref1Quidu = this.role1.getRoseRefId();
            if (ref1Quidu != null && !ref1Quidu.equals("")) {
                ref1Quidu = ref1Quidu.substring(1, ref1Quidu.length() - 1);
            }
            if ((ref2Quidu = this.role2.getRoseRefId()) != null && !ref2Quidu.equals("")) {
                ref2Quidu = ref2Quidu.substring(1, ref2Quidu.length() - 1);
            }
            boolean ref1Navigable = this.role1.isNavigable();
            boolean ref2Navigable = this.role2.isNavigable();
            if (ref1Navigable) {
                this.ref2.setEOpposite(this.ref1);
                this.setEReferenceIsContainment(this.ref1, this.role1, this.role2);
                this.roseUtil.refTable.put(this.ref1, ref2Quidu);
                obj = (TableObject)this.roseUtil.quidTable.get(ref1Quidu);
                if (obj != null) {
                    this.roseUtil.typeTable.put((EObject)(this.eGenericType1 == null ? this.ref1 : this.eGenericType1), obj.getName());
                } else {
                    this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_UnresolvedTypeNameFor_message", new Object[]{this.role1.getRoseSupplier(), this.ref1.getName()}));
                    this.roseUtil.typeTable.put((EObject)(this.eGenericType1 == null ? this.ref1 : this.eGenericType1), "EObject");
                }
            }
            if (ref2Navigable) {
                this.ref1.setEOpposite(this.ref2);
                this.setEReferenceIsContainment(this.ref2, this.role2, this.role1);
                this.roseUtil.refTable.put(this.ref2, ref1Quidu);
                obj = (TableObject)this.roseUtil.quidTable.get(ref2Quidu);
                if (obj != null) {
                    this.roseUtil.typeTable.put((EObject)(this.eGenericType2 == null ? this.ref2 : this.eGenericType2), obj.getName());
                } else {
                    this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_UnresolvedTypeNameFor_message", new Object[]{this.role2.getRoseSupplier(), this.ref2.getName()}));
                    this.roseUtil.typeTable.put((EObject)(this.eGenericType2 == null ? this.ref2 : this.eGenericType2), "EObject");
                }
            }
        }
        if (ref.getUpperBound() == 0) {
            this.setEReferenceDefaultMultiplicity(ref);
        }
    }

    protected EList<EObject> getExtentFromTableObject(RoseNode roseNode) {
        TableObject obj;
        String quid = roseNode.getRoseId();
        if (quid != null) {
            quid = quid.substring(1, quid.length() - 1);
        }
        return (obj = (TableObject)this.roseUtil.quidTable.get(quid)) == null ? null : obj.getContainer().getExtent();
    }

    protected void setEReferenceIsContainment(EReference ref, RoseNode role1, RoseNode role2) {
        boolean isAggregate = role2.isAggregate();
        String containmentV = role1.getContainment();
        if (isAggregate && containmentV != null && containmentV.equalsIgnoreCase("by value")) {
            EReference opposite = ref.getEOpposite();
            if (opposite != null && opposite.getUpperBound() != 1) {
                if (this.bounded.contains(opposite)) {
                    this.error(RoseImporterPlugin.INSTANCE.getString("_UI_ContainerRelationUpperBound_message", new Object[]{ref.getName(), ref.getEOpposite().getName()}));
                }
                opposite.setUpperBound(1);
            }
            ref.setContainment(true);
        }
    }

    protected void setResultType(RoseNode roseNode, EOperation eOperation) {
        String quid = roseNode.getRoseRefId();
        if (quid != null && !quid.equals("")) {
            TableObject tableObj = (TableObject)this.roseUtil.quidTable.get(quid = quid.substring(1, quid.length() - 1));
            if (tableObj != null) {
                this.roseUtil.typeTable.put((EObject)eOperation, tableObj.getName());
            } else {
                this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_UnresolvedTypeIDFor_message", new Object[]{quid, eOperation.getName()}));
                this.roseUtil.typeTable.put((EObject)eOperation, "EString");
            }
        } else {
            String resultValue = this.getQualifiedTypeName((ETypedElement)eOperation, roseNode.getResult());
            if (resultValue != null && !resultValue.equalsIgnoreCase("void")) {
                if (!resultValue.equals("")) {
                    eOperation.setEGenericType(this.parseTemplateArgument(resultValue));
                } else {
                    this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_UnresolvedTypeNameFor_message", new Object[]{roseNode.getRoseSupplier(), eOperation.getName()}));
                    this.roseUtil.typeTable.put((EObject)eOperation, "EString");
                }
            }
        }
    }

    protected void setEModelElementProperties(RoseNode roseNode, EModelElement eModelElement) {
        String constraints;
        String documentation;
        String annotation = roseNode.getAnnotation();
        if (annotation != null) {
            Matcher matcher = ANNOTATION_PATTERN.matcher(annotation);
            while (matcher.find()) {
                EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                eAnnotation.setSource(CodeGenUtil.parseString((String)matcher.group(1)));
                Matcher detailMatcher = ANNOTATION_DETAIL_PATTERN.matcher(matcher.group(2));
                while (detailMatcher.find()) {
                    eAnnotation.getDetails().put((Object)CodeGenUtil.parseString((String)detailMatcher.group(1)), (Object)CodeGenUtil.parseString((String)detailMatcher.group(4)));
                }
                eModelElement.getEAnnotations().add((Object)eAnnotation);
            }
        }
        if ((documentation = roseNode.getDocumentation()) != null) {
            EcoreUtil.setDocumentation((EModelElement)eModelElement, (String)documentation);
        }
        if ((constraints = roseNode.getEcoreConstraints()) != null) {
            ArrayList<String> constraintList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(constraints);
            while (stringTokenizer.hasMoreTokens()) {
                String constraint = stringTokenizer.nextToken();
                constraintList.add(constraint);
            }
            EcoreUtil.setConstraints((EModelElement)eModelElement, constraintList);
        }
    }

    protected void setEPackageProperties(RoseNode roseNode, EPackage ePackage, String tentativeName) {
        String nsURI;
        String nsPrefix;
        roseNode.setNode(ePackage);
        this.setEModelElementProperties(roseNode, (EModelElement)ePackage);
        String packageName = roseNode.getPackageName();
        if (packageName == null || packageName.length() == 0) {
            packageName = this.validName(tentativeName);
        }
        ePackage.setName(packageName);
        String basePackage = roseNode.getBasePackage();
        String prefix = this.validName(this.upperCaseName(roseNode.getPrefix()));
        String string = nsPrefix = roseNode.getNsPrefix() == null || roseNode.getNsPrefix().length() == 0 ? this.roseUtil.packageNameToNSNameMap.get(packageName) : roseNode.getNsPrefix();
        if (nsPrefix == null || nsPrefix.length() == 0) {
            nsPrefix = packageName;
            EPackage eSuperPackage = ePackage.getESuperPackage();
            if (eSuperPackage != null) {
                nsPrefix = String.valueOf(eSuperPackage.getNsPrefix()) + "." + nsPrefix;
            } else if (basePackage != null && basePackage.length() != 0) {
                nsPrefix = String.valueOf(basePackage) + "." + nsPrefix;
            }
        }
        ePackage.setNsPrefix(nsPrefix);
        String string2 = nsURI = roseNode.getNsURI() == null || roseNode.getNsURI().length() == 0 ? this.roseUtil.packageNameToNSURIMap.get(packageName) : roseNode.getNsURI();
        if (nsURI == null || nsURI.length() == 0) {
            nsURI = this.noQualify ? String.valueOf(nsPrefix) + ".ecore" : "http:///" + nsPrefix.replace('.', '/') + ".ecore";
        }
        ePackage.setNsURI(nsURI);
        if (prefix != null && prefix.length() == 0) {
            prefix = null;
        }
        if (basePackage != null && basePackage.length() == 0) {
            basePackage = null;
        }
        if (prefix != null || basePackage != null) {
            ArrayList<String> information = new ArrayList<String>();
            information.add(basePackage);
            information.add(prefix);
            this.roseUtil.getEPackageToInformationMap().put(ePackage, information);
        }
    }

    protected void setEClassProperties(RoseNode roseNode, EClass eClass) {
        int xmlContentKind;
        this.setEModelElementProperties(roseNode, (EModelElement)eClass);
        String xmlName = roseNode.getXMLName();
        if (xmlName != null && xmlName.length() != 0) {
            ExtendedMetaData.INSTANCE.setName((EClassifier)eClass, xmlName);
        }
        if ((xmlContentKind = roseNode.getXMLContentKind()) != 0) {
            ExtendedMetaData.INSTANCE.setContentKind(eClass, xmlContentKind);
        }
        eClass.setAbstract(roseNode.isAbstract());
    }

    protected void setEDataTypeProperties(RoseNode roseNode, EDataType eDataType) {
        this.setEModelElementProperties(roseNode, (EModelElement)eDataType);
        String xmlName = roseNode.getXMLName();
        if (xmlName != null && xmlName.length() != 0) {
            ExtendedMetaData.INSTANCE.setName((EClassifier)eDataType, xmlName);
        }
        eDataType.setSerializable(!roseNode.isAbstract());
    }

    protected void setEEnumProperties(RoseNode roseNode, EEnum eEnum) {
        String value;
        this.setEModelElementProperties(roseNode, (EModelElement)eEnum);
        String xmlName = roseNode.getXMLName();
        if (xmlName != null && xmlName.length() != 0) {
            ExtendedMetaData.INSTANCE.setName((EClassifier)eEnum, xmlName);
        }
        if ((value = roseNode.getDocumentation()) != null && !value.equals("")) {
            this.eEnums.put(eEnum, value);
        }
    }

    protected void populateEEnumFromDocumentation(EEnum eEnum, String documentation) {
        EList eLiterals = eEnum.getELiterals();
        StringTokenizer stringTokenizer = new StringTokenizer(documentation, ", \n\r\t");
        while (stringTokenizer.hasMoreTokens()) {
            String literalV;
            String name = literalV = stringTokenizer.nextToken();
            String number = "";
            int ind = literalV.indexOf("=");
            if (ind != -1) {
                name = literalV.substring(0, ind);
                number = literalV.substring(ind + 1, literalV.length());
            }
            int numberValue = 0;
            if (!number.equals("")) {
                numberValue = Integer.parseInt(number);
            } else if (!eLiterals.isEmpty()) {
                numberValue = ((EEnumLiteral)eLiterals.get(eLiterals.size() - 1)).getValue() + 1;
            }
            if (name.equals("")) continue;
            EEnumLiteral lit = eEnum.getEEnumLiteral(name);
            if (lit == null) {
                lit = EcoreFactory.eINSTANCE.createEEnumLiteral();
                lit.setName(this.validName(name));
                lit.setValue(numberValue);
                eLiterals.add(lit);
                continue;
            }
            lit.setValue(numberValue);
        }
    }

    protected void setEOperationProperties(RoseNode roseNode, EOperation eOperation) {
        String stereotype;
        EGenericType eGenericType;
        String exceptions;
        this.setETypedElementProperties(roseNode, (ETypedElement)eOperation);
        eOperation.setOrdered(roseNode.isOrdered());
        eOperation.setUnique(roseNode.isUnique());
        String semantics = roseNode.getSemantics();
        if (semantics != null) {
            EAnnotation eAnnotation = eOperation.getEAnnotation("http://www.eclipse.org/emf/2002/GenModel");
            if (eAnnotation == null) {
                eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                eAnnotation.setSource("http://www.eclipse.org/emf/2002/GenModel");
                eOperation.getEAnnotations().add((Object)eAnnotation);
            }
            eAnnotation.getDetails().put((Object)"body", (Object)semantics);
        }
        if ((exceptions = roseNode.getExceptions()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(exceptions.trim(), ",");
            while (stringTokenizer.hasMoreTokens()) {
                String exception = stringTokenizer.nextToken().trim();
                if (exception.indexOf("[") != -1) {
                    exception = exception.substring(0, exception.indexOf("["));
                }
                if (exception != null && !exception.equals("")) {
                    eGenericType = this.parseTemplateArgument(exception);
                    eOperation.getEGenericExceptions().add((Object)eGenericType);
                    continue;
                }
                this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_UnresolvedTypeNameFor_message", new Object[]{roseNode.getRoseSupplier(), eOperation.getName()}));
            }
        }
        if ((stereotype = roseNode.getStereotype()) != null && "inv".equals(stereotype)) {
            eOperation.setEType((EClassifier)EcorePackage.Literals.EBOOLEAN);
            eOperation.getEParameters().clear();
            EParameter eParameter = EcoreFactory.eINSTANCE.createEParameter();
            eParameter.setName("diagnostics");
            eParameter.setEType((EClassifier)EcorePackage.Literals.EDIAGNOSTIC_CHAIN);
            eOperation.getEParameters().add((Object)eParameter);
            eParameter = EcoreFactory.eINSTANCE.createEParameter();
            eParameter.setName("context");
            eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
            eGenericType.setEClassifier((EClassifier)EcorePackage.Literals.EMAP);
            EGenericType eGenericKeyType = EcoreFactory.eINSTANCE.createEGenericType();
            eGenericKeyType.setEClassifier((EClassifier)EcorePackage.Literals.EJAVA_OBJECT);
            eGenericType.getETypeArguments().add((Object)eGenericKeyType);
            EGenericType eGenericValueType = EcoreFactory.eINSTANCE.createEGenericType();
            eGenericValueType.setEClassifier((EClassifier)EcorePackage.Literals.EJAVA_OBJECT);
            eGenericType.getETypeArguments().add((Object)eGenericValueType);
            eParameter.setEGenericType(eGenericType);
            eOperation.getEParameters().add((Object)eParameter);
        }
    }

    protected void setEAttributeProperties(RoseNode roseNode, EAttribute eAttribute) {
        this.eStructuralFeatures.add((EStructuralFeature)eAttribute);
        String quid = roseNode.getRoseRefId();
        if (quid != null && !quid.equals("")) {
            TableObject tableObj = (TableObject)this.roseUtil.quidTable.get(quid = quid.substring(1, quid.length() - 1));
            if (tableObj != null) {
                this.roseUtil.typeTable.put((EObject)eAttribute, tableObj.getName());
            } else {
                this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_UnresolvedTypeIDFor_message", new Object[]{quid, eAttribute.getName()}));
                this.roseUtil.typeTable.put((EObject)eAttribute, "String");
            }
        } else {
            String roseType = roseNode.getType();
            if (roseType == null || roseType.equals("")) {
                this.roseUtil.typeTable.put((EObject)eAttribute, "String");
                this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_AttributeDoesNotDefineItsType_message", new Object[]{eAttribute.getName()}));
            } else {
                eAttribute.setEGenericType(this.parseTemplateArgument(roseType));
            }
        }
        String initv = roseNode.getInitV();
        if (initv != null && initv.length() >= 2) {
            if (initv.charAt(0) == '\'' && initv.charAt(initv.length() - 1) == '\'') {
                try {
                    char i = CodeGenUtil.parseChar((String)initv.substring(1, initv.length() - 1));
                    initv = Integer.toString(i);
                }
                catch (IllegalArgumentException e) {
                    this.error(RoseImporterPlugin.INSTANCE.getString("_UI_InvalidDefaultValueForAttribute_message", new Object[]{eAttribute.getName()}));
                    initv = null;
                }
            } else if (initv.charAt(0) == '\"' && initv.charAt(initv.length() - 1) == '\"') {
                try {
                    initv = CodeGenUtil.parseString((String)initv.substring(1, initv.length() - 1));
                }
                catch (IllegalArgumentException e) {
                    this.error(RoseImporterPlugin.INSTANCE.getString("_UI_InvalidDefaultValueForAttribute_message", new Object[]{eAttribute.getName()}));
                    initv = null;
                }
            }
        }
        if (initv != null) {
            eAttribute.setDefaultValueLiteral(initv);
        }
        this.setEStructuralFeatureProperties(roseNode, (EStructuralFeature)eAttribute);
        eAttribute.setDerived(roseNode.isDerived());
        eAttribute.setTransient(roseNode.isTransient());
        eAttribute.setVolatile(roseNode.isVolatile());
        eAttribute.setChangeable(roseNode.isChangeable());
        eAttribute.setOrdered(roseNode.isOrdered());
        eAttribute.setUnique(roseNode.isUnique());
        eAttribute.setUnsettable(roseNode.isUnsettable());
        eAttribute.setID(roseNode.isID());
        this.setEStructuralFeatureVisibility(roseNode, (EStructuralFeature)eAttribute);
    }

    protected void setEReferenceProperties(RoseNode roseNode, EReference eReference) {
        this.eStructuralFeatures.add((EStructuralFeature)eReference);
        eReference.setDerived(roseNode.getParent().getParent().isDerived());
        this.setEStructuralFeatureProperties(roseNode, (EStructuralFeature)eReference);
        eReference.setTransient(roseNode.isTransient());
        eReference.setVolatile(roseNode.isVolatile());
        eReference.setChangeable(roseNode.isChangeable());
        eReference.setResolveProxies(roseNode.isResolveProxies());
        eReference.setUnsettable(roseNode.isUnsettable());
        eReference.setOrdered(roseNode.isOrdered());
        eReference.setUnique(roseNode.isUnique());
        this.setEStructuralFeatureVisibility(roseNode, (EStructuralFeature)eReference);
    }

    protected void setEStructuralFeatureProperties(RoseNode roseNode, EStructuralFeature eStructuralFeature) {
        String xmlNamespace;
        int xmlFeatureKind;
        this.setETypedElementProperties(roseNode, (ETypedElement)eStructuralFeature);
        String xmlName = roseNode.getXMLName();
        if (xmlName != null && xmlName.length() != 0) {
            ExtendedMetaData.INSTANCE.setName(eStructuralFeature, xmlName);
        }
        if ((xmlFeatureKind = roseNode.getXMLFeatureKind()) != 0) {
            ExtendedMetaData.INSTANCE.setFeatureKind(eStructuralFeature, xmlFeatureKind);
        }
        if ((xmlNamespace = roseNode.getXMLNamespace()) != null && xmlNamespace.length() != 0) {
            this.eStructuralFeatureToXMLNamespaceMap.put(eStructuralFeature, xmlNamespace);
        }
    }

    protected void setETypedElementProperties(RoseNode roseNode, ETypedElement eTypedElement) {
        String multiplicity;
        this.setEModelElementProperties(roseNode, (EModelElement)eTypedElement);
        String string = multiplicity = eTypedElement instanceof EReference ? roseNode.getRoleMultiplicity() : roseNode.getStereotype();
        if (multiplicity != null) {
            this.bounded.add((EModelElement)eTypedElement);
            if (multiplicity.length() > 0 && Character.isLetter(multiplicity.charAt(0)) && !"n".equalsIgnoreCase(multiplicity)) {
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(multiplicity, ". \n\r\t");
            switch (stringTokenizer.countTokens()) {
                case 1: {
                    String bound = stringTokenizer.nextToken();
                    if (bound.equals("*") || bound.equalsIgnoreCase("n")) {
                        eTypedElement.setUpperBound(-1);
                        break;
                    }
                    try {
                        int boundValue = Integer.parseInt(bound);
                        if (boundValue > 0) {
                            eTypedElement.setLowerBound(boundValue);
                            eTypedElement.setUpperBound(boundValue);
                            break;
                        }
                        this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_BadMultiplicityFor_message", new Object[]{multiplicity, eTypedElement.getName()}));
                    }
                    catch (NumberFormatException exception) {
                        this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_BadMultiplicityFor_message", new Object[]{multiplicity, eTypedElement.getName()}));
                    }
                    break;
                }
                case 2: {
                    String lowerBound = stringTokenizer.nextToken();
                    try {
                        int lowerBoundValue = Integer.parseInt(lowerBound);
                        if (lowerBoundValue >= 0) {
                            String upperBound = stringTokenizer.nextToken();
                            if (upperBound.equals("*") || upperBound.equalsIgnoreCase("n")) {
                                eTypedElement.setLowerBound(lowerBoundValue);
                                eTypedElement.setUpperBound(-1);
                                break;
                            }
                            int upperBoundValue = Integer.parseInt(upperBound);
                            if (upperBoundValue <= 0 || lowerBoundValue > upperBoundValue) {
                                this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_BadMultiplicityFor_message", new Object[]{multiplicity, eTypedElement.getName()}));
                                break;
                            }
                            eTypedElement.setLowerBound(lowerBoundValue);
                            eTypedElement.setUpperBound(upperBoundValue);
                            break;
                        }
                        this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_BadMultiplicityFor_message", new Object[]{multiplicity, eTypedElement.getName()}));
                    }
                    catch (NumberFormatException exception) {
                        this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_BadMultiplicityFor_message", new Object[]{multiplicity, eTypedElement.getName()}));
                    }
                    break;
                }
                default: {
                    this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_BadMultiplicityFor_message", new Object[]{multiplicity, eTypedElement.getName()}));
                }
            }
        }
    }

    protected void setEStructuralFeatureVisibility(RoseNode roseNode, EStructuralFeature eStructuralFeature) {
        switch (roseNode.getVisibility()) {
            case 1: {
                EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)0, (boolean)true);
                if (eStructuralFeature.isChangeable() && !eStructuralFeature.isMany()) {
                    EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)1, (boolean)true);
                }
                if (!eStructuralFeature.isUnsettable()) break;
                EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)2, (boolean)true);
                if (!eStructuralFeature.isChangeable()) break;
                EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)3, (boolean)true);
                break;
            }
            case 2: {
                if (eStructuralFeature.isMany()) {
                    this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_InvalidReadOnlyVisibility_message", new Object[]{eStructuralFeature.getName()}));
                } else if (eStructuralFeature.isChangeable()) {
                    EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)1, (boolean)true);
                }
                if (!eStructuralFeature.isUnsettable()) break;
                EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)2, (boolean)true);
                if (!eStructuralFeature.isChangeable()) break;
                EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)3, (boolean)true);
                break;
            }
            case 3: {
                if (!eStructuralFeature.isChangeable() && !eStructuralFeature.isMany()) {
                    this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_InvalidReadWriteVisibility_message", new Object[]{eStructuralFeature.getName()}));
                }
                if (!eStructuralFeature.isUnsettable()) break;
                EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)2, (boolean)true);
                if (!eStructuralFeature.isChangeable()) break;
                EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)3, (boolean)true);
                break;
            }
            case 4: {
                if (eStructuralFeature.isMany()) {
                    this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_InvalidReadOnlyVisibility_message", new Object[]{eStructuralFeature.getName()}));
                } else if (eStructuralFeature.isChangeable()) {
                    EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)1, (boolean)true);
                }
                if (!eStructuralFeature.isUnsettable()) {
                    this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_InvalidUnsettableVisibility_message", new Object[]{eStructuralFeature.getName()}));
                    break;
                }
                if (!eStructuralFeature.isChangeable()) break;
                EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)3, (boolean)true);
                break;
            }
            case 5: {
                if (!eStructuralFeature.isChangeable()) {
                    this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_InvalidReadWriteVisibility_message", new Object[]{eStructuralFeature.getName()}));
                }
                if (eStructuralFeature.isUnsettable()) break;
                this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_InvalidUnsettableVisibility_message", new Object[]{eStructuralFeature.getName()}));
                break;
            }
        }
    }

    protected boolean setEEnumLiteralProperties(RoseNode roseNode, EEnumLiteral eEnumLiteral) {
        this.setEModelElementProperties(roseNode, (EModelElement)eEnumLiteral);
        String value = roseNode.getInitV();
        if (value != null && !value.equals("")) {
            eEnumLiteral.setValue(Integer.parseInt(value));
            return true;
        }
        return false;
    }

    protected void setEParameterProperties(RoseNode roseNode, EParameter eParameter) {
        this.setEModelElementProperties(roseNode, (EModelElement)eParameter);
        String quid = roseNode.getRoseRefId();
        if (quid != null && !quid.equals("")) {
            TableObject tableObj = (TableObject)this.roseUtil.quidTable.get(quid = quid.substring(1, quid.length() - 1));
            if (tableObj != null) {
                this.roseUtil.typeTable.put((EObject)eParameter, tableObj.getName());
            } else {
                this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_UnresolvedTypeIDFor_message", new Object[]{quid, eParameter.getEOperation().getName()}));
                this.roseUtil.typeTable.put((EObject)eParameter, "EObject");
            }
        } else {
            String type = this.getQualifiedTypeName((ETypedElement)eParameter, roseNode.getType());
            if (type != null && !type.equals("")) {
                eParameter.setEGenericType(this.parseTemplateArgument(type));
            } else {
                this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_UnresolvedTypeNameFor_message", new Object[]{roseNode.getRoseSupplier(), eParameter.getEOperation().getName()}));
                this.roseUtil.typeTable.put((EObject)eParameter, "EObject");
            }
        }
    }

    protected void setEReferenceDefaultMultiplicity(EReference eReference) {
        if (eReference.getEOpposite() == null || !eReference.getEOpposite().isContainment()) {
            eReference.setLowerBound(0);
            eReference.setUpperBound(-1);
        }
    }

    public void setEEnums() {
        for (Map.Entry<EEnum, String> entry : this.eEnums.entrySet()) {
            EEnum eEnum = entry.getKey();
            if (!eEnum.getELiterals().isEmpty()) continue;
            this.populateEEnumFromDocumentation(eEnum, entry.getValue());
        }
    }

    public void setSuper() {
        HashMap<EClass, List<EGenericType>[]> superMap = new HashMap<EClass, List<EGenericType>[]>();
        for (Object subObject : this.roseUtil.superTable.keySet()) {
            if (subObject instanceof EClass) {
                EClass eClass = (EClass)subObject;
                ArrayList<EGenericType> extend = new ArrayList<EGenericType>();
                ArrayList<EGenericType> unspecified = new ArrayList<EGenericType>();
                ArrayList<EGenericType> mixin = new ArrayList<EGenericType>();
                ArrayList<EGenericType> nonClass = new ArrayList<EGenericType>();
                Iterator<String> j = this.roseUtil.superTable.get(eClass).iterator();
                while (j.hasNext()) {
                    String quid = j.next();
                    String stereotype = j.next();
                    TableObject tableObject = (TableObject)this.roseUtil.quidTable.get(quid);
                    if (tableObject == null) continue;
                    Object superObject = tableObject.getObject();
                    if (superObject instanceof EClass) {
                        int start;
                        EClass superClass = (EClass)superObject;
                        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
                        eGenericType.setEClassifier((EClassifier)superClass);
                        if (stereotype != null && (start = stereotype.indexOf("<")) != -1) {
                            if (stereotype.endsWith(">")) {
                                String templateArguments = stereotype.substring(start + 1, stereotype.length() - 1);
                                eGenericType.getETypeArguments().addAll(this.parseTemplateArguments(templateArguments));
                            }
                            stereotype = stereotype.substring(0, start);
                        }
                        if (!superClass.isInterface()) {
                            if ("extend".equals(stereotype)) {
                                extend.add(eGenericType);
                                continue;
                            }
                            if ("mixin".equals(stereotype)) {
                                mixin.add(eGenericType);
                                continue;
                            }
                            unspecified.add(eGenericType);
                            continue;
                        }
                        nonClass.add(eGenericType);
                        continue;
                    }
                    this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_CannotAddSuperLinkBetween_message", new Object[]{eClass.getName(), ((ENamedElement)superObject).getName()}));
                }
                if (extend.size() > 1) {
                    this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_CannotSpecifyMoreThanOneExtendFor_message", new Object[]{eClass.getName()}));
                }
                List[] lists = new List[]{extend, unspecified, mixin};
                superMap.put(eClass, lists);
                eClass.getEGenericSuperTypes().addAll(extend);
                eClass.getEGenericSuperTypes().addAll(unspecified);
                eClass.getEGenericSuperTypes().addAll(mixin);
                eClass.getEGenericSuperTypes().addAll(nonClass);
                continue;
            }
            this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_CannotAddSuperLinkInvolving_message", new Object[]{((ENamedElement)subObject).getName()}));
        }
        this.sortSuper(superMap);
    }

    protected void sortSuper(Map<EClass, List<EGenericType>[]> superMap) {
        for (Map.Entry<EClass, List<EGenericType>[]> entry : superMap.entrySet()) {
            EClass eClass = entry.getKey();
            List<EGenericType>[] collections = entry.getValue();
            Collections.sort(collections[0], eClassComparator);
            Collections.sort(collections[1], eClassComparator);
            Collections.sort(collections[2], eClassComparator);
            UniqueEList combined = new UniqueEList(collections[0]);
            combined.addAll(collections[1]);
            combined.addAll(collections[2]);
            EList eSuper = eClass.getEGenericSuperTypes();
            ListIterator ordered = combined.listIterator();
            while (ordered.hasNext()) {
                EGenericType eSuperItem = (EGenericType)ordered.next();
                eSuper.move(ordered.previousIndex(), (Object)eSuperItem);
            }
        }
    }

    protected List<ETypeParameter> parseTemplateParameters(String templateParameters) {
        ArrayList<ETypeParameter> result = new ArrayList<ETypeParameter>();
        int start = 0;
        int depth = 0;
        int i = 0;
        int length = templateParameters.length();
        while (i < length) {
            char character = templateParameters.charAt(i);
            switch (character) {
                case ' ': {
                    if (start != i) break;
                    ++start;
                    break;
                }
                case '<': {
                    ++depth;
                    break;
                }
                case '>': {
                    --depth;
                    break;
                }
                case ',': {
                    if (depth != 0) break;
                    result.add(this.parseTemplateParameter(templateParameters.substring(start, i).trim()));
                    start = i + 1;
                }
            }
            ++i;
        }
        result.add(this.parseTemplateParameter(templateParameters.substring(start).trim()));
        return result;
    }

    ETypeParameter parseTemplateParameter(String templateParameter) {
        ETypeParameter eTypeParameter = EcoreFactory.eINSTANCE.createETypeParameter();
        int index = templateParameter.indexOf(" extends ");
        if (index == -1) {
            eTypeParameter.setName(templateParameter);
        } else {
            eTypeParameter.setName(templateParameter.substring(0, index).trim());
            String bounds = templateParameter.substring(index + 9).trim();
            StringTokenizer stringTokenizer = new StringTokenizer(bounds, "&");
            while (stringTokenizer.hasMoreTokens()) {
                String templateArgument = stringTokenizer.nextToken().trim();
                eTypeParameter.getEBounds().add((Object)this.parseTemplateArgument(templateArgument));
            }
        }
        return eTypeParameter;
    }

    protected List<EGenericType> parseTemplateArguments(String templateArguments) {
        ArrayList<EGenericType> result = new ArrayList<EGenericType>();
        int start = 0;
        int depth = 0;
        int i = 0;
        int length = templateArguments.length();
        while (i < length) {
            char character = templateArguments.charAt(i);
            switch (character) {
                case ' ': {
                    if (start != i) break;
                    ++start;
                    break;
                }
                case '<': {
                    ++depth;
                    break;
                }
                case '>': {
                    --depth;
                    break;
                }
                case ',': {
                    if (depth != 0) break;
                    result.add(this.parseTemplateArgument(templateArguments.substring(start, i).trim()));
                    start = i + 1;
                }
            }
            ++i;
        }
        result.add(this.parseTemplateArgument(templateArguments.substring(start).trim()));
        return result;
    }

    EGenericType parseTemplateArgument(String templateArgument) {
        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        int index = 0;
        int length = templateArgument.length();
        if (index < length) {
            if (templateArgument.charAt(index) == '?') {
                ++index;
                while (index < length && Character.isWhitespace(templateArgument.charAt(index))) {
                    ++index;
                }
                if (templateArgument.indexOf("extends ") == index) {
                    eGenericType.setEUpperBound(this.parseTemplateArgument(templateArgument.substring(index + 8).trim()));
                } else if (templateArgument.indexOf("super ") == index) {
                    eGenericType.setELowerBound(this.parseTemplateArgument(templateArgument.substring(index + 6).trim()));
                }
            } else {
                String name;
                if ((index = templateArgument.indexOf(60, index)) == -1) {
                    name = templateArgument;
                } else {
                    name = templateArgument.substring(0, index);
                    eGenericType.getETypeArguments().addAll(this.parseTemplateArguments(templateArgument.substring(index + 1, length - 1)));
                }
                this.roseUtil.typeTable.put((EObject)eGenericType, name);
            }
        }
        return eGenericType;
    }

    public void setIDs(EObject parent, EObject child) {
        new EcoreSwitch<Object>(){

            public Object caseEPackage(EPackage ePackage) {
                return null;
            }

            public Object caseEClassifier(EClassifier eClassifier) {
                return null;
            }

            public Object caseEOperation(EOperation eOperation) {
                return null;
            }

            public Object caseEParameter(EParameter eParameter) {
                return null;
            }

            public Object caseEStructuralFeature(EStructuralFeature eStructuralFeature) {
                return null;
            }

            public Object caseEEnumLiteral(EEnumLiteral eEnumLiteral) {
                return null;
            }

            public Object defaultCase(EObject eObject) {
                for (EObject child : eObject.eContents()) {
                    RoseEcoreBuilder.this.setIDs(eObject, child);
                }
                return this;
            }
        }.doSwitch(child);
    }

    public void validate(EObject object) {
        new EcoreSwitch<Object>(){

            public Object caseEDataType(EDataType eDataType) {
                return RoseEcoreBuilder.this.validateEDataType(eDataType);
            }

            public Object caseEEnum(EEnum eEnum) {
                return RoseEcoreBuilder.this.validateEEnum(eEnum);
            }

            public Object caseEClass(EClass eClass) {
                return RoseEcoreBuilder.this.validateEClass(eClass);
            }

            public Object defaultCase(EObject eObject) {
                for (EObject child : eObject.eContents()) {
                    RoseEcoreBuilder.this.validate(child);
                }
                return this;
            }
        }.doSwitch(object);
    }

    protected Object validateEDataType(EDataType eDataType) {
        if (!(eDataType instanceof EEnum) && eDataType.getInstanceClassName() == null) {
            this.error(RoseImporterPlugin.INSTANCE.getString("_UI_DatatypeNotSetFor_message", new Object[]{eDataType.getName()}));
            eDataType.setInstanceClassName("java.lang.String");
        }
        return null;
    }

    protected Object validateEEnum(EEnum eEnum) {
        Iterator literals = eEnum.getELiterals().iterator();
        block0: while (literals.hasNext()) {
            EEnumLiteral eEnumLiteral = (EEnumLiteral)literals.next();
            for (EEnumLiteral otherLiteral : eEnum.getELiterals()) {
                if (eEnumLiteral == otherLiteral) continue block0;
                if (!eEnumLiteral.getName().equalsIgnoreCase(otherLiteral.getName())) continue;
                this.error(RoseImporterPlugin.INSTANCE.getString("_UI_DuplicateLiteral_message", new Object[]{eEnumLiteral.getName(), eEnum.getName()}));
                literals.remove();
                continue block0;
            }
        }
        return this;
    }

    protected Object validateEClass(EClass eClass) {
        ArrayList<EReference> oppositesToRemove = new ArrayList<EReference>();
        Iterator features = eClass.getEStructuralFeatures().iterator();
        block2: while (features.hasNext()) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)features.next();
            if (eStructuralFeature instanceof EAttribute) {
                EAttribute eAttribute = (EAttribute)eStructuralFeature;
                if (this.unsettablePrimitive) {
                    try {
                        EDataType eDataType = eAttribute.getEAttributeType();
                        if (eDataType instanceof EEnum || eDataType.getInstanceClass().isPrimitive()) {
                            eAttribute.setUnsettable(true);
                        }
                    }
                    catch (Exception eDataType) {
                        // empty catch block
                    }
                }
                for (EStructuralFeature otherFeature : eClass.getEAllStructuralFeatures()) {
                    if (eAttribute == otherFeature) continue block2;
                    if (eAttribute.getName().equalsIgnoreCase(otherFeature.getName())) {
                        this.error(RoseImporterPlugin.INSTANCE.getString("_UI_DuplicateAttribute_message", new Object[]{eAttribute.getName(), eClass.getName()}));
                        features.remove();
                        continue block2;
                    }
                    if (eAttribute.getEAttributeType().isSerializable() || eAttribute.isTransient() || "org.eclipse.emf.ecore.util.FeatureMap$Entry".equals(eAttribute.getEAttributeType().getInstanceClassName())) continue;
                    this.error(RoseImporterPlugin.INSTANCE.getString("_UI_TheAttributeShouldBeTransient_message", new Object[]{eAttribute.getName(), eAttribute.getEType().getName()}));
                    continue block2;
                }
                continue;
            }
            EReference eReference = (EReference)eStructuralFeature;
            EReference opposite = eReference.getEOpposite();
            if (opposite != null) {
                if (opposite.eContainer() == null) {
                    this.error(RoseImporterPlugin.INSTANCE.getString("_UI_AnAssociationHasADanglingEnd_message", new Object[]{opposite.getName(), eReference.getName()}));
                    opposite = null;
                    eReference.setEOpposite(null);
                } else if (opposite.isContainment()) {
                    eReference.setTransient(true);
                    if (eReference.getUpperBound() != 1) {
                        if (this.bounded.contains(eReference)) {
                            this.error(RoseImporterPlugin.INSTANCE.getString("_UI_ContainerRelationUpperBound_message", new Object[]{opposite.getName(), eReference.getName()}));
                        }
                        eReference.setUpperBound(1);
                    }
                }
            }
            if (eReference.isTransient() && !eReference.isVolatile() && opposite != null && !opposite.isTransient() && opposite.isResolveProxies() && !opposite.isContainment()) {
                this.error(RoseImporterPlugin.INSTANCE.getString("_UI_CrossDocumentBidirectionalTransient_message", new Object[]{opposite.getName(), eReference.getName()}));
            }
            for (Iterator otherFeature : eClass.getEAllStructuralFeatures()) {
                if (eReference == otherFeature) break;
                if (!eReference.getName().equalsIgnoreCase(otherFeature.getName())) continue;
                this.error(RoseImporterPlugin.INSTANCE.getString("_UI_DuplicateReference_message", new Object[]{eReference.getName(), eClass.getName()}));
                if (opposite != null) {
                    oppositesToRemove.add(opposite);
                }
                features.remove();
                break;
            }
            if (eReference.isContainer() || !"java.util.Map$Entry".equals(eReference.getEType().getInstanceClassName()) || eReference.isContainment() && eReference.isMany()) continue;
            this.error(RoseImporterPlugin.INSTANCE.getString("_UI_MultiplicityManyContainmentIsAssumedFor_message", new Object[]{eReference.getName(), eClass.getName()}));
            eReference.setContainment(true);
            eReference.setUpperBound(-1);
        }
        for (EReference opposite : oppositesToRemove) {
            EClass oppositeEClass = opposite.getEContainingClass();
            if (oppositeEClass == null) continue;
            oppositeEClass.getEStructuralFeatures().remove((Object)opposite);
        }
        for (EOperation eOperation : eClass.getEOperations()) {
            EClassifier opType = eOperation.getEType();
            if (opType instanceof EClass && "java.util.Map$Entry".equals(opType.getInstanceClassName()) && !eOperation.isMany()) {
                this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_MultiplicityManyIsAssumedForOperation_message", new Object[]{eOperation.getName(), eClass.getName()}));
                eOperation.setUpperBound(-1);
            }
            for (EParameter eParameter : eOperation.getEParameters()) {
                EClassifier paramType = eParameter.getEType();
                if (!(paramType instanceof EClass) || !"java.util.Map$Entry".equals(paramType.getInstanceClassName()) || eParameter.isMany()) continue;
                this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_MultiplicityManyIsAssumedForParameter_message", new Object[]{eParameter.getName(), eOperation.getName(), eClass.getName()}));
                eParameter.setUpperBound(-1);
            }
        }
        if (eClass.getESuperTypes().size() > 1) {
            Iterator superTypes = eClass.getESuperTypes().iterator();
            superTypes.next();
            block8: while (superTypes.hasNext()) {
                EClass superType = (EClass)superTypes.next();
                block9: for (EStructuralFeature superFeature : superType.getEAllStructuralFeatures()) {
                    for (Iterator otherFeature : eClass.getEAllStructuralFeatures()) {
                        if (superFeature == otherFeature) continue block9;
                        if (!superFeature.getName().equalsIgnoreCase(otherFeature.getName())) continue;
                        this.error(RoseImporterPlugin.INSTANCE.getString("_UI_DuplicateFeatureInheritance_message", new Object[]{superFeature.getName(), eClass.getName(), superType.getName()}));
                        superTypes.remove();
                        continue block8;
                    }
                }
            }
        }
        if ("java.util.Map$Entry".equals(eClass.getInstanceClassName())) {
            EStructuralFeature keyFeature = eClass.getEStructuralFeature("key");
            EStructuralFeature valueFeature = eClass.getEStructuralFeature("value");
            if (keyFeature == null) {
                this.error(RoseImporterPlugin.INSTANCE.getString("_UI_ExpectingFeatureNamedKey_message", new Object[]{eClass.getName()}));
                eClass.setInstanceClassName(null);
            }
            if (valueFeature == null) {
                this.error(RoseImporterPlugin.INSTANCE.getString("_UI_ExpectingFeatureNamedValue_message", new Object[]{eClass.getName()}));
                eClass.setInstanceClassName(null);
            }
        }
        return this;
    }

    public void setEReferences() {
        for (EReference eReference : this.roseUtil.refTable.keySet()) {
            String quid = this.roseUtil.refTable.get(eReference);
            TableObject tableObject = (TableObject)this.roseUtil.quidTable.get(quid);
            if (tableObject == null) continue;
            Object struct = tableObject.getObject();
            if (struct instanceof EClass) {
                ((EClass)struct).getEStructuralFeatures().add(-1 - Collections.binarySearch(((EClass)struct).getEStructuralFeatures(), eReference, this.eStructuralFeatureComparator), (Object)eReference);
                continue;
            }
            this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_CannotAddReference_message", new Object[]{eReference.getName(), tableObject.getName()}));
        }
        for (Map.Entry entry : this.eStructuralFeatureToXMLNamespaceMap.entrySet()) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)entry.getKey();
            if (eStructuralFeature.eContainer() == null) continue;
            ExtendedMetaData.INSTANCE.setNamespace((EStructuralFeature)entry.getKey(), (String)entry.getValue());
        }
    }

    public void setETypeClassifier() {
        for (EObject element : this.roseUtil.typeTable.keySet()) {
            EStructuralFeature eStructuralFeature;
            EClassifier eType;
            String type = this.roseUtil.typeTable.get(element);
            int position = -1;
            if (element instanceof EAnnotation) {
                position = Integer.parseInt((String)((EAnnotation)element).getDetails().get((Object)"position"));
                element = (EObject)((EAnnotation)element).getReferences().get(0);
            }
            TableObject tableObj = null;
            ETypeParameter resolvedETypeParameter = null;
            if (type.indexOf(".") == -1) {
                String qualifier = "";
                EObject parent = element.eContainer();
                block1: while (parent != null) {
                    if (parent instanceof EClass || parent instanceof EOperation) {
                        for (ETypeParameter eTypeParameter : parent instanceof EClass ? ((EClass)parent).getETypeParameters() : ((EOperation)parent).getETypeParameters()) {
                            if (!type.equals(eTypeParameter.getName())) continue;
                            resolvedETypeParameter = eTypeParameter;
                            break block1;
                        }
                    }
                    if (parent instanceof EPackage) {
                        qualifier = String.valueOf(((EPackage)parent).getName()) + "." + qualifier;
                    }
                    parent = parent.eContainer();
                }
                if (resolvedETypeParameter == null) {
                    tableObj = (TableObject)this.roseUtil.nameTable.get(String.valueOf(qualifier) + type);
                }
            }
            if (resolvedETypeParameter == null && tableObj == null) {
                tableObj = (TableObject)this.roseUtil.nameTable.get(type);
            }
            if (tableObj != null && tableObj.getObject() != null && (element instanceof ETypedElement || element instanceof EGenericType)) {
                eType = (EClassifier)tableObj.getObject();
            } else if (resolvedETypeParameter == null) {
                eType = this.getBasicType(type);
                if (eType == null) {
                    EObject eNamedElement = element;
                    while (!(eNamedElement instanceof ENamedElement)) {
                        eNamedElement = eNamedElement.eContainer();
                    }
                    this.warning(RoseImporterPlugin.INSTANCE.getString("_UI_UnresolvedTypeNameFor_message", new Object[]{type, ((ENamedElement)eNamedElement).getName()}));
                    eType = this.getBasicType("EString");
                }
            } else {
                eType = this.getBasicType("EString");
            }
            EGenericType eGenericType = null;
            if (element instanceof EGenericType) {
                eGenericType = (EGenericType)element;
                if (resolvedETypeParameter == null) {
                    eGenericType.setEClassifier(eType);
                } else {
                    eGenericType.setETypeParameter(resolvedETypeParameter);
                }
                element = element.eContainer();
            }
            if (element instanceof EAttribute && eType instanceof EClass || this.attributesToConvert.contains(element)) {
                EAttribute eAttribute = (EAttribute)element;
                EReference eReference = EcoreFactory.eINSTANCE.createEReference();
                RoseNode roseNode = this.eModelElementToRoseNodeMap.remove(eAttribute);
                eReference.setName(eAttribute.getName());
                eReference.setTransient(eAttribute.isTransient());
                eReference.setVolatile(eAttribute.isVolatile());
                eReference.setDerived(eAttribute.isDerived());
                eReference.setChangeable(eAttribute.isChangeable());
                eReference.setLowerBound(eAttribute.getLowerBound());
                eReference.setUpperBound(eAttribute.getUpperBound());
                eReference.setContainment(roseNode == null || !"by reference".equalsIgnoreCase(roseNode.getContainment()));
                eReference.setResolveProxies(false);
                eReference.getEAnnotations().addAll((Collection)eAttribute.getEAnnotations());
                eReference.setUnsettable(eAttribute.isUnsettable());
                eReference.setOrdered(eAttribute.isOrdered());
                eReference.setUnique(eAttribute.isUnique());
                this.eStructuralFeatures.set(this.eStructuralFeatures.indexOf(eAttribute), (EStructuralFeature)eReference);
                EClass containingClass = eAttribute.getEContainingClass();
                containingClass.getEStructuralFeatures().add(containingClass.getEStructuralFeatures().indexOf((Object)eAttribute), (Object)eReference);
                containingClass.getEStructuralFeatures().remove((Object)eAttribute);
                element = eReference;
            } else if (element instanceof EReference) {
                EReference eReference = (EReference)element;
                boolean convert = eType instanceof EDataType;
                int kind = ExtendedMetaData.INSTANCE.getFeatureKind((EStructuralFeature)eReference);
                if (kind == 3 || kind == 5 || kind == 6) {
                    convert = true;
                    eType = EcorePackage.Literals.EFEATURE_MAP_ENTRY;
                }
                if (convert) {
                    EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
                    eAttribute.setName(eReference.getName());
                    eAttribute.setTransient(eReference.isTransient());
                    eAttribute.setVolatile(eReference.isVolatile());
                    eAttribute.setDerived(eReference.isDerived());
                    eAttribute.setChangeable(eReference.isChangeable());
                    eAttribute.setLowerBound(eReference.getLowerBound());
                    eAttribute.setUpperBound(eReference.getUpperBound());
                    eAttribute.getEAnnotations().addAll((Collection)eReference.getEAnnotations());
                    eAttribute.setUnsettable(eReference.isUnsettable());
                    eAttribute.setOrdered(eReference.isOrdered());
                    eAttribute.setUnique(eReference.isUnique());
                    this.eStructuralFeatures.set(this.eStructuralFeatures.indexOf(eReference), (EStructuralFeature)eAttribute);
                    EClass containingClass = eReference.getEContainingClass();
                    if (containingClass != null) {
                        containingClass.getEStructuralFeatures().add(containingClass.getEStructuralFeatures().indexOf((Object)eReference), (Object)eAttribute);
                        containingClass.getEStructuralFeatures().remove((Object)eReference);
                    }
                    element = eAttribute;
                }
            }
            if (element instanceof EDataType) {
                if (eGenericType != null) continue;
                ((EDataType)element).setInstanceClassName(eType.getInstanceClassName());
                continue;
            }
            if (position != -1) {
                EList exceptions = ((EOperation)element).getEExceptions();
                if (exceptions.contains(eType)) continue;
                if (position < exceptions.size()) {
                    exceptions.add(position, eType);
                    continue;
                }
                exceptions.add(eType);
                continue;
            }
            if (!(element instanceof ETypedElement)) continue;
            if (eGenericType != null) {
                if (!(element instanceof EOperation) || !((EOperation)element).getEGenericExceptions().contains((Object)eGenericType)) {
                    ((ETypedElement)element).setEGenericType(eGenericType);
                }
            } else {
                ((ETypedElement)element).setEType(eType);
            }
            if (!(element instanceof EStructuralFeature) || !"".equals((eStructuralFeature = (EStructuralFeature)element).getName())) continue;
            eStructuralFeature.setName(eType.getName());
        }
    }

    protected EClassifier getBasicType(String value) {
        if (value.equals("boolean") || value.equalsIgnoreCase("eboolean")) {
            return EcorePackage.Literals.EBOOLEAN;
        }
        if (value.equalsIgnoreCase("boolean") || value.equalsIgnoreCase("ebooleanobject")) {
            return EcorePackage.Literals.EBOOLEAN_OBJECT;
        }
        if (value.equalsIgnoreCase("string") || value.equalsIgnoreCase("estring")) {
            return EcorePackage.Literals.ESTRING;
        }
        if (value.equalsIgnoreCase("char") || value.equalsIgnoreCase("echar")) {
            return EcorePackage.Literals.ECHAR;
        }
        if (value.equalsIgnoreCase("character") || value.equalsIgnoreCase("echaracterobject")) {
            return EcorePackage.Literals.ECHARACTER_OBJECT;
        }
        if (value.equals("double") || value.equalsIgnoreCase("edouble") || value.equalsIgnoreCase("currency")) {
            return EcorePackage.Literals.EDOUBLE;
        }
        if (value.equalsIgnoreCase("double") || value.equalsIgnoreCase("edoubleobject")) {
            return EcorePackage.Literals.EDOUBLE_OBJECT;
        }
        if (value.equalsIgnoreCase("int") || value.equalsIgnoreCase("eint")) {
            return EcorePackage.Literals.EINT;
        }
        if (value.equalsIgnoreCase("integer") || value.equalsIgnoreCase("eintegerobject")) {
            return EcorePackage.Literals.EINTEGER_OBJECT;
        }
        if (value.equals("long long") || value.equals("long") || value.equalsIgnoreCase("elong")) {
            return EcorePackage.Literals.ELONG;
        }
        if (value.equalsIgnoreCase("long") || value.equalsIgnoreCase("elongobject")) {
            return EcorePackage.Literals.ELONG_OBJECT;
        }
        if (value.equals("float") || value.equalsIgnoreCase("efloat") || value.equalsIgnoreCase("single")) {
            return EcorePackage.Literals.EFLOAT;
        }
        if (value.equalsIgnoreCase("float") || value.equalsIgnoreCase("efloatobject")) {
            return EcorePackage.Literals.EFLOAT_OBJECT;
        }
        if (value.equals("short") || value.equalsIgnoreCase("eshort")) {
            return EcorePackage.Literals.ESHORT;
        }
        if (value.equalsIgnoreCase("short") || value.equalsIgnoreCase("eshortobject")) {
            return EcorePackage.Literals.ESHORT_OBJECT;
        }
        if (value.equals("byte") || value.equalsIgnoreCase("ebyte")) {
            return EcorePackage.Literals.EBYTE;
        }
        if (value.equals("byte[]") || value.equalsIgnoreCase("ebytearray") || value.equalsIgnoreCase("ebyte[]")) {
            return EcorePackage.Literals.EBYTE_ARRAY;
        }
        if (value.equalsIgnoreCase("byte") || value.equalsIgnoreCase("ebyteObject")) {
            return EcorePackage.Literals.EBYTE_OBJECT;
        }
        if (value.equalsIgnoreCase("ebigdecimal")) {
            return EcorePackage.Literals.EBIG_DECIMAL;
        }
        if (value.equalsIgnoreCase("ebiginteger")) {
            return EcorePackage.Literals.EBIG_INTEGER;
        }
        if (value.equalsIgnoreCase("edate")) {
            return EcorePackage.Literals.EDATE;
        }
        if (value.equalsIgnoreCase("eobject")) {
            return EcorePackage.Literals.EOBJECT;
        }
        if (value.equalsIgnoreCase("efeaturemapentry")) {
            return EcorePackage.Literals.EFEATURE_MAP_ENTRY;
        }
        return null;
    }

    public void createEPackageForRootClasses(EList<EObject> extent, RoseNode roseNode, String packageName) {
        ArrayList<EObject> list = new ArrayList<EObject>();
        for (EObject eObject : extent) {
            if (eObject instanceof EPackage) continue;
            list.add(eObject);
        }
        if (!list.isEmpty()) {
            EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
            this.setEPackageProperties(roseNode, ePackage, packageName.toLowerCase());
            extent.add((Object)ePackage);
            for (EClassifier eClassifier : list) {
                ePackage.getEClassifiers().add((Object)eClassifier);
                extent.remove((Object)eClassifier);
            }
        }
    }

    protected void build(RoseNode roseNode, Object parent, ENamedElement eNamedElement) {
        TableObject tableObj;
        String quid = roseNode.getRoseId();
        if (quid != null && !quid.equals("")) {
            quid = quid.substring(1, quid.length() - 1);
        }
        if ((tableObj = (TableObject)this.roseUtil.quidTable.get(quid)) != null) {
            tableObj.setObject(eNamedElement);
        }
        if (parent instanceof EPackage) {
            ((EPackage)parent).getEClassifiers().add((Object)((EClassifier)eNamedElement));
        } else if (parent instanceof EList) {
            EList namedElements = (EList)parent;
            namedElements.add((Object)eNamedElement);
        }
    }

    protected String upperCaseName(String name) {
        return name != null && name.length() > 0 && Character.isLowerCase(name.charAt(0)) ? String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1) : name;
    }

    protected String validName(String name) {
        return CodeGenUtil.validJavaIdentifier((String)name);
    }

    protected void warning(String message) {
        System.err.println("-->Warning: " + message);
        this.roseUtil.addDiagnostic((Diagnostic)new BasicDiagnostic(2, RoseImporterPlugin.getPlugin().getBundle().getSymbolicName(), 0, message, null));
    }

    protected void error(String message) {
        System.err.println("-->Error: " + message);
        this.roseUtil.addDiagnostic((Diagnostic)new BasicDiagnostic(4, RoseImporterPlugin.getPlugin().getBundle().getSymbolicName(), 0, message, null));
    }

    protected String getQualifiedTypeName(ETypedElement typedElement, String type) {
        return this.getQualifiedTypeName((EModelElement)typedElement, type);
    }

    protected String getQualifiedTypeName(EModelElement eModelElement, String type) {
        if (type == null || type.length() == 0 || "void".equals(type)) {
            return type;
        }
        String qualifiedType = type;
        if (qualifiedType.indexOf("::") != -1) {
            StringTokenizer st = new StringTokenizer(qualifiedType, "::");
            if (st.hasMoreTokens()) {
                st.nextToken();
            }
            StringBuffer stringBuffer = new StringBuffer();
            while (st.hasMoreTokens()) {
                stringBuffer.append(st.nextToken().replace('\"', ' ').replace('[', ' ').replace(']', ' ').trim());
                if (!st.hasMoreTokens()) continue;
                stringBuffer.append(".");
            }
            qualifiedType = stringBuffer.toString();
        }
        if (qualifiedType.indexOf(46) == -1 && eModelElement != null) {
            String qualifier = "";
            EObject parent = eModelElement.eContainer();
            while (parent != null) {
                if (parent instanceof EPackage) {
                    qualifier = String.valueOf(((EPackage)parent).getName()) + "." + qualifier;
                }
                parent = parent.eContainer();
            }
            qualifiedType = String.valueOf(qualifier) + qualifiedType;
        }
        if (!qualifiedType.equals(type) && !this.roseUtil.nameTable.containsKey(qualifiedType)) {
            qualifiedType = type;
        }
        return qualifiedType;
    }
}

