/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJsGlobalScopeContainer;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JsGlobalScopeContainerInitializer;
import org.eclipse.wst.jsdt.core.UnimplementedException;
import org.eclipse.wst.jsdt.core.compiler.libraries.LibraryLocation;
import org.eclipse.wst.jsdt.internal.core.UserLibrary;
import org.eclipse.wst.jsdt.internal.core.UserLibraryJsGlobalScopeContainer;
import org.eclipse.wst.jsdt.internal.core.UserLibraryManager;

public class UserLibraryJsGlobalScopeContainerInitializer
extends JsGlobalScopeContainerInitializer {
    @Override
    public void initialize(IPath containerPath, IJavaScriptProject project) throws CoreException {
        String userLibName;
        UserLibrary entries;
        if (this.isUserLibraryContainer(containerPath) && (entries = UserLibraryManager.getUserLibrary(userLibName = containerPath.segment(1))) != null) {
            UserLibraryJsGlobalScopeContainer container = new UserLibraryJsGlobalScopeContainer(userLibName);
            JavaScriptCore.setJsGlobalScopeContainer(containerPath, new IJavaScriptProject[]{project}, new IJsGlobalScopeContainer[]{container}, null);
        }
    }

    private boolean isUserLibraryContainer(IPath path) {
        return path != null && path.segmentCount() == 2 && "org.eclipse.wst.jsdt.USER_LIBRARY".equals(path.segment(0));
    }

    @Override
    public boolean canUpdateJsGlobalScopeContainer(IPath containerPath, IJavaScriptProject project) {
        return this.isUserLibraryContainer(containerPath);
    }

    @Override
    public void requestJsGlobalScopeContainerUpdate(IPath containerPath, IJavaScriptProject project, IJsGlobalScopeContainer containerSuggestion) throws CoreException {
        if (this.isUserLibraryContainer(containerPath)) {
            String name = containerPath.segment(1);
            if (containerSuggestion != null) {
                UserLibrary library = new UserLibrary(containerSuggestion.getIncludepathEntries(), containerSuggestion.getKind() == 2);
                UserLibraryManager.setUserLibrary(name, library, null);
            } else {
                UserLibraryManager.setUserLibrary(name, null, null);
            }
        }
    }

    @Override
    public String getDescription(IPath containerPath, IJavaScriptProject project) {
        if (this.isUserLibraryContainer(containerPath)) {
            return containerPath.segment(1);
        }
        return super.getDescription(containerPath, project);
    }

    @Override
    public Object getComparisonID(IPath containerPath, IJavaScriptProject project) {
        return containerPath;
    }

    @Override
    public LibraryLocation getLibraryLocation() {
        throw new UnimplementedException();
    }
}

