/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xycharts;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.ITmfChartTimeProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfBaseProvider;
import org.swtchart.IAxis;
import org.swtchart.Range;

public class TmfMouseWheelZoomProvider
extends TmfBaseProvider
implements MouseWheelListener {
    private static final double ZOOM_FACTOR = 0.8;
    private static final long MIN_WINDOW_SIZE = 1L;

    public TmfMouseWheelZoomProvider(ITmfChartTimeProvider tmfChartViewer) {
        super(tmfChartViewer);
        this.register();
    }

    @Override
    public void register() {
        this.getChart().getPlotArea().addMouseWheelListener((MouseWheelListener)this);
    }

    @Override
    public void deregister() {
        if (this.getChartViewer().getControl() != null && !this.getChartViewer().getControl().isDisposed()) {
            this.getChart().getPlotArea().removeMouseWheelListener((MouseWheelListener)this);
        }
    }

    @Override
    public void refresh() {
    }

    public synchronized void mouseScrolled(MouseEvent event) {
        ITmfChartTimeProvider viewer = this.getChartViewer();
        int count = event.count;
        if (count != 0) {
            if ((event.stateMask & 0x40000) != 0) {
                int x = event.x;
                this.zoom(viewer, count, x);
            } else if ((event.stateMask & 0x20000) != 0) {
                this.scroll(viewer, count);
            }
        }
    }

    private void scroll(ITmfChartTimeProvider viewer, int count) {
        IAxis xAxis = this.getChart().getAxisSet().getXAxis(0);
        long windowStartTime = viewer.getWindowStartTime();
        long windowsEndTime = viewer.getWindowEndTime();
        long startTime = viewer.getStartTime();
        long endTime = viewer.getEndTime();
        long range = windowsEndTime - windowStartTime;
        if (range <= 0L) {
            return;
        }
        long increment = Math.max(1L, range / 2L);
        if (count > 0) {
            windowStartTime = Math.max(windowStartTime - increment, startTime);
            windowsEndTime = windowStartTime + range;
        } else {
            windowsEndTime = Math.min(windowsEndTime + increment, endTime);
            windowStartTime = windowsEndTime - range;
        }
        viewer.updateWindow(windowStartTime, windowsEndTime);
        xAxis.setRange(new Range((double)(windowStartTime - viewer.getTimeOffset()), (double)(windowsEndTime - viewer.getTimeOffset())));
    }

    private void zoom(ITmfChartTimeProvider viewer, int count, int x) {
        long newDuration = viewer.getWindowDuration();
        if (newDuration == 0L || count == 0) {
            return;
        }
        double ratio = 1.0;
        if (count > 0) {
            ratio = 0.8;
            newDuration = Math.round(0.8 * (double)newDuration);
        } else {
            ratio = 1.25;
            newDuration = (long)Math.ceil((double)newDuration * ratio);
        }
        newDuration = Math.max(1L, newDuration);
        IAxis xAxis = this.getChart().getAxisSet().getXAxis(0);
        long timeAtXPos = this.limitXDataCoordinate(xAxis.getDataCoordinate(x)) + viewer.getTimeOffset();
        long newWindowStartTime = timeAtXPos - Math.round(ratio * (double)(timeAtXPos - viewer.getWindowStartTime()));
        long newWindowEndTime = this.validateWindowEndTime(newWindowStartTime, newWindowStartTime + newDuration);
        newWindowStartTime = this.validateWindowStartTime(newWindowStartTime);
        viewer.updateWindow(newWindowStartTime, newWindowEndTime);
        xAxis.setRange(new Range((double)(newWindowStartTime - viewer.getTimeOffset()), (double)(newWindowEndTime - viewer.getTimeOffset())));
    }

    private long validateWindowStartTime(long start) {
        ITmfChartTimeProvider viewer = this.getChartViewer();
        long realStart = start;
        long startTime = viewer.getStartTime();
        long endTime = viewer.getEndTime();
        if (realStart < startTime) {
            realStart = startTime;
        }
        if (realStart > endTime) {
            realStart = endTime;
        }
        return realStart;
    }

    private long validateWindowEndTime(long start, long end) {
        long realEnd = end;
        ITmfChartTimeProvider viewer = this.getChartViewer();
        long endTime = viewer.getEndTime();
        if (realEnd > endTime) {
            realEnd = endTime;
        }
        if (realEnd < start + 1L) {
            realEnd = start + 1L;
        }
        return realEnd;
    }
}

