/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.refactoring.includes.IHeaderChooser;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class InteractiveHeaderChooser
implements IHeaderChooser {
    private final String title;
    private final Shell shell;
    private final Map<Collection<IPath>, IPath> userChoiceCache;

    public InteractiveHeaderChooser(String title, Shell shell) {
        this.title = title;
        this.shell = shell;
        this.userChoiceCache = new HashMap<Collection<IPath>, IPath>();
    }

    @Override
    public IPath chooseHeader(final String bindingName, Collection<IPath> headers) {
        if (headers.isEmpty()) {
            return null;
        }
        if (headers.size() == 1) {
            return headers.iterator().next();
        }
        HashSet<IPath> cacheKey = new HashSet<IPath>(headers);
        if (this.userChoiceCache.containsKey(cacheKey)) {
            return this.userChoiceCache.get(cacheKey);
        }
        final IPath[] elemArray = headers.toArray(new IPath[headers.size()]);
        final IPath[] selectedElement = new IPath[1];
        this.runInUIThread(new Runnable(){

            @Override
            public void run() {
                if (!InteractiveHeaderChooser.this.shell.isDisposed()) {
                    ElementListSelectionDialog dialog = new ElementListSelectionDialog(InteractiveHeaderChooser.this.shell, (ILabelProvider)new LabelProvider());
                    dialog.setElements((Object[])elemArray);
                    dialog.setTitle(InteractiveHeaderChooser.this.title);
                    dialog.setMessage(NLS.bind((String)CEditorMessages.OrganizeIncludes_choose_header, (Object)bindingName));
                    if (dialog.open() == 0) {
                        selectedElement[0] = (IPath)dialog.getFirstResult();
                    }
                }
            }
        });
        IPath selectedHeader = selectedElement[0];
        if (selectedHeader != null) {
            this.userChoiceCache.put(headers, selectedHeader);
        }
        return selectedHeader;
    }

    private void runInUIThread(Runnable runnable) {
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            Display.getDefault().syncExec(runnable);
        }
    }
}

