/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui.state;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.CommonListenerList;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.internal.context.ui.state.ContextState;
import org.eclipse.mylyn.internal.context.ui.state.ContextStateParticipant;
import org.eclipse.ui.XMLMemento;

public class ContextStateManager {
    private static final String TAG_CONTEXT_STATE = "ContextState";
    private static final String CHARSET = "UTF-8";
    private final CommonListenerList<ContextStateParticipant> participants = new CommonListenerList("org.eclipse.mylyn.context.ui");
    private final ContextState defaultState = this.createMemento(null, "default");

    public void addParticipant(ContextStateParticipant participant) {
        this.participants.add((Object)participant);
    }

    public void clearState(final String contextHandle, final boolean isActiveContext) {
        this.participants.notify((CommonListenerList.Notifier)new CommonListenerList.Notifier<ContextStateParticipant>(){

            public void run(ContextStateParticipant participant) throws Exception {
                participant.clearState(contextHandle, isActiveContext);
            }
        });
    }

    public ContextState createMemento(IInteractionContext context, String contextHandle) {
        return new ContextState(context, contextHandle, XMLMemento.createWriteRoot((String)TAG_CONTEXT_STATE));
    }

    public ContextState read(IInteractionContext context, InputStream in) {
        ContextState memento;
        block8: {
            memento = null;
            if (in != null) {
                ContextState contextState;
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, CHARSET));
                try {
                    XMLMemento xmlMemento = XMLMemento.createReadRoot((Reader)reader);
                    contextState = new ContextState(context, context.getHandleIdentifier(), xmlMemento);
                }
                catch (Throwable throwable) {
                    try {
                        reader.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Failed to restore context state", (Throwable)e));
                        break block8;
                    }
                    catch (CoreException e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Failed to restore context state", (Throwable)e));
                    }
                }
                reader.close();
                return contextState;
            }
        }
        if (memento == null) {
            memento = this.createMemento(context, context.getHandleIdentifier());
        }
        return memento;
    }

    public void removeParticipant(ContextStateParticipant participant) {
        this.participants.remove((Object)participant);
    }

    public void restoreDefaultState() {
        this.participants.notify((CommonListenerList.Notifier)new CommonListenerList.Notifier<ContextStateParticipant>(){

            public void run(ContextStateParticipant participant) throws Exception {
                if (participant.isEnabled()) {
                    participant.restoreDefaultState(ContextStateManager.this.defaultState);
                }
            }
        });
    }

    public void restoreState(IInteractionContext context, InputStream in) {
        final ContextState memento = this.read(context, in);
        this.participants.notify((CommonListenerList.Notifier)new CommonListenerList.Notifier<ContextStateParticipant>(){

            public void run(ContextStateParticipant participant) throws Exception {
                if (participant.isEnabled()) {
                    participant.restoreState(memento);
                }
            }
        });
    }

    public void saveDefaultState() {
        this.participants.notify((CommonListenerList.Notifier)new CommonListenerList.Notifier<ContextStateParticipant>(){

            public void run(ContextStateParticipant participant) throws Exception {
                if (participant.isEnabled()) {
                    participant.saveDefaultState(ContextStateManager.this.defaultState);
                }
            }
        });
    }

    public void saveState(IInteractionContext context, OutputStream storable) {
        this.saveState(context, storable, false);
    }

    public void saveState(IInteractionContext context, OutputStream storable, final boolean allowModifications) {
        final ContextState memento = this.createMemento(context, context.getHandleIdentifier());
        this.participants.notify((CommonListenerList.Notifier)new CommonListenerList.Notifier<ContextStateParticipant>(){

            public void run(ContextStateParticipant participant) throws Exception {
                if (participant.isEnabled()) {
                    participant.saveState(memento, allowModifications);
                }
            }
        });
        this.write(storable, memento);
    }

    public void write(OutputStream out, ContextState memento) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, CHARSET));){
            memento.getMemento().save((Writer)writer);
        }
        catch (IOException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Failed to save context state", (Throwable)e));
        }
    }
}

