/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.sql.ResultSet;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObject;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableBase;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTrigger;

public abstract class SQLServerTriggerBase<OWNER extends DBSObject>
implements DBSTrigger,
DBPScriptObject,
DBPQualifiedObject,
DBPRefreshableObject,
SQLServerObject {
    private OWNER container;
    private String name;
    private String type;
    private String body;
    private long objectId;
    private boolean insteadOfTrigger;
    private boolean disabled;
    private boolean persisted;

    public SQLServerTriggerBase(OWNER container, ResultSet dbResult) {
        this.container = container;
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"name");
        this.type = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"type");
        this.objectId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"object_id");
        this.insteadOfTrigger = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"is_instead_of_trigger") != 0;
        this.disabled = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"is_disabled") != 0;
        this.persisted = true;
    }

    public SQLServerTriggerBase(OWNER container, String name) {
        this.container = container;
        this.name = name;
        this.body = "";
        this.persisted = false;
    }

    public SQLServerTriggerBase(OWNER container, SQLServerTriggerBase source) {
        this.container = container;
        this.name = source.name;
        this.type = source.type;
        this.body = source.body;
        this.persisted = source.persisted;
    }

    @Property(viewable=true, order=1)
    public String getName() {
        return this.name;
    }

    @Property(viewable=false, order=10)
    public long getObjectId() {
        return this.objectId;
    }

    @Property(viewable=true, order=11)
    public boolean isInsteadOfTrigger() {
        return this.insteadOfTrigger;
    }

    @Property(viewable=false, order=20)
    public boolean isDisabled() {
        return this.disabled;
    }

    public String getBody() {
        return this.body;
    }

    public OWNER getParentObject() {
        return this.container;
    }

    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    @NotNull
    public SQLServerDataSource getDataSource() {
        return (SQLServerDataSource)this.container.getDataSource();
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (this.body == null) {
            OWNER owner = this.getParentObject();
            SQLServerDatabase database = null;
            if (owner instanceof SQLServerDatabase) {
                database = (SQLServerDatabase)owner;
            } else if (owner instanceof SQLServerTableBase) {
                database = ((SQLServerTableBase)owner).getDatabase();
            }
            this.body = SQLServerUtils.extractSource(monitor, database, this);
        }
        return this.body;
    }
}

