/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObject;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObjectType;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerProcedureParameter;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractProcedure;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class SQLServerProcedure
extends AbstractProcedure<SQLServerDataSource, SQLServerSchema>
implements DBPRefreshableObject,
DBPScriptObject,
SQLServerObject {
    private static final Log log = Log.getLog(SQLServerProcedure.class);
    private DBSProcedureType procedureType;
    private String body;
    private long objectId;
    private SQLServerObjectType objectType;

    public SQLServerProcedure(SQLServerSchema schema) {
        super((DBSObjectContainer)schema, false);
        this.procedureType = DBSProcedureType.PROCEDURE;
    }

    public SQLServerProcedure(SQLServerSchema catalog, ResultSet dbResult) {
        super((DBSObjectContainer)catalog, true);
        this.loadInfo(dbResult);
    }

    private void loadInfo(ResultSet dbResult) {
        this.objectId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"object_id");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"name");
        this.objectType = SQLServerObjectType.P;
        try {
            this.objectType = SQLServerObjectType.valueOf(JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"type"));
        }
        catch (IllegalArgumentException e) {
            log.debug((Object)"Bad procedure type", (Throwable)e);
        }
        switch (this.objectType) {
            case P: 
            case PC: 
            case X: {
                this.procedureType = DBSProcedureType.PROCEDURE;
                break;
            }
            default: {
                this.procedureType = DBSProcedureType.FUNCTION;
            }
        }
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"description");
    }

    @Property(viewable=false, order=2)
    public long getObjectId() {
        return this.objectId;
    }

    public SQLServerObjectType getObjectType() {
        return this.objectType;
    }

    @Property(order=5)
    public DBSProcedureType getProcedureType() {
        return this.procedureType;
    }

    public void setProcedureType(DBSProcedureType procedureType) {
        this.procedureType = procedureType;
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getDeclaration(DBRProgressMonitor monitor) throws DBException {
        if (this.body == null) {
            this.body = !this.persisted ? "CREATE " + this.getProcedureType().name() + " " + this.getFullyQualifiedName(DBPEvaluationContext.DDL) + "()" + GeneralUtils.getDefaultLineSeparator() + (this.procedureType == DBSProcedureType.FUNCTION ? "RETURNS INT" + GeneralUtils.getDefaultLineSeparator() : "") + "BEGIN" + GeneralUtils.getDefaultLineSeparator() + "END" : SQLServerUtils.extractSource(monitor, ((SQLServerSchema)this.getContainer()).getDatabase(), (SQLServerSchema)this.getContainer(), this.getName());
        }
        return this.body;
    }

    private String normalizeCreateStatement(String createDDL) {
        String procType = this.getProcedureType().name();
        int divPos = createDDL.indexOf(String.valueOf(procType) + " `");
        if (divPos != -1) {
            return String.valueOf(createDDL.substring(0, divPos)) + procType + " `" + ((SQLServerSchema)this.getContainer()).getName() + "`." + createDDL.substring(divPos + procType.length() + 1);
        }
        return createDDL;
    }

    public Collection<SQLServerProcedureParameter> getParameters(DBRProgressMonitor monitor) throws DBException {
        return ((SQLServerSchema)this.getContainer()).getProcedureCache().getChildren(monitor, (DBSObject)((SQLServerSchema)this.getContainer()), (DBSObject)this);
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getContainer(), this});
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return this.getDeclaration(monitor);
    }

    public void setObjectDefinitionText(String sourceText) throws DBException {
        this.body = sourceText;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this;
    }

    public String toString() {
        return String.valueOf(this.procedureType.name()) + " " + this.getName();
    }
}

