/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.managers;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.IValueEditor;
import org.jkiss.dbeaver.ui.data.dialogs.DefaultValueViewDialog;
import org.jkiss.dbeaver.ui.data.managers.BaseValueManager;
import org.jkiss.dbeaver.ui.data.managers.GeometryInlineEditor;

public class GeometryValueManager
extends BaseValueManager {
    private static final Log log = Log.getLog(GeometryValueManager.class);

    @NotNull
    public IValueController.EditType[] getSupportedEditTypes() {
        return new IValueController.EditType[]{IValueController.EditType.INLINE, IValueController.EditType.PANEL, IValueController.EditType.EDITOR};
    }

    public IValueEditor createEditor(@NotNull IValueController controller) throws DBException {
        switch (controller.getEditType()) {
            case INLINE: 
            case PANEL: {
                return new GeometryInlineEditor(controller);
            }
            case EDITOR: {
                return new DefaultValueViewDialog(controller);
            }
        }
        return null;
    }
}

